/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import org.apache.cassandra.utils.NativeLibraryWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeLibraryWindows
implements NativeLibraryWrapper {
    private static final Logger logger = LoggerFactory.getLogger(NativeLibraryWindows.class);
    private static boolean available;

    private static native long GetCurrentProcessId() throws LastErrorException;

    @Override
    public int callMlockall(int flags) throws UnsatisfiedLinkError, RuntimeException {
        throw new UnsatisfiedLinkError();
    }

    @Override
    public int callMunlockall() throws UnsatisfiedLinkError, RuntimeException {
        throw new UnsatisfiedLinkError();
    }

    @Override
    public int callFcntl(int fd, int command, long flags) throws UnsatisfiedLinkError, RuntimeException {
        throw new UnsatisfiedLinkError();
    }

    @Override
    public int callPosixFadvise(int fd, long offset, int len, int flag) throws UnsatisfiedLinkError, RuntimeException {
        throw new UnsatisfiedLinkError();
    }

    @Override
    public int callOpen(String path, int flags) throws UnsatisfiedLinkError, RuntimeException {
        throw new UnsatisfiedLinkError();
    }

    @Override
    public int callFsync(int fd) throws UnsatisfiedLinkError, RuntimeException {
        throw new UnsatisfiedLinkError();
    }

    @Override
    public int callClose(int fd) throws UnsatisfiedLinkError, RuntimeException {
        throw new UnsatisfiedLinkError();
    }

    @Override
    public Pointer callStrerror(int errnum) throws UnsatisfiedLinkError, RuntimeException {
        throw new UnsatisfiedLinkError();
    }

    @Override
    public long callGetpid() throws UnsatisfiedLinkError, RuntimeException {
        return NativeLibraryWindows.GetCurrentProcessId();
    }

    @Override
    public boolean isAvailable() {
        return available;
    }

    static {
        try {
            Native.register((String)"kernel32");
            available = true;
        }
        catch (NoClassDefFoundError e) {
            logger.warn("JNA not found. Native methods will be disabled.");
        }
        catch (UnsatisfiedLinkError e) {
            logger.error("Failed to link the Windows/Kernel32 library against JNA. Native methods will be unavailable.", (Throwable)e);
        }
        catch (NoSuchMethodError e) {
            logger.warn("Obsolete version of JNA present; unable to register Windows/Kernel32 library. Upgrade to JNA 3.2.7 or later");
        }
    }
}

