/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.sun.jmx.remote.internal.RMIExporter;
import com.sun.jmx.remote.security.JMXPluggableAuthenticator;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.rmi.AlreadyBoundException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.MBeanServerForwarder;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import javax.security.auth.Subject;
import org.apache.cassandra.auth.jmx.AuthenticationProxy;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.RMIServerSocketFactoryImpl;
import org.apache.commons.lang3.StringUtils;
import org.cassandraunit.shaded.com.google.common.collect.ImmutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.rmi.registry.RegistryImpl;
import sun.rmi.server.UnicastServerRef2;

public class JMXServerUtils {
    private static final Logger logger = LoggerFactory.getLogger(JMXServerUtils.class);
    private static java.rmi.registry.Registry registry;

    public static JMXConnectorServer createJMXServer(int port, boolean local) throws IOException {
        HashMap<String, Object> env = new HashMap<String, Object>();
        InetAddress serverAddress = null;
        if (local) {
            serverAddress = InetAddress.getLoopbackAddress();
            System.setProperty("java.rmi.server.hostname", serverAddress.getHostAddress());
        }
        env.putAll(JMXServerUtils.configureJmxSocketFactories(serverAddress, local));
        env.putAll(JMXServerUtils.configureJmxAuthentication());
        MBeanServerForwarder authzProxy = JMXServerUtils.configureJmxAuthorization(env);
        env.put("com.sun.jmx.remote.rmi.exporter", new Exporter());
        int rmiPort = Integer.getInteger("com.sun.management.jmxremote.rmi.port", 0);
        JMXConnectorServer jmxServer = JMXConnectorServerFactory.newJMXConnectorServer(new JMXServiceURL("rmi", null, rmiPort), env, ManagementFactory.getPlatformMBeanServer());
        if (authzProxy != null) {
            jmxServer.setMBeanServerForwarder(authzProxy);
        }
        jmxServer.start();
        JMXServerUtils.configureRMIRegistry(port, env);
        JMXServerUtils.logJmxServiceUrl(serverAddress, port);
        return jmxServer;
    }

    private static void configureRMIRegistry(int port, Map<String, Object> env) throws RemoteException {
        Exporter exporter = (Exporter)env.get("com.sun.jmx.remote.rmi.exporter");
        registry = Boolean.getBoolean("com.sun.management.jmxremote.ssl") ? new Registry(port, (RMIClientSocketFactory)env.get("jmx.remote.rmi.client.socket.factory"), (RMIServerSocketFactory)env.get("jmx.remote.rmi.server.socket.factory"), exporter.connectorServer) : new Registry(port, exporter.connectorServer);
    }

    private static Map<String, Object> configureJmxAuthentication() {
        HashMap<String, Object> env = new HashMap<String, Object>();
        if (!Boolean.getBoolean("com.sun.management.jmxremote.authenticate")) {
            return env;
        }
        String configEntry = System.getProperty("cassandra.jmx.remote.login.config");
        if (configEntry != null) {
            env.put("jmx.remote.authenticator", new AuthenticationProxy(configEntry));
        } else {
            String passwordFile = System.getProperty("com.sun.management.jmxremote.password.file");
            if (passwordFile != null) {
                env.put("jmx.remote.x.password.file", passwordFile);
            }
            env.put("jmx.remote.authenticator", new JMXPluggableAuthenticatorWrapper(env));
        }
        return env;
    }

    private static MBeanServerForwarder configureJmxAuthorization(Map<String, Object> env) {
        String authzProxyClass = System.getProperty("cassandra.jmx.authorizer");
        if (authzProxyClass != null) {
            InvocationHandler handler = (InvocationHandler)FBUtilities.construct(authzProxyClass, "JMX authz proxy");
            Class[] interfaces = new Class[]{MBeanServerForwarder.class};
            Object proxy = Proxy.newProxyInstance(MBeanServerForwarder.class.getClassLoader(), interfaces, handler);
            return (MBeanServerForwarder)MBeanServerForwarder.class.cast(proxy);
        }
        String accessFile = System.getProperty("com.sun.management.jmxremote.access.file");
        if (accessFile != null) {
            env.put("jmx.remote.x.access.file", accessFile);
        }
        return null;
    }

    private static Map<String, Object> configureJmxSocketFactories(InetAddress serverAddress, boolean localOnly) {
        HashMap<String, Object> env = new HashMap<String, Object>();
        if (Boolean.getBoolean("com.sun.management.jmxremote.ssl")) {
            boolean requireClientAuth = Boolean.getBoolean("com.sun.management.jmxremote.ssl.need.client.auth");
            String[] protocols = null;
            String protocolList = System.getProperty("com.sun.management.jmxremote.ssl.enabled.protocols");
            if (protocolList != null) {
                System.setProperty("javax.rmi.ssl.client.enabledProtocols", protocolList);
                protocols = StringUtils.split((String)protocolList, (char)',');
            }
            String[] ciphers = null;
            String cipherList = System.getProperty("com.sun.management.jmxremote.ssl.enabled.cipher.suites");
            if (cipherList != null) {
                System.setProperty("javax.rmi.ssl.client.enabledCipherSuites", cipherList);
                ciphers = StringUtils.split((String)cipherList, (char)',');
            }
            SslRMIClientSocketFactory clientFactory = new SslRMIClientSocketFactory();
            SslRMIServerSocketFactory serverFactory = new SslRMIServerSocketFactory(ciphers, protocols, requireClientAuth);
            env.put("jmx.remote.rmi.server.socket.factory", serverFactory);
            env.put("jmx.remote.rmi.client.socket.factory", clientFactory);
            env.put("com.sun.jndi.rmi.factory.socket", clientFactory);
            JMXServerUtils.logJmxSslConfig(serverFactory);
        } else if (localOnly) {
            env.put("jmx.remote.rmi.server.socket.factory", new RMIServerSocketFactoryImpl(serverAddress));
        }
        return env;
    }

    private static void logJmxServiceUrl(InetAddress serverAddress, int port) {
        String urlTemplate = "service:jmx:rmi://%1$s/jndi/rmi://%1$s:%2$d/jmxrmi";
        String hostName = serverAddress == null ? (FBUtilities.getBroadcastAddress() instanceof Inet6Address ? "[::]" : "0.0.0.0") : (serverAddress instanceof Inet6Address ? '[' + serverAddress.getHostAddress() + ']' : serverAddress.getHostAddress());
        String url = String.format(urlTemplate, hostName, port);
        logger.info("Configured JMX server at: {}", (Object)url);
    }

    private static void logJmxSslConfig(SslRMIServerSocketFactory serverFactory) {
        logger.debug("JMX SSL configuration. { protocols: [{}], cipher_suites: [{}], require_client_auth: {} }", new Object[]{serverFactory.getEnabledProtocols() == null ? "'JVM defaults'" : Arrays.stream(serverFactory.getEnabledProtocols()).collect(Collectors.joining("','", "'", "'")), serverFactory.getEnabledCipherSuites() == null ? "'JVM defaults'" : Arrays.stream(serverFactory.getEnabledCipherSuites()).collect(Collectors.joining("','", "'", "'")), serverFactory.getNeedClientAuth()});
    }

    private static class Registry
    extends RegistryImpl {
        private static final String KEY = "jmxrmi";
        private final Remote connectorServer;

        private Registry(int port, Remote connectorServer) throws RemoteException {
            super(port);
            this.connectorServer = connectorServer;
        }

        private Registry(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf, Remote connectorServer) throws RemoteException {
            super(port, csf, ssf);
            this.connectorServer = connectorServer;
        }

        @Override
        public Remote lookup(String name) throws RemoteException, NotBoundException {
            if (name.equals(KEY)) {
                return this.connectorServer;
            }
            throw new NotBoundException(String.format("Only the JMX Connector Server named %s is bound in this registry", KEY));
        }

        @Override
        public void bind(String name, Remote obj) throws RemoteException, AlreadyBoundException {
            throw new UnsupportedOperationException("Unsupported");
        }

        @Override
        public void unbind(String name) throws RemoteException, NotBoundException {
            throw new UnsupportedOperationException("Unsupported");
        }

        @Override
        public void rebind(String name, Remote obj) throws RemoteException {
            throw new UnsupportedOperationException("Unsupported");
        }

        @Override
        public String[] list() throws RemoteException {
            return new String[]{KEY};
        }
    }

    private static class Exporter
    implements RMIExporter {
        private Remote connectorServer;

        private Exporter() {
        }

        public Remote exportObject(Remote obj, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
            Remote remote = new UnicastServerRef2(port, csf, ssf).exportObject(obj, null, true);
            if (this.connectorServer == null) {
                this.connectorServer = remote;
            }
            return remote;
        }

        public boolean unexportObject(Remote obj, boolean force) throws NoSuchObjectException {
            return UnicastRemoteObject.unexportObject(obj, force);
        }
    }

    private static class JMXPluggableAuthenticatorWrapper
    implements JMXAuthenticator {
        final Map<?, ?> env;

        private JMXPluggableAuthenticatorWrapper(Map<?, ?> env) {
            this.env = ImmutableMap.copyOf(env);
        }

        @Override
        public Subject authenticate(Object credentials) {
            JMXPluggableAuthenticator authenticator = new JMXPluggableAuthenticator(this.env);
            return authenticator.authenticate(credentials);
        }
    }
}

