/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import java.net.InetAddress;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Random;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.messages.ValidationComplete;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MerkleTree;
import org.apache.cassandra.utils.MerkleTrees;
import org.cassandraunit.shaded.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validator
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(Validator.class);
    public final RepairJobDesc desc;
    public final InetAddress initiator;
    public final int gcBefore;
    private final boolean evenTreeDistribution;
    private long validated;
    private MerkleTrees trees;
    private MerkleTree.TreeRange range;
    private MerkleTrees.TreeRangeIterator ranges;
    private DecoratedKey lastKey;

    public Validator(RepairJobDesc desc, InetAddress initiator, int gcBefore) {
        this(desc, initiator, gcBefore, false);
    }

    public Validator(RepairJobDesc desc, InetAddress initiator, int gcBefore, boolean evenTreeDistribution) {
        this.desc = desc;
        this.initiator = initiator;
        this.gcBefore = gcBefore;
        this.validated = 0L;
        this.range = null;
        this.ranges = null;
        this.evenTreeDistribution = evenTreeDistribution;
    }

    public void prepare(ColumnFamilyStore cfs, MerkleTrees tree) {
        this.trees = tree;
        if (!tree.partitioner().preservesOrder() || this.evenTreeDistribution) {
            tree.init();
        } else {
            ArrayList<DecoratedKey> keys = new ArrayList<DecoratedKey>();
            Random random = new Random();
            for (Range<Token> range : tree.ranges()) {
                DecoratedKey dk;
                for (DecoratedKey sample : cfs.keySamples(range)) {
                    assert (range.contains(sample.getToken())) : "Token " + sample.getToken() + " is not within range " + this.desc.ranges;
                    keys.add(sample);
                }
                if (keys.isEmpty()) {
                    tree.init(range);
                    continue;
                }
                int numKeys = keys.size();
                while (tree.split((dk = (DecoratedKey)keys.get(random.nextInt(numKeys))).getToken())) {
                }
                keys.clear();
            }
        }
        logger.debug("Prepared AEService trees of size {} for {}", (Object)this.trees.size(), (Object)this.desc);
        this.ranges = tree.invalids();
    }

    public void add(UnfilteredRowIterator partition) {
        assert (Range.isInRanges(partition.partitionKey().getToken(), this.desc.ranges)) : partition.partitionKey().getToken() + " is not contained in " + this.desc.ranges;
        assert (this.lastKey == null || this.lastKey.compareTo(partition.partitionKey()) < 0) : "partition " + partition.partitionKey() + " received out of order wrt " + this.lastKey;
        this.lastKey = partition.partitionKey();
        if (this.range == null) {
            this.range = (MerkleTree.TreeRange)this.ranges.next();
        }
        if (!this.findCorrectRange(this.lastKey.getToken())) {
            this.ranges = this.trees.invalids();
            this.findCorrectRange(this.lastKey.getToken());
        }
        assert (this.range.contains(this.lastKey.getToken())) : "Token not in MerkleTree: " + this.lastKey.getToken();
        MerkleTree.RowHash rowHash = this.rowHash(partition);
        if (rowHash != null) {
            this.range.addHash(rowHash);
        }
    }

    public boolean findCorrectRange(Token t) {
        while (!this.range.contains(t) && this.ranges.hasNext()) {
            this.range = (MerkleTree.TreeRange)this.ranges.next();
        }
        return this.range.contains(t);
    }

    private MerkleTree.RowHash rowHash(UnfilteredRowIterator partition) {
        ++this.validated;
        CountingDigest digest = new CountingDigest(FBUtilities.newMessageDigest("SHA-256"));
        UnfilteredRowIterators.digest(null, partition, digest, MessagingService.current_version);
        return digest.count > 0L ? new MerkleTree.RowHash(partition.partitionKey().getToken(), digest.digest(), digest.count) : null;
    }

    public void complete() {
        this.completeTree();
        StageManager.getStage(Stage.ANTI_ENTROPY).execute(this);
        if (logger.isDebugEnabled()) {
            logger.debug("Validated {} partitions for {}.  Partitions per leaf are:", (Object)this.validated, (Object)this.desc.sessionId);
            this.trees.logRowCountPerLeaf(logger);
            logger.debug("Validated {} partitions for {}.  Partition sizes are:", (Object)this.validated, (Object)this.desc.sessionId);
            this.trees.logRowSizePerLeaf(logger);
        }
    }

    @VisibleForTesting
    public void completeTree() {
        assert (this.ranges != null) : "Validator was not prepared()";
        this.ranges = this.trees.invalids();
        while (this.ranges.hasNext()) {
            this.range = (MerkleTree.TreeRange)this.ranges.next();
            this.range.ensureHashInitialised();
        }
    }

    public void fail() {
        logger.error("Failed creating a merkle tree for {}, {} (see log for details)", (Object)this.desc, (Object)this.initiator);
        MessagingService.instance().sendOneWay(new ValidationComplete(this.desc).createMessage(), this.initiator);
    }

    @Override
    public void run() {
        if (!this.initiator.equals(FBUtilities.getBroadcastAddress())) {
            logger.info("[repair #{}] Sending completed merkle tree to {} for {}.{}", new Object[]{this.desc.sessionId, this.initiator, this.desc.keyspace, this.desc.columnFamily});
            Tracing.traceRepair("Sending completed merkle tree to {} for {}.{}", this.initiator, this.desc.keyspace, this.desc.columnFamily);
        }
        MessagingService.instance().sendOneWay(new ValidationComplete(this.desc, this.trees).createMessage(), this.initiator);
    }

    static class CountingDigest
    extends MessageDigest {
        private long count;
        private MessageDigest underlying;

        public CountingDigest(MessageDigest underlying) {
            super(underlying.getAlgorithm());
            this.underlying = underlying;
        }

        @Override
        protected void engineUpdate(byte input) {
            this.underlying.update(input);
            ++this.count;
        }

        @Override
        protected void engineUpdate(byte[] input, int offset, int len) {
            this.underlying.update(input, offset, len);
            this.count += (long)len;
        }

        @Override
        protected byte[] engineDigest() {
            return this.underlying.digest();
        }

        @Override
        protected void engineReset() {
            this.underlying.reset();
        }
    }
}

