/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.big;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.partitions.AbstractUnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.LazilyInitializedUnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableReadsListener;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.AbstractIterator;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;
import org.cassandraunit.shaded.com.google.common.collect.Iterators;
import org.cassandraunit.shaded.com.google.common.util.concurrent.RateLimiter;

public class BigTableScanner
implements ISSTableScanner {
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    protected final RandomAccessReader dfile;
    protected final RandomAccessReader ifile;
    public final SSTableReader sstable;
    private final Iterator<AbstractBounds<PartitionPosition>> rangeIterator;
    private AbstractBounds<PartitionPosition> currentRange;
    private final ColumnFilter columns;
    private final DataRange dataRange;
    private final RowIndexEntry.IndexSerializer rowIndexEntrySerializer;
    private final boolean isForThrift;
    private final SSTableReadsListener listener;
    private long startScan = -1L;
    private long bytesScanned = 0L;
    protected Iterator<UnfilteredRowIterator> iterator;

    public static ISSTableScanner getScanner(SSTableReader sstable, RateLimiter limiter) {
        return new BigTableScanner(sstable, ColumnFilter.all(sstable.metadata), limiter, Iterators.singletonIterator(BigTableScanner.fullRange(sstable)));
    }

    public static ISSTableScanner getScanner(SSTableReader sstable, ColumnFilter columns, DataRange dataRange, RateLimiter limiter, boolean isForThrift, SSTableReadsListener listener) {
        return new BigTableScanner(sstable, columns, dataRange, limiter, isForThrift, BigTableScanner.makeBounds(sstable, dataRange).iterator(), listener);
    }

    public static ISSTableScanner getScanner(SSTableReader sstable, Collection<Range<Token>> tokenRanges, RateLimiter limiter) {
        List<Pair<Long, Long>> positions = sstable.getPositionsForRanges(tokenRanges);
        if (positions.isEmpty()) {
            return new EmptySSTableScanner(sstable);
        }
        return new BigTableScanner(sstable, ColumnFilter.all(sstable.metadata), limiter, BigTableScanner.makeBounds(sstable, tokenRanges).iterator());
    }

    public static ISSTableScanner getScanner(SSTableReader sstable, Iterator<AbstractBounds<PartitionPosition>> rangeIterator) {
        return new BigTableScanner(sstable, ColumnFilter.all(sstable.metadata), null, rangeIterator);
    }

    private BigTableScanner(SSTableReader sstable, ColumnFilter columns, RateLimiter limiter, Iterator<AbstractBounds<PartitionPosition>> rangeIterator) {
        this(sstable, columns, null, limiter, false, rangeIterator, SSTableReadsListener.NOOP_LISTENER);
    }

    private BigTableScanner(SSTableReader sstable, ColumnFilter columns, DataRange dataRange, RateLimiter limiter, boolean isForThrift, Iterator<AbstractBounds<PartitionPosition>> rangeIterator, SSTableReadsListener listener) {
        assert (sstable != null);
        this.dfile = limiter == null ? sstable.openDataReader() : sstable.openDataReader(limiter);
        this.ifile = sstable.openIndexReader();
        this.sstable = sstable;
        this.columns = columns;
        this.dataRange = dataRange;
        this.rowIndexEntrySerializer = sstable.descriptor.version.getSSTableFormat().getIndexSerializer(sstable.metadata, sstable.descriptor.version, sstable.header);
        this.isForThrift = isForThrift;
        this.rangeIterator = rangeIterator;
        this.listener = listener;
    }

    private static List<AbstractBounds<PartitionPosition>> makeBounds(SSTableReader sstable, Collection<Range<Token>> tokenRanges) {
        ArrayList<AbstractBounds<PartitionPosition>> boundsList = new ArrayList<AbstractBounds<PartitionPosition>>(tokenRanges.size());
        for (Range<Token> range : Range.normalize(tokenRanges)) {
            BigTableScanner.addRange(sstable, Range.makeRowRange(range), boundsList);
        }
        return boundsList;
    }

    private static List<AbstractBounds<PartitionPosition>> makeBounds(SSTableReader sstable, DataRange dataRange) {
        ArrayList<AbstractBounds<PartitionPosition>> boundsList = new ArrayList<AbstractBounds<PartitionPosition>>(2);
        BigTableScanner.addRange(sstable, dataRange.keyRange(), boundsList);
        return boundsList;
    }

    private static AbstractBounds<PartitionPosition> fullRange(SSTableReader sstable) {
        return new Bounds<PartitionPosition>(sstable.first, sstable.last);
    }

    private static void addRange(SSTableReader sstable, AbstractBounds<PartitionPosition> requested, List<AbstractBounds<PartitionPosition>> boundsList) {
        if (requested instanceof Range && ((Range)requested).isWrapAround()) {
            if (((PartitionPosition)requested.right).compareTo(sstable.first) >= 0) {
                AbstractBounds.Boundary<DecoratedKey> left = new AbstractBounds.Boundary<DecoratedKey>(sstable.first, true);
                AbstractBounds.Boundary<PartitionPosition> right = requested.rightBoundary();
                if (!AbstractBounds.isEmpty(left, right = AbstractBounds.minRight(right, sstable.last, true))) {
                    boundsList.add(AbstractBounds.bounds(left, right));
                }
            }
            if (((PartitionPosition)requested.left).compareTo(sstable.last) <= 0) {
                AbstractBounds.Boundary<DecoratedKey> right = new AbstractBounds.Boundary<DecoratedKey>(sstable.last, true);
                AbstractBounds.Boundary<PartitionPosition> left = requested.leftBoundary();
                if (!AbstractBounds.isEmpty(left = AbstractBounds.maxLeft(left, sstable.first, true), right)) {
                    boundsList.add(AbstractBounds.bounds(left, right));
                }
            }
        } else {
            assert (((PartitionPosition)requested.left).compareTo(requested.right) <= 0 || ((PartitionPosition)requested.right).isMinimum());
            AbstractBounds.Boundary<PartitionPosition> left = requested.leftBoundary();
            AbstractBounds.Boundary<PartitionPosition> right = requested.rightBoundary();
            left = AbstractBounds.maxLeft(left, sstable.first, true);
            AbstractBounds.Boundary<PartitionPosition> boundary = right = ((PartitionPosition)requested.right).isMinimum() ? new AbstractBounds.Boundary<DecoratedKey>(sstable.last, true) : AbstractBounds.minRight(right, sstable.last, true);
            if (!AbstractBounds.isEmpty(left, right)) {
                boundsList.add(AbstractBounds.bounds(left, right));
            }
        }
    }

    private void seekToCurrentRangeStart() {
        long indexPosition = this.sstable.getIndexScanPosition((PartitionPosition)this.currentRange.left);
        this.ifile.seek(indexPosition);
        try {
            while (!this.ifile.isEOF()) {
                indexPosition = this.ifile.getFilePointer();
                DecoratedKey indexDecoratedKey = this.sstable.decorateKey(ByteBufferUtil.readWithShortLength(this.ifile));
                if (indexDecoratedKey.compareTo((PartitionPosition)this.currentRange.left) > 0 || this.currentRange.contains(indexDecoratedKey)) {
                    long dataPosition = RowIndexEntry.Serializer.readPosition(this.ifile, this.sstable.descriptor.version);
                    this.ifile.seek(indexPosition);
                    this.dfile.seek(dataPosition);
                    break;
                }
                RowIndexEntry.Serializer.skip(this.ifile, this.sstable.descriptor.version);
            }
        }
        catch (IOException e) {
            this.sstable.markSuspect();
            throw new CorruptSSTableException((Exception)e, this.sstable.getFilename());
        }
    }

    @Override
    public void close() {
        try {
            if (this.isClosed.compareAndSet(false, true)) {
                FileUtils.close(this.dfile, this.ifile);
            }
        }
        catch (IOException e) {
            this.sstable.markSuspect();
            throw new CorruptSSTableException((Exception)e, this.sstable.getFilename());
        }
    }

    @Override
    public long getLengthInBytes() {
        return this.dfile.length();
    }

    @Override
    public long getCurrentPosition() {
        return this.dfile.getFilePointer();
    }

    @Override
    public long getBytesScanned() {
        return this.bytesScanned;
    }

    @Override
    public long getCompressedLengthInBytes() {
        return this.sstable.onDiskLength();
    }

    @Override
    public String getBackingFiles() {
        return this.sstable.toString();
    }

    @Override
    public boolean isForThrift() {
        return this.isForThrift;
    }

    @Override
    public CFMetaData metadata() {
        return this.sstable.metadata;
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = this.createIterator();
        }
        return this.iterator.hasNext();
    }

    @Override
    public UnfilteredRowIterator next() {
        if (this.iterator == null) {
            this.iterator = this.createIterator();
        }
        return this.iterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private Iterator<UnfilteredRowIterator> createIterator() {
        this.listener.onScanningStarted(this.sstable);
        return new KeyScanningIterator();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(dfile=" + this.dfile + " ifile=" + this.ifile + " sstable=" + this.sstable + ")";
    }

    public static class EmptySSTableScanner
    extends AbstractUnfilteredPartitionIterator
    implements ISSTableScanner {
        private final SSTableReader sstable;

        public EmptySSTableScanner(SSTableReader sstable) {
            this.sstable = sstable;
        }

        @Override
        public long getLengthInBytes() {
            return 0L;
        }

        @Override
        public long getCurrentPosition() {
            return 0L;
        }

        @Override
        public long getBytesScanned() {
            return 0L;
        }

        @Override
        public long getCompressedLengthInBytes() {
            return 0L;
        }

        @Override
        public String getBackingFiles() {
            return this.sstable.getFilename();
        }

        @Override
        public boolean isForThrift() {
            return false;
        }

        @Override
        public CFMetaData metadata() {
            return this.sstable.metadata;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public UnfilteredRowIterator next() {
            return null;
        }
    }

    protected class KeyScanningIterator
    extends AbstractIterator<UnfilteredRowIterator> {
        private DecoratedKey nextKey;
        private RowIndexEntry nextEntry;
        private DecoratedKey currentKey;
        private RowIndexEntry currentEntry;

        protected KeyScanningIterator() {
        }

        @Override
        protected UnfilteredRowIterator computeNext() {
            try {
                if (this.nextEntry == null) {
                    do {
                        if (BigTableScanner.this.startScan != -1L) {
                            BigTableScanner.this.bytesScanned = BigTableScanner.this.bytesScanned + (BigTableScanner.this.dfile.getFilePointer() - BigTableScanner.this.startScan);
                        }
                        if (!BigTableScanner.this.rangeIterator.hasNext()) {
                            return (UnfilteredRowIterator)this.endOfData();
                        }
                        BigTableScanner.this.currentRange = (AbstractBounds)BigTableScanner.this.rangeIterator.next();
                        BigTableScanner.this.seekToCurrentRangeStart();
                        BigTableScanner.this.startScan = BigTableScanner.this.dfile.getFilePointer();
                        if (BigTableScanner.this.ifile.isEOF()) {
                            return (UnfilteredRowIterator)this.endOfData();
                        }
                        this.currentKey = BigTableScanner.this.sstable.decorateKey(ByteBufferUtil.readWithShortLength(BigTableScanner.this.ifile));
                        this.currentEntry = BigTableScanner.this.rowIndexEntrySerializer.deserialize(BigTableScanner.this.ifile, BigTableScanner.this.ifile.getFilePointer());
                    } while (!BigTableScanner.this.currentRange.contains(this.currentKey));
                } else {
                    this.currentKey = this.nextKey;
                    this.currentEntry = this.nextEntry;
                }
                if (BigTableScanner.this.ifile.isEOF()) {
                    this.nextEntry = null;
                    this.nextKey = null;
                } else {
                    this.nextKey = BigTableScanner.this.sstable.decorateKey(ByteBufferUtil.readWithShortLength(BigTableScanner.this.ifile));
                    this.nextEntry = BigTableScanner.this.rowIndexEntrySerializer.deserialize(BigTableScanner.this.ifile, BigTableScanner.this.ifile.getFilePointer());
                    if (!BigTableScanner.this.currentRange.contains(this.nextKey)) {
                        this.nextKey = null;
                        this.nextEntry = null;
                    }
                }
                return new LazilyInitializedUnfilteredRowIterator(this.currentKey){

                    @Override
                    protected UnfilteredRowIterator initializeIterator() {
                        if (BigTableScanner.this.startScan != -1L) {
                            BigTableScanner.this.bytesScanned = BigTableScanner.this.bytesScanned + (BigTableScanner.this.dfile.getFilePointer() - BigTableScanner.this.startScan);
                        }
                        try {
                            if (BigTableScanner.this.dataRange == null) {
                                BigTableScanner.this.dfile.seek(((KeyScanningIterator)KeyScanningIterator.this).currentEntry.position);
                                BigTableScanner.this.startScan = BigTableScanner.this.dfile.getFilePointer();
                                ByteBufferUtil.skipShortLength(BigTableScanner.this.dfile);
                                return SSTableIdentityIterator.create(BigTableScanner.this.sstable, BigTableScanner.this.dfile, this.partitionKey());
                            }
                            BigTableScanner.this.startScan = BigTableScanner.this.dfile.getFilePointer();
                            ClusteringIndexFilter filter = BigTableScanner.this.dataRange.clusteringIndexFilter(this.partitionKey());
                            return BigTableScanner.this.sstable.iterator(BigTableScanner.this.dfile, this.partitionKey(), KeyScanningIterator.this.currentEntry, filter.getSlices(BigTableScanner.this.metadata()), BigTableScanner.this.columns, filter.isReversed(), BigTableScanner.this.isForThrift);
                        }
                        catch (IOException | CorruptSSTableException e) {
                            BigTableScanner.this.sstable.markSuspect();
                            throw new CorruptSSTableException(e, BigTableScanner.this.sstable.getFilename());
                        }
                    }
                };
            }
            catch (IOException | CorruptSSTableException e) {
                BigTableScanner.this.sstable.markSuspect();
                throw new CorruptSSTableException(e, BigTableScanner.this.sstable.getFilename());
            }
        }
    }
}

