/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Json;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.selection.RawSelector;
import org.apache.cassandra.cql3.selection.SelectionColumnMapping;
import org.apache.cassandra.cql3.selection.SelectionColumns;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.cql3.selection.SelectorFactories;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.aggregation.AggregationSpecification;
import org.apache.cassandra.db.aggregation.GroupMaker;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.cassandraunit.shaded.com.google.common.base.MoreObjects;
import org.cassandraunit.shaded.com.google.common.base.Predicate;
import org.cassandraunit.shaded.com.google.common.collect.Iterables;
import org.cassandraunit.shaded.com.google.common.collect.Iterators;

public abstract class Selection {
    private static final Predicate<ColumnDefinition> STATIC_COLUMN_FILTER = new Predicate<ColumnDefinition>(){

        @Override
        public boolean apply(ColumnDefinition def) {
            return def.isStatic();
        }
    };
    private final CFMetaData cfm;
    private final List<ColumnDefinition> columns;
    private final SelectionColumnMapping columnMapping;
    private final ResultSet.ResultMetadata metadata;
    private final boolean collectTimestamps;
    private final boolean collectTTLs;

    protected Selection(CFMetaData cfm, List<ColumnDefinition> columns, SelectionColumnMapping columnMapping, boolean collectTimestamps, boolean collectTTLs) {
        this.cfm = cfm;
        this.columns = columns;
        this.columnMapping = columnMapping;
        this.metadata = new ResultSet.ResultMetadata(columnMapping.getColumnSpecifications());
        this.collectTimestamps = collectTimestamps;
        this.collectTTLs = collectTTLs;
    }

    public boolean isWildcard() {
        return false;
    }

    public boolean containsStaticColumns() {
        if (!this.cfm.hasStaticColumns()) {
            return false;
        }
        if (this.isWildcard()) {
            return true;
        }
        return !Iterables.isEmpty(Iterables.filter(this.columns, STATIC_COLUMN_FILTER));
    }

    public boolean containsOnlyStaticColumns() {
        if (!this.containsStaticColumns()) {
            return false;
        }
        if (this.isWildcard()) {
            return false;
        }
        for (ColumnDefinition def : this.getColumns()) {
            if (def.isPartitionKey() || def.isStatic()) continue;
            return false;
        }
        return true;
    }

    public boolean containsAComplexColumn() {
        for (ColumnDefinition def : this.getColumns()) {
            if (!def.isComplex()) continue;
            return true;
        }
        return false;
    }

    public ResultSet.ResultMetadata getResultMetadata(boolean isJson) {
        if (!isJson) {
            return this.metadata;
        }
        ColumnSpecification firstColumn = this.metadata.names.get(0);
        ColumnSpecification jsonSpec = new ColumnSpecification(firstColumn.ksName, firstColumn.cfName, Json.JSON_COLUMN_ID, UTF8Type.instance);
        return new ResultSet.ResultMetadata(Arrays.asList(jsonSpec));
    }

    public static Selection wildcard(CFMetaData cfm) {
        ArrayList<ColumnDefinition> all = new ArrayList<ColumnDefinition>(cfm.allColumns().size());
        Iterators.addAll(all, cfm.allColumnsInSelectOrder());
        return new SimpleSelection(cfm, all, true);
    }

    public static Selection forColumns(CFMetaData cfm, List<ColumnDefinition> columns) {
        return new SimpleSelection(cfm, columns, false);
    }

    public int addColumnForOrdering(ColumnDefinition c) {
        this.columns.add(c);
        this.metadata.addNonSerializedColumn(c);
        return this.columns.size() - 1;
    }

    public void addFunctionsTo(List<Function> functions) {
    }

    private static boolean processesSelection(List<RawSelector> rawSelectors) {
        for (RawSelector rawSelector : rawSelectors) {
            if (!rawSelector.processesSelection()) continue;
            return true;
        }
        return false;
    }

    public static Selection fromSelectors(CFMetaData cfm, List<RawSelector> rawSelectors, VariableSpecifications boundNames, boolean hasGroupBy) {
        ArrayList<ColumnDefinition> defs = new ArrayList<ColumnDefinition>();
        SelectorFactories factories = SelectorFactories.createFactoriesAndCollectColumnDefinitions(RawSelector.toSelectables(rawSelectors, cfm), null, cfm, defs, boundNames);
        SelectionColumnMapping mapping = Selection.collectColumnMappings(cfm, rawSelectors, factories);
        return Selection.processesSelection(rawSelectors) || rawSelectors.size() != defs.size() || hasGroupBy ? new SelectionWithProcessing(cfm, defs, mapping, factories) : new SimpleSelection(cfm, defs, mapping, false);
    }

    public int getResultSetIndex(ColumnDefinition c) {
        return this.getColumnIndex(c);
    }

    protected final int getColumnIndex(ColumnDefinition c) {
        int m = this.columns.size();
        for (int i = 0; i < m; ++i) {
            if (!this.columns.get((int)i).name.equals(c.name)) continue;
            return i;
        }
        return -1;
    }

    private static SelectionColumnMapping collectColumnMappings(CFMetaData cfm, List<RawSelector> rawSelectors, SelectorFactories factories) {
        SelectionColumnMapping selectionColumns = SelectionColumnMapping.newMapping();
        Iterator<RawSelector> iter = rawSelectors.iterator();
        for (Selector.Factory factory : factories) {
            ColumnSpecification colSpec = factory.getColumnSpecification(cfm);
            ColumnIdentifier alias = iter.next().alias;
            factory.addColumnMapping(selectionColumns, alias == null ? colSpec : colSpec.withAlias(alias));
        }
        return selectionColumns;
    }

    protected abstract Selectors newSelectors(QueryOptions var1) throws InvalidRequestException;

    public List<ColumnDefinition> getColumns() {
        return this.columns;
    }

    public SelectionColumns getColumnMapping() {
        return this.columnMapping;
    }

    public ResultSetBuilder resultSetBuilder(QueryOptions options, boolean isJson) {
        return new ResultSetBuilder(options, isJson);
    }

    public ResultSetBuilder resultSetBuilder(QueryOptions options, boolean isJson, AggregationSpecification aggregationSpec) {
        return aggregationSpec == null ? new ResultSetBuilder(options, isJson) : new ResultSetBuilder(options, isJson, aggregationSpec.newGroupMaker());
    }

    public abstract boolean isAggregate();

    public String toString() {
        return MoreObjects.toStringHelper(this).add("columns", this.columns).add("columnMapping", this.columnMapping).add("metadata", this.metadata).add("collectTimestamps", this.collectTimestamps).add("collectTTLs", this.collectTTLs).toString();
    }

    public static List<ByteBuffer> rowToJson(List<ByteBuffer> row, ProtocolVersion protocolVersion, ResultSet.ResultMetadata metadata) {
        StringBuilder sb = new StringBuilder("{");
        for (int i = 0; i < metadata.names.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            ColumnSpecification spec = metadata.names.get(i);
            String columnName = spec.name.toString();
            if (!columnName.equals(columnName.toLowerCase(Locale.US))) {
                columnName = "\"" + columnName + "\"";
            }
            ByteBuffer buffer = row.get(i);
            sb.append('\"');
            sb.append(Json.quoteAsJsonString(columnName));
            sb.append("\": ");
            if (buffer == null) {
                sb.append("null");
                continue;
            }
            sb.append(spec.type.toJSONString(buffer, protocolVersion));
        }
        sb.append("}");
        return Collections.singletonList(UTF8Type.instance.getSerializer().serialize(sb.toString()));
    }

    private static class SelectionWithProcessing
    extends Selection {
        private final SelectorFactories factories;

        public SelectionWithProcessing(CFMetaData cfm, List<ColumnDefinition> columns, SelectionColumnMapping metadata, SelectorFactories factories) throws InvalidRequestException {
            super(cfm, columns, metadata, factories.containsWritetimeSelectorFactory(), factories.containsTTLSelectorFactory());
            this.factories = factories;
        }

        @Override
        public void addFunctionsTo(List<Function> functions) {
            this.factories.addFunctionsTo(functions);
        }

        @Override
        public int getResultSetIndex(ColumnDefinition c) {
            int index = this.getColumnIndex(c);
            if (index < 0) {
                return -1;
            }
            int m = this.factories.size();
            for (int i = 0; i < m; ++i) {
                if (!this.factories.get(i).isSimpleSelectorFactory(index)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int addColumnForOrdering(ColumnDefinition c) {
            int index = super.addColumnForOrdering(c);
            this.factories.addSelectorForOrdering(c, index);
            return this.factories.size() - 1;
        }

        @Override
        public boolean isAggregate() {
            return this.factories.doesAggregation();
        }

        @Override
        protected Selectors newSelectors(final QueryOptions options) throws InvalidRequestException {
            return new Selectors(){
                private final List<Selector> selectors;
                {
                    this.selectors = factories.newInstances(options);
                }

                @Override
                public void reset() {
                    for (Selector selector : this.selectors) {
                        selector.reset();
                    }
                }

                @Override
                public boolean isAggregate() {
                    return factories.doesAggregation();
                }

                @Override
                public List<ByteBuffer> getOutputRow(ProtocolVersion protocolVersion) throws InvalidRequestException {
                    ArrayList<ByteBuffer> outputRow = new ArrayList<ByteBuffer>(this.selectors.size());
                    for (Selector selector : this.selectors) {
                        outputRow.add(selector.getOutput(protocolVersion));
                    }
                    return outputRow;
                }

                @Override
                public void addInputRow(ProtocolVersion protocolVersion, ResultSetBuilder rs) throws InvalidRequestException {
                    for (Selector selector : this.selectors) {
                        selector.addInput(protocolVersion, rs);
                    }
                }
            };
        }
    }

    private static class SimpleSelection
    extends Selection {
        private final boolean isWildcard;

        public SimpleSelection(CFMetaData cfm, List<ColumnDefinition> columns, boolean isWildcard) {
            this(cfm, columns, SelectionColumnMapping.simpleMapping(columns), isWildcard);
        }

        public SimpleSelection(CFMetaData cfm, List<ColumnDefinition> columns, SelectionColumnMapping metadata, boolean isWildcard) {
            super(cfm, columns, metadata, false, false);
            this.isWildcard = isWildcard;
        }

        @Override
        public boolean isWildcard() {
            return this.isWildcard;
        }

        @Override
        public boolean isAggregate() {
            return false;
        }

        @Override
        protected Selectors newSelectors(QueryOptions options) {
            return new Selectors(){
                private List<ByteBuffer> current;

                @Override
                public void reset() {
                    this.current = null;
                }

                @Override
                public List<ByteBuffer> getOutputRow(ProtocolVersion protocolVersion) {
                    return this.current;
                }

                @Override
                public void addInputRow(ProtocolVersion protocolVersion, ResultSetBuilder rs) throws InvalidRequestException {
                    this.current = rs.current;
                }

                @Override
                public boolean isAggregate() {
                    return false;
                }
            };
        }
    }

    private static interface Selectors {
        public boolean isAggregate();

        public void addInputRow(ProtocolVersion var1, ResultSetBuilder var2) throws InvalidRequestException;

        public List<ByteBuffer> getOutputRow(ProtocolVersion var1) throws InvalidRequestException;

        public void reset();
    }

    public class ResultSetBuilder {
        private final ResultSet resultSet;
        private final ProtocolVersion protocolVersion;
        private final Selectors selectors;
        private final GroupMaker groupMaker;
        List<ByteBuffer> current;
        final long[] timestamps;
        final int[] ttls;
        private final boolean isJson;

        private ResultSetBuilder(QueryOptions options, boolean isJson) {
            this(options, isJson, (GroupMaker)null);
        }

        private ResultSetBuilder(QueryOptions options, boolean isJson, GroupMaker groupMaker) {
            this.resultSet = new ResultSet(Selection.this.getResultMetadata(isJson).copy(), new ArrayList<List<ByteBuffer>>());
            this.protocolVersion = options.getProtocolVersion();
            this.selectors = Selection.this.newSelectors(options);
            this.groupMaker = groupMaker;
            this.timestamps = Selection.this.collectTimestamps ? new long[Selection.this.columns.size()] : null;
            this.ttls = Selection.this.collectTTLs ? new int[Selection.this.columns.size()] : null;
            this.isJson = isJson;
            if (this.timestamps != null) {
                Arrays.fill(this.timestamps, Long.MIN_VALUE);
            }
            if (this.ttls != null) {
                Arrays.fill(this.ttls, -1);
            }
        }

        public void add(ByteBuffer v) {
            this.current.add(v);
        }

        public void add(Cell c, int nowInSec) {
            if (c == null) {
                this.current.add(null);
                return;
            }
            this.current.add(this.value(c));
            if (this.timestamps != null) {
                this.timestamps[this.current.size() - 1] = c.timestamp();
            }
            if (this.ttls != null) {
                this.ttls[this.current.size() - 1] = this.remainingTTL(c, nowInSec);
            }
        }

        private int remainingTTL(Cell c, int nowInSec) {
            if (!c.isExpiring()) {
                return -1;
            }
            int remaining = c.localDeletionTime() - nowInSec;
            return remaining >= 0 ? remaining : -1;
        }

        private ByteBuffer value(Cell c) {
            return c.isCounterCell() ? ByteBufferUtil.bytes(CounterContext.instance().total(c.value())) : c.value();
        }

        public void newRow(DecoratedKey partitionKey, Clustering clustering) {
            boolean isNewAggregate;
            boolean bl = isNewAggregate = this.groupMaker == null || this.groupMaker.isNewGroup(partitionKey, clustering);
            if (this.current != null) {
                this.selectors.addInputRow(this.protocolVersion, this);
                if (isNewAggregate) {
                    this.resultSet.addRow(this.getOutputRow());
                    this.selectors.reset();
                }
            }
            this.current = new ArrayList<ByteBuffer>(Selection.this.columns.size());
        }

        public ResultSet build() {
            if (this.current != null) {
                this.selectors.addInputRow(this.protocolVersion, this);
                this.resultSet.addRow(this.getOutputRow());
                this.selectors.reset();
                this.current = null;
            }
            if (this.resultSet.isEmpty() && this.groupMaker != null && this.groupMaker.returnAtLeastOneRow()) {
                this.resultSet.addRow(this.getOutputRow());
            }
            return this.resultSet;
        }

        private List<ByteBuffer> getOutputRow() {
            List<ByteBuffer> outputRow = this.selectors.getOutputRow(this.protocolVersion);
            return this.isJson ? Selection.rowToJson(outputRow, this.protocolVersion, Selection.this.metadata) : outputRow;
        }
    }
}

