/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.restrictions;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.restrictions.PartitionKeyRestrictions;
import org.apache.cassandra.cql3.restrictions.PartitionKeySingleRestrictionSet;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.cql3.restrictions.TermSlice;
import org.apache.cassandra.cql3.restrictions.TokenFilter;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.index.SecondaryIndexManager;
import org.cassandraunit.shaded.com.google.common.base.Joiner;

public abstract class TokenRestriction
implements PartitionKeyRestrictions {
    protected final List<ColumnDefinition> columnDefs;
    protected final CFMetaData metadata;

    public TokenRestriction(CFMetaData metadata, List<ColumnDefinition> columnDefs) {
        this.columnDefs = columnDefs;
        this.metadata = metadata;
    }

    @Override
    public boolean hasIN() {
        return false;
    }

    @Override
    public boolean hasOnlyEqualityRestrictions() {
        return false;
    }

    @Override
    public Set<Restriction> getRestrictions(ColumnDefinition columnDef) {
        return Collections.singleton(this);
    }

    @Override
    public final boolean isOnToken() {
        return true;
    }

    @Override
    public boolean needFiltering(CFMetaData cfm) {
        return false;
    }

    @Override
    public boolean hasSlice() {
        return false;
    }

    @Override
    public boolean hasUnrestrictedPartitionKeyComponents(CFMetaData cfm) {
        return false;
    }

    @Override
    public List<ColumnDefinition> getColumnDefs() {
        return this.columnDefs;
    }

    @Override
    public ColumnDefinition getFirstColumn() {
        return this.columnDefs.get(0);
    }

    @Override
    public ColumnDefinition getLastColumn() {
        return this.columnDefs.get(this.columnDefs.size() - 1);
    }

    @Override
    public boolean hasSupportingIndex(SecondaryIndexManager secondaryIndexManager) {
        return false;
    }

    @Override
    public void addRowFilterTo(RowFilter filter, SecondaryIndexManager indexManager, QueryOptions options) {
        throw new UnsupportedOperationException("Index expression cannot be created for token restriction");
    }

    @Override
    public final boolean isEmpty() {
        return this.getColumnDefs().isEmpty();
    }

    @Override
    public final int size() {
        return this.getColumnDefs().size();
    }

    protected final String getColumnNamesAsString() {
        return Joiner.on(", ").join(ColumnDefinition.toIdentifiers(this.columnDefs));
    }

    @Override
    public final PartitionKeyRestrictions mergeWith(Restriction otherRestriction) throws InvalidRequestException {
        if (!otherRestriction.isOnToken()) {
            return new TokenFilter(this.toPartitionKeyRestrictions(otherRestriction), this);
        }
        return this.doMergeWith((TokenRestriction)otherRestriction);
    }

    protected abstract PartitionKeyRestrictions doMergeWith(TokenRestriction var1) throws InvalidRequestException;

    private PartitionKeyRestrictions toPartitionKeyRestrictions(Restriction restriction) throws InvalidRequestException {
        if (restriction instanceof PartitionKeyRestrictions) {
            return (PartitionKeyRestrictions)restriction;
        }
        return new PartitionKeySingleRestrictionSet(this.metadata.getKeyValidatorAsClusteringComparator()).mergeWith(restriction);
    }

    public static class SliceRestriction
    extends TokenRestriction {
        private final TermSlice slice;

        public SliceRestriction(CFMetaData cfm, List<ColumnDefinition> columnDefs, Bound bound, boolean inclusive, Term term) {
            super(cfm, columnDefs);
            this.slice = TermSlice.newInstance(bound, inclusive, term);
        }

        @Override
        public boolean hasContains() {
            return false;
        }

        @Override
        public boolean hasSlice() {
            return true;
        }

        @Override
        public List<ByteBuffer> values(QueryOptions options) throws InvalidRequestException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasBound(Bound b) {
            return this.slice.hasBound(b);
        }

        @Override
        public List<ByteBuffer> bounds(Bound b, QueryOptions options) throws InvalidRequestException {
            return Collections.singletonList(this.slice.bound(b).bindAndGet(options));
        }

        @Override
        public void addFunctionsTo(List<Function> functions) {
            this.slice.addFunctionsTo(functions);
        }

        @Override
        public boolean isInclusive(Bound b) {
            return this.slice.isInclusive(b);
        }

        @Override
        protected PartitionKeyRestrictions doMergeWith(TokenRestriction otherRestriction) throws InvalidRequestException {
            if (!(otherRestriction instanceof SliceRestriction)) {
                throw RequestValidations.invalidRequest("Columns \"%s\" cannot be restricted by both an equality and an inequality relation", this.getColumnNamesAsString());
            }
            SliceRestriction otherSlice = (SliceRestriction)otherRestriction;
            if (this.hasBound(Bound.START) && otherSlice.hasBound(Bound.START)) {
                throw RequestValidations.invalidRequest("More than one restriction was found for the start bound on %s", this.getColumnNamesAsString());
            }
            if (this.hasBound(Bound.END) && otherSlice.hasBound(Bound.END)) {
                throw RequestValidations.invalidRequest("More than one restriction was found for the end bound on %s", this.getColumnNamesAsString());
            }
            return new SliceRestriction(this.metadata, this.columnDefs, this.slice.merge(otherSlice.slice));
        }

        public String toString() {
            return String.format("SLICE%s", this.slice);
        }

        private SliceRestriction(CFMetaData cfm, List<ColumnDefinition> columnDefs, TermSlice slice) {
            super(cfm, columnDefs);
            this.slice = slice;
        }
    }

    public static final class EQRestriction
    extends TokenRestriction {
        private final Term value;

        public EQRestriction(CFMetaData cfm, List<ColumnDefinition> columnDefs, Term value) {
            super(cfm, columnDefs);
            this.value = value;
        }

        @Override
        public void addFunctionsTo(List<Function> functions) {
            this.value.addFunctionsTo(functions);
        }

        @Override
        protected PartitionKeyRestrictions doMergeWith(TokenRestriction otherRestriction) throws InvalidRequestException {
            throw RequestValidations.invalidRequest("%s cannot be restricted by more than one relation if it includes an Equal", Joiner.on(", ").join(ColumnDefinition.toIdentifiers(this.columnDefs)));
        }

        @Override
        public List<ByteBuffer> bounds(Bound b, QueryOptions options) throws InvalidRequestException {
            return this.values(options);
        }

        @Override
        public boolean hasBound(Bound b) {
            return true;
        }

        @Override
        public boolean isInclusive(Bound b) {
            return true;
        }

        @Override
        public List<ByteBuffer> values(QueryOptions options) throws InvalidRequestException {
            return Collections.singletonList(this.value.bindAndGet(options));
        }

        @Override
        public boolean hasContains() {
            return false;
        }
    }
}

