/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.BatchQueryOptions;
import org.apache.cassandra.cql3.CQLFragmentParser;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.CqlParser;
import org.apache.cassandra.cql3.QueryHandler;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.statements.BatchStatement;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionIterators;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.exceptions.CassandraException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.metrics.CQLMetrics;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationListener;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.pager.QueryPager;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.CassandraVersion;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MD5Digest;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.Pair;
import org.cassandraunit.shaded.com.google.common.annotations.VisibleForTesting;
import org.cassandraunit.shaded.com.google.common.base.Predicate;
import org.cassandraunit.shaded.com.google.common.collect.Iterables;
import org.cassandraunit.shaded.com.google.common.collect.Iterators;
import org.cassandraunit.shaded.com.google.common.primitives.Ints;
import org.cassandraunit.shaded.org.antlr.runtime.RecognitionException;
import org.cassandraunit.shaded.org.apache.cassandra.thrift.ThriftClientState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryProcessor
implements QueryHandler {
    public static final CassandraVersion CQL_VERSION = new CassandraVersion("3.4.4");
    public static final QueryProcessor instance = new QueryProcessor();
    private static final Logger logger = LoggerFactory.getLogger(QueryProcessor.class);
    private static final ConcurrentLinkedHashMap<MD5Digest, ParsedStatement.Prepared> preparedStatements;
    private static final ConcurrentLinkedHashMap<Integer, ParsedStatement.Prepared> thriftPreparedStatements;
    private static final ConcurrentMap<String, ParsedStatement.Prepared> internalStatements;
    public static final CQLMetrics metrics;
    private static final AtomicInteger lastMinuteEvictionsCount;
    private static final AtomicInteger thriftLastMinuteEvictionsCount;

    private static long capacityToBytes(long cacheSizeMB) {
        return cacheSizeMB * 1024L * 1024L;
    }

    public static int preparedStatementsCount() {
        return preparedStatements.size() + thriftPreparedStatements.size();
    }

    public static void preloadPreparedStatement() {
        ClientState clientState = ClientState.forInternalCalls();
        int count = 0;
        for (Pair<String, String> useKeyspaceAndCQL : SystemKeyspace.loadPreparedStatements()) {
            try {
                clientState.setKeyspace((String)useKeyspaceAndCQL.left);
                QueryProcessor.prepare((String)useKeyspaceAndCQL.right, clientState, false);
                ++count;
            }
            catch (RequestValidationException e) {
                logger.warn("prepared statement recreation error: {}", useKeyspaceAndCQL.right, (Object)e);
            }
        }
        logger.info("Preloaded {} prepared statements", (Object)count);
    }

    @VisibleForTesting
    public static void clearPrepraredStatements() {
        preparedStatements.clear();
        thriftPreparedStatements.clear();
    }

    private static QueryState internalQueryState() {
        return InternalStateInstance.INSTANCE.queryState;
    }

    private QueryProcessor() {
        MigrationManager.instance.register(new MigrationSubscriber());
    }

    @Override
    public ParsedStatement.Prepared getPrepared(MD5Digest id) {
        return (ParsedStatement.Prepared)preparedStatements.get((Object)id);
    }

    @Override
    public ParsedStatement.Prepared getPreparedForThrift(Integer id) {
        return (ParsedStatement.Prepared)thriftPreparedStatements.get((Object)id);
    }

    public static void validateKey(ByteBuffer key) throws InvalidRequestException {
        if (key == null || key.remaining() == 0) {
            throw new InvalidRequestException("Key may not be empty");
        }
        if (key == ByteBufferUtil.UNSET_BYTE_BUFFER) {
            throw new InvalidRequestException("Key may not be unset");
        }
        if (key.remaining() > 65535) {
            throw new InvalidRequestException("Key length of " + key.remaining() + " is longer than maximum of " + 65535);
        }
    }

    public ResultMessage processStatement(CQLStatement statement, QueryState queryState, QueryOptions options, long queryStartNanoTime) throws RequestExecutionException, RequestValidationException {
        logger.trace("Process {} @CL.{}", (Object)statement, (Object)options.getConsistency());
        ClientState clientState = queryState.getClientState();
        statement.checkAccess(clientState);
        statement.validate(clientState);
        ResultMessage result = statement.execute(queryState, options, queryStartNanoTime);
        return result == null ? new ResultMessage.Void() : result;
    }

    public static ResultMessage process(String queryString, ConsistencyLevel cl, QueryState queryState, long queryStartNanoTime) throws RequestExecutionException, RequestValidationException {
        return instance.process(queryString, queryState, QueryOptions.forInternalCalls(cl, Collections.emptyList()), queryStartNanoTime);
    }

    @Override
    public ResultMessage process(String query, QueryState state, QueryOptions options, Map<String, ByteBuffer> customPayload, long queryStartNanoTime) throws RequestExecutionException, RequestValidationException {
        return this.process(query, state, options, queryStartNanoTime);
    }

    public ResultMessage process(String queryString, QueryState queryState, QueryOptions options, long queryStartNanoTime) throws RequestExecutionException, RequestValidationException {
        ParsedStatement.Prepared p = QueryProcessor.getStatement(queryString, queryState.getClientState());
        options.prepare(p.boundNames);
        CQLStatement prepared = p.statement;
        if (prepared.getBoundTerms() != options.getValues().size()) {
            throw new InvalidRequestException("Invalid amount of bind variables");
        }
        if (!queryState.getClientState().isInternal) {
            QueryProcessor.metrics.regularStatementsExecuted.inc();
        }
        return this.processStatement(prepared, queryState, options, queryStartNanoTime);
    }

    public static ParsedStatement.Prepared parseStatement(String queryStr, QueryState queryState) throws RequestValidationException {
        return QueryProcessor.getStatement(queryStr, queryState.getClientState());
    }

    public static UntypedResultSet process(String query, ConsistencyLevel cl) throws RequestExecutionException {
        return QueryProcessor.process(query, cl, Collections.emptyList());
    }

    public static UntypedResultSet process(String query, ConsistencyLevel cl, List<ByteBuffer> values) throws RequestExecutionException {
        ResultMessage result = instance.process(query, QueryState.forInternalCalls(), QueryOptions.forInternalCalls(cl, values), System.nanoTime());
        if (result instanceof ResultMessage.Rows) {
            return UntypedResultSet.create(((ResultMessage.Rows)result).result);
        }
        return null;
    }

    private static QueryOptions makeInternalOptions(ParsedStatement.Prepared prepared, Object[] values) {
        return QueryProcessor.makeInternalOptions(prepared, values, ConsistencyLevel.ONE);
    }

    private static QueryOptions makeInternalOptions(ParsedStatement.Prepared prepared, Object[] values, ConsistencyLevel cl) {
        if (prepared.boundNames.size() != values.length) {
            throw new IllegalArgumentException(String.format("Invalid number of values. Expecting %d but got %d", prepared.boundNames.size(), values.length));
        }
        ArrayList<ByteBuffer> boundValues = new ArrayList<ByteBuffer>(values.length);
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            AbstractType<?> type = prepared.boundNames.get((int)i).type;
            boundValues.add(value instanceof ByteBuffer || value == null ? (ByteBuffer)value : type.decompose(value));
        }
        return QueryOptions.forInternalCalls(cl, boundValues);
    }

    public static ParsedStatement.Prepared prepareInternal(String query) throws RequestValidationException {
        ParsedStatement.Prepared prepared = (ParsedStatement.Prepared)internalStatements.get(query);
        if (prepared != null) {
            return prepared;
        }
        prepared = QueryProcessor.parseStatement(query, QueryProcessor.internalQueryState());
        prepared.statement.validate(QueryProcessor.internalQueryState().getClientState());
        internalStatements.putIfAbsent(query, prepared);
        return prepared;
    }

    public static UntypedResultSet executeInternal(String query, Object ... values) {
        ParsedStatement.Prepared prepared = QueryProcessor.prepareInternal(query);
        ResultMessage result = prepared.statement.executeInternal(QueryProcessor.internalQueryState(), QueryProcessor.makeInternalOptions(prepared, values));
        if (result instanceof ResultMessage.Rows) {
            return UntypedResultSet.create(((ResultMessage.Rows)result).result);
        }
        return null;
    }

    public static UntypedResultSet execute(String query, ConsistencyLevel cl, Object ... values) throws RequestExecutionException {
        return QueryProcessor.execute(query, cl, QueryProcessor.internalQueryState(), values);
    }

    public static UntypedResultSet execute(String query, ConsistencyLevel cl, QueryState state, Object ... values) throws RequestExecutionException {
        try {
            ParsedStatement.Prepared prepared = QueryProcessor.prepareInternal(query);
            ResultMessage result = prepared.statement.execute(state, QueryProcessor.makeInternalOptions(prepared, values, cl), System.nanoTime());
            if (result instanceof ResultMessage.Rows) {
                return UntypedResultSet.create(((ResultMessage.Rows)result).result);
            }
            return null;
        }
        catch (RequestValidationException e) {
            throw new RuntimeException("Error validating " + query, e);
        }
    }

    public static UntypedResultSet executeInternalWithPaging(String query, int pageSize, Object ... values) {
        ParsedStatement.Prepared prepared = QueryProcessor.prepareInternal(query);
        if (!(prepared.statement instanceof SelectStatement)) {
            throw new IllegalArgumentException("Only SELECTs can be paged");
        }
        SelectStatement select = (SelectStatement)prepared.statement;
        QueryPager pager = select.getQuery(QueryProcessor.makeInternalOptions(prepared, values), FBUtilities.nowInSeconds()).getPager(null, ProtocolVersion.CURRENT);
        return UntypedResultSet.create(select, pager, pageSize);
    }

    public static UntypedResultSet executeOnceInternal(String query, Object ... values) {
        ParsedStatement.Prepared prepared = QueryProcessor.parseStatement(query, QueryProcessor.internalQueryState());
        prepared.statement.validate(QueryProcessor.internalQueryState().getClientState());
        ResultMessage result = prepared.statement.executeInternal(QueryProcessor.internalQueryState(), QueryProcessor.makeInternalOptions(prepared, values));
        if (result instanceof ResultMessage.Rows) {
            return UntypedResultSet.create(((ResultMessage.Rows)result).result);
        }
        return null;
    }

    public static UntypedResultSet executeInternalWithNow(int nowInSec, long queryStartNanoTime, String query, Object ... values) {
        ParsedStatement.Prepared prepared = QueryProcessor.prepareInternal(query);
        assert (prepared.statement instanceof SelectStatement);
        SelectStatement select = (SelectStatement)prepared.statement;
        ResultMessage.Rows result = select.executeInternal(QueryProcessor.internalQueryState(), QueryProcessor.makeInternalOptions(prepared, values), nowInSec, queryStartNanoTime);
        assert (result instanceof ResultMessage.Rows);
        return UntypedResultSet.create(result.result);
    }

    public static UntypedResultSet resultify(String query, RowIterator partition) {
        return QueryProcessor.resultify(query, PartitionIterators.singletonIterator(partition));
    }

    public static UntypedResultSet resultify(String query, PartitionIterator partitions) {
        try (PartitionIterator iter = partitions;){
            SelectStatement ss = (SelectStatement)QueryProcessor.getStatement((String)query, null).statement;
            ResultSet cqlRows = ss.process(iter, FBUtilities.nowInSeconds());
            UntypedResultSet untypedResultSet = UntypedResultSet.create(cqlRows);
            return untypedResultSet;
        }
    }

    @Override
    public ResultMessage.Prepared prepare(String query, QueryState state, Map<String, ByteBuffer> customPayload) throws RequestValidationException {
        return this.prepare(query, state);
    }

    public ResultMessage.Prepared prepare(String queryString, QueryState queryState) {
        ClientState cState = queryState.getClientState();
        return QueryProcessor.prepare(queryString, cState, cState instanceof ThriftClientState);
    }

    public static ResultMessage.Prepared prepare(String queryString, ClientState clientState, boolean forThrift) {
        ResultMessage.Prepared existing = QueryProcessor.getStoredPreparedStatement(queryString, clientState.getRawKeyspace(), forThrift);
        if (existing != null) {
            return existing;
        }
        ParsedStatement.Prepared prepared = QueryProcessor.getStatement(queryString, clientState);
        prepared.rawCQLStatement = queryString;
        int boundTerms = prepared.statement.getBoundTerms();
        if (boundTerms > 65535) {
            throw new InvalidRequestException(String.format("Too many markers(?). %d markers exceed the allowed maximum of %d", boundTerms, 65535));
        }
        assert (boundTerms == prepared.boundNames.size());
        return QueryProcessor.storePreparedStatement(queryString, clientState.getRawKeyspace(), prepared, forThrift);
    }

    private static MD5Digest computeId(String queryString, String keyspace) {
        String toHash = keyspace == null ? queryString : keyspace + queryString;
        return MD5Digest.compute(toHash);
    }

    private static Integer computeThriftId(String queryString, String keyspace) {
        String toHash = keyspace == null ? queryString : keyspace + queryString;
        return toHash.hashCode();
    }

    private static ResultMessage.Prepared getStoredPreparedStatement(String queryString, String keyspace, boolean forThrift) throws InvalidRequestException {
        if (forThrift) {
            Integer thriftStatementId = QueryProcessor.computeThriftId(queryString, keyspace);
            ParsedStatement.Prepared existing = (ParsedStatement.Prepared)thriftPreparedStatements.get((Object)thriftStatementId);
            if (existing == null) {
                return null;
            }
            RequestValidations.checkTrue(queryString.equals(existing.rawCQLStatement), String.format("MD5 hash collision: query with the same MD5 hash was already prepared. \n Existing: '%s'", existing.rawCQLStatement));
            return ResultMessage.Prepared.forThrift(thriftStatementId, existing.boundNames);
        }
        MD5Digest statementId = QueryProcessor.computeId(queryString, keyspace);
        ParsedStatement.Prepared existing = (ParsedStatement.Prepared)preparedStatements.get((Object)statementId);
        if (existing == null) {
            return null;
        }
        RequestValidations.checkTrue(queryString.equals(existing.rawCQLStatement), String.format("MD5 hash collision: query with the same MD5 hash was already prepared. \n Existing: '%s'", existing.rawCQLStatement));
        return new ResultMessage.Prepared(statementId, existing);
    }

    private static ResultMessage.Prepared storePreparedStatement(String queryString, String keyspace, ParsedStatement.Prepared prepared, boolean forThrift) throws InvalidRequestException {
        long statementSize = ObjectSizes.measureDeep(prepared.statement);
        if (forThrift) {
            if (statementSize > QueryProcessor.capacityToBytes(DatabaseDescriptor.getThriftPreparedStatementsCacheSizeMB())) {
                throw new InvalidRequestException(String.format("Prepared statement of size %d bytes is larger than allowed maximum of %d MB: %s...", statementSize, DatabaseDescriptor.getThriftPreparedStatementsCacheSizeMB(), queryString.substring(0, 200)));
            }
            Integer statementId = QueryProcessor.computeThriftId(queryString, keyspace);
            thriftPreparedStatements.put((Object)statementId, (Object)prepared);
            return ResultMessage.Prepared.forThrift(statementId, prepared.boundNames);
        }
        if (statementSize > QueryProcessor.capacityToBytes(DatabaseDescriptor.getPreparedStatementsCacheSizeMB())) {
            throw new InvalidRequestException(String.format("Prepared statement of size %d bytes is larger than allowed maximum of %d MB: %s...", statementSize, DatabaseDescriptor.getPreparedStatementsCacheSizeMB(), queryString.substring(0, 200)));
        }
        MD5Digest statementId = QueryProcessor.computeId(queryString, keyspace);
        preparedStatements.put((Object)statementId, (Object)prepared);
        SystemKeyspace.writePreparedStatement(keyspace, statementId, queryString);
        return new ResultMessage.Prepared(statementId, prepared);
    }

    @Override
    public ResultMessage processPrepared(CQLStatement statement, QueryState state, QueryOptions options, Map<String, ByteBuffer> customPayload, long queryStartNanoTime) throws RequestExecutionException, RequestValidationException {
        return this.processPrepared(statement, state, options, queryStartNanoTime);
    }

    public ResultMessage processPrepared(CQLStatement statement, QueryState queryState, QueryOptions options, long queryStartNanoTime) throws RequestExecutionException, RequestValidationException {
        List<ByteBuffer> variables = options.getValues();
        if (!variables.isEmpty() || statement.getBoundTerms() != 0) {
            if (variables.size() != statement.getBoundTerms()) {
                throw new InvalidRequestException(String.format("there were %d markers(?) in CQL but %d bound variables", statement.getBoundTerms(), variables.size()));
            }
            if (logger.isTraceEnabled()) {
                for (int i = 0; i < variables.size(); ++i) {
                    logger.trace("[{}] '{}'", (Object)(i + 1), (Object)variables.get(i));
                }
            }
        }
        QueryProcessor.metrics.preparedStatementsExecuted.inc();
        return this.processStatement(statement, queryState, options, queryStartNanoTime);
    }

    @Override
    public ResultMessage processBatch(BatchStatement statement, QueryState state, BatchQueryOptions options, Map<String, ByteBuffer> customPayload, long queryStartNanoTime) throws RequestExecutionException, RequestValidationException {
        return this.processBatch(statement, state, options, queryStartNanoTime);
    }

    public ResultMessage processBatch(BatchStatement batch, QueryState queryState, BatchQueryOptions options, long queryStartNanoTime) throws RequestExecutionException, RequestValidationException {
        ClientState clientState = queryState.getClientState();
        batch.checkAccess(clientState);
        batch.validate();
        batch.validate(clientState);
        return batch.execute(queryState, options, queryStartNanoTime);
    }

    public static ParsedStatement.Prepared getStatement(String queryStr, ClientState clientState) throws RequestValidationException {
        Tracing.trace("Parsing {}", (Object)queryStr);
        ParsedStatement statement = QueryProcessor.parseStatement(queryStr);
        if (statement instanceof CFStatement) {
            ((CFStatement)statement).prepareKeyspace(clientState);
        }
        Tracing.trace("Preparing statement");
        return statement.prepare();
    }

    public static <T extends ParsedStatement> T parseStatement(String queryStr, Class<T> klass, String type) throws SyntaxException {
        try {
            ParsedStatement stmt = QueryProcessor.parseStatement(queryStr);
            if (!klass.isAssignableFrom(stmt.getClass())) {
                throw new IllegalArgumentException("Invalid query, must be a " + type + " statement but was: " + stmt.getClass());
            }
            return (T)((ParsedStatement)klass.cast(stmt));
        }
        catch (RequestValidationException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static ParsedStatement parseStatement(String queryStr) throws SyntaxException {
        try {
            return CQLFragmentParser.parseAnyUnhandled(CqlParser::query, queryStr);
        }
        catch (CassandraException ce) {
            throw ce;
        }
        catch (RuntimeException re) {
            logger.error(String.format("The statement: [%s] could not be parsed.", queryStr), (Throwable)re);
            throw new SyntaxException(String.format("Failed parsing statement: [%s] reason: %s %s", queryStr, re.getClass().getSimpleName(), re.getMessage()));
        }
        catch (RecognitionException e) {
            throw new SyntaxException("Invalid or malformed CQL query string: " + e.getMessage());
        }
    }

    private static int measure(Object key, ParsedStatement.Prepared value) {
        return Ints.checkedCast(ObjectSizes.measureDeep(key) + ObjectSizes.measureDeep(value));
    }

    @VisibleForTesting
    public static void clearInternalStatementsCache() {
        internalStatements.clear();
    }

    static {
        internalStatements = new ConcurrentHashMap<String, ParsedStatement.Prepared>();
        metrics = new CQLMetrics();
        lastMinuteEvictionsCount = new AtomicInteger(0);
        thriftLastMinuteEvictionsCount = new AtomicInteger(0);
        preparedStatements = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(QueryProcessor.capacityToBytes(DatabaseDescriptor.getPreparedStatementsCacheSizeMB())).weigher(QueryProcessor::measure).listener((md5Digest, prepared) -> {
            QueryProcessor.metrics.preparedStatementsEvicted.inc();
            lastMinuteEvictionsCount.incrementAndGet();
        }).build();
        thriftPreparedStatements = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(QueryProcessor.capacityToBytes(DatabaseDescriptor.getThriftPreparedStatementsCacheSizeMB())).weigher(QueryProcessor::measure).listener((integer, prepared) -> {
            QueryProcessor.metrics.preparedStatementsEvicted.inc();
            thriftLastMinuteEvictionsCount.incrementAndGet();
        }).build();
        ScheduledExecutors.scheduledTasks.scheduleAtFixedRate(() -> {
            long count = lastMinuteEvictionsCount.getAndSet(0);
            if (count > 0L) {
                logger.warn("{} prepared statements discarded in the last minute because cache limit reached ({} MB)", (Object)count, (Object)DatabaseDescriptor.getPreparedStatementsCacheSizeMB());
            }
            if ((count = (long)thriftLastMinuteEvictionsCount.getAndSet(0)) > 0L) {
                logger.warn("{} prepared Thrift statements discarded in the last minute because cache limit reached ({} MB)", (Object)count, (Object)DatabaseDescriptor.getThriftPreparedStatementsCacheSizeMB());
            }
        }, 1L, 1L, TimeUnit.MINUTES);
        logger.info("Initialized prepared statement caches with {} MB (native) and {} MB (Thrift)", (Object)DatabaseDescriptor.getPreparedStatementsCacheSizeMB(), (Object)DatabaseDescriptor.getThriftPreparedStatementsCacheSizeMB());
    }

    private static class MigrationSubscriber
    extends MigrationListener {
        private MigrationSubscriber() {
        }

        private static void removeInvalidPreparedStatements(String ksName, String cfName) {
            MigrationSubscriber.removeInvalidPreparedStatements(internalStatements.values().iterator(), ksName, cfName);
            MigrationSubscriber.removeInvalidPersistentPreparedStatements(preparedStatements.entrySet().iterator(), ksName, cfName);
            MigrationSubscriber.removeInvalidPreparedStatements(thriftPreparedStatements.values().iterator(), ksName, cfName);
        }

        private static void removeInvalidPreparedStatementsForFunction(String ksName, String functionName) {
            Predicate matchesFunction = f -> ksName.equals(f.name().keyspace) && functionName.equals(f.name().name);
            Iterator iter = preparedStatements.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry pstmt = (Map.Entry)iter.next();
                if (!Iterables.any(((ParsedStatement.Prepared)pstmt.getValue()).statement.getFunctions(), matchesFunction)) continue;
                SystemKeyspace.removePreparedStatement((MD5Digest)pstmt.getKey());
                iter.remove();
            }
            Iterators.removeIf(internalStatements.values().iterator(), statement -> Iterables.any(statement.statement.getFunctions(), matchesFunction));
            Iterators.removeIf(thriftPreparedStatements.values().iterator(), statement -> Iterables.any(statement.statement.getFunctions(), matchesFunction));
        }

        private static void removeInvalidPersistentPreparedStatements(Iterator<Map.Entry<MD5Digest, ParsedStatement.Prepared>> iterator, String ksName, String cfName) {
            while (iterator.hasNext()) {
                Map.Entry<MD5Digest, ParsedStatement.Prepared> entry = iterator.next();
                if (!MigrationSubscriber.shouldInvalidate(ksName, cfName, entry.getValue().statement)) continue;
                SystemKeyspace.removePreparedStatement(entry.getKey());
                iterator.remove();
            }
        }

        private static void removeInvalidPreparedStatements(Iterator<ParsedStatement.Prepared> iterator, String ksName, String cfName) {
            while (iterator.hasNext()) {
                if (!MigrationSubscriber.shouldInvalidate(ksName, cfName, iterator.next().statement)) continue;
                iterator.remove();
            }
        }

        private static boolean shouldInvalidate(String ksName, String cfName, CQLStatement statement) {
            String statementCfName;
            String statementKsName;
            if (statement instanceof ModificationStatement) {
                ModificationStatement modificationStatement = (ModificationStatement)statement;
                statementKsName = modificationStatement.keyspace();
                statementCfName = modificationStatement.columnFamily();
            } else if (statement instanceof SelectStatement) {
                SelectStatement selectStatement = (SelectStatement)statement;
                statementKsName = selectStatement.keyspace();
                statementCfName = selectStatement.columnFamily();
            } else {
                if (statement instanceof BatchStatement) {
                    BatchStatement batchStatement = (BatchStatement)statement;
                    for (ModificationStatement stmt : batchStatement.getStatements()) {
                        if (!MigrationSubscriber.shouldInvalidate(ksName, cfName, stmt)) continue;
                        return true;
                    }
                    return false;
                }
                return false;
            }
            return ksName.equals(statementKsName) && (cfName == null || cfName.equals(statementCfName));
        }

        @Override
        public void onCreateFunction(String ksName, String functionName, List<AbstractType<?>> argTypes) {
            MigrationSubscriber.onCreateFunctionInternal(ksName, functionName, argTypes);
        }

        @Override
        public void onCreateAggregate(String ksName, String aggregateName, List<AbstractType<?>> argTypes) {
            MigrationSubscriber.onCreateFunctionInternal(ksName, aggregateName, argTypes);
        }

        private static void onCreateFunctionInternal(String ksName, String functionName, List<AbstractType<?>> argTypes) {
            if (Schema.instance.getKSMetaData((String)ksName).functions.get(new FunctionName(ksName, functionName)).size() > 1) {
                MigrationSubscriber.removeInvalidPreparedStatementsForFunction(ksName, functionName);
            }
        }

        @Override
        public void onUpdateColumnFamily(String ksName, String cfName, boolean affectsStatements) {
            logger.trace("Column definitions for {}.{} changed, invalidating related prepared statements", (Object)ksName, (Object)cfName);
            if (affectsStatements) {
                MigrationSubscriber.removeInvalidPreparedStatements(ksName, cfName);
            }
        }

        @Override
        public void onUpdateFunction(String ksName, String functionName, List<AbstractType<?>> argTypes) {
            MigrationSubscriber.removeInvalidPreparedStatementsForFunction(ksName, functionName);
        }

        @Override
        public void onUpdateAggregate(String ksName, String aggregateName, List<AbstractType<?>> argTypes) {
            MigrationSubscriber.removeInvalidPreparedStatementsForFunction(ksName, aggregateName);
        }

        @Override
        public void onDropKeyspace(String ksName) {
            logger.trace("Keyspace {} was dropped, invalidating related prepared statements", (Object)ksName);
            MigrationSubscriber.removeInvalidPreparedStatements(ksName, null);
        }

        @Override
        public void onDropColumnFamily(String ksName, String cfName) {
            logger.trace("Table {}.{} was dropped, invalidating related prepared statements", (Object)ksName, (Object)cfName);
            MigrationSubscriber.removeInvalidPreparedStatements(ksName, cfName);
        }

        @Override
        public void onDropFunction(String ksName, String functionName, List<AbstractType<?>> argTypes) {
            MigrationSubscriber.removeInvalidPreparedStatementsForFunction(ksName, functionName);
        }

        @Override
        public void onDropAggregate(String ksName, String aggregateName, List<AbstractType<?>> argTypes) {
            MigrationSubscriber.removeInvalidPreparedStatementsForFunction(ksName, aggregateName);
        }
    }

    private static enum InternalStateInstance {
        INSTANCE;

        private final QueryState queryState;

        private InternalStateInstance() {
            ClientState state = ClientState.forInternalCalls();
            state.setKeyspace("system");
            this.queryState = new QueryState(state);
        }
    }
}

