/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import java.util.UUID;
import org.cassandraunit.shaded.com.google.common.collect.ImmutableSet;

public final class SchemaConstants {
    public static final String SYSTEM_KEYSPACE_NAME = "system";
    public static final String SCHEMA_KEYSPACE_NAME = "system_schema";
    public static final String TRACE_KEYSPACE_NAME = "system_traces";
    public static final String AUTH_KEYSPACE_NAME = "system_auth";
    public static final String DISTRIBUTED_KEYSPACE_NAME = "system_distributed";
    public static final Set<String> SYSTEM_KEYSPACE_NAMES = ImmutableSet.of("system", "system_schema");
    public static final Set<String> REPLICATED_SYSTEM_KEYSPACE_NAMES = ImmutableSet.of("system_traces", "system_auth", "system_distributed");
    public static final int NAME_LENGTH = 48;
    public static final UUID emptyVersion;

    public static boolean isSystemKeyspace(String keyspaceName) {
        return SYSTEM_KEYSPACE_NAMES.contains(keyspaceName.toLowerCase());
    }

    static {
        try {
            emptyVersion = UUID.nameUUIDFromBytes(MessageDigest.getInstance("MD5").digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
    }
}

