/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.shaded.org.antlr.codegen;

import org.cassandraunit.shaded.org.antlr.Tool;
import org.cassandraunit.shaded.org.antlr.codegen.CodeGenerator;
import org.cassandraunit.shaded.org.antlr.codegen.Target;
import org.cassandraunit.shaded.org.antlr.tool.Grammar;
import org.stringtemplate.v4.ST;

public class ActionScriptTarget
extends Target {
    public String getTargetCharLiteralFromANTLRCharLiteral(CodeGenerator generator, String literal) {
        int c = Grammar.getCharValueFromGrammarCharLiteral(literal);
        return String.valueOf(c);
    }

    public String getTokenTypeAsTargetLabel(CodeGenerator generator, int ttype) {
        if (ttype >= 0 && ttype <= 3) {
            return String.valueOf(ttype);
        }
        String name = generator.grammar.getTokenDisplayName(ttype);
        if (name.charAt(0) == '\'') {
            return String.valueOf(ttype);
        }
        return name;
    }

    public String encodeIntAsCharEscape(int v) {
        if (v <= 255) {
            return "\\x" + Integer.toHexString(v | 0x100).substring(1, 3);
        }
        if (v <= Short.MAX_VALUE) {
            String hex = Integer.toHexString(v | 0x10000).substring(1, 5);
            return "\\u" + hex;
        }
        if (v > 65535) {
            System.err.println("Warning: character literal out of range for ActionScript target " + v);
            return "";
        }
        StringBuilder buf = new StringBuilder("\\u80");
        buf.append(Integer.toHexString(v >> 8 | 0x100).substring(1, 3));
        buf.append("\\x");
        buf.append(Integer.toHexString(v & 0xFF | 0x100).substring(1, 3));
        return buf.toString();
    }

    public String getTarget64BitStringFromValue(long word) {
        StringBuffer buf = new StringBuffer(22);
        buf.append("0x");
        this.writeHexWithPadding(buf, Integer.toHexString((int)(word & 0xFFFFFFFFL)));
        buf.append(", 0x");
        this.writeHexWithPadding(buf, Integer.toHexString((int)(word >> 32)));
        return buf.toString();
    }

    private void writeHexWithPadding(StringBuffer buf, String digits) {
        digits = digits.toUpperCase();
        int padding = 8 - digits.length();
        for (int i = 1; i <= padding; ++i) {
            buf.append('0');
        }
        buf.append(digits);
    }

    protected ST chooseWhereCyclicDFAsGo(Tool tool, CodeGenerator generator, Grammar grammar, ST recognizerST, ST cyclicDFAST) {
        return recognizerST;
    }
}

