/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.shaded.io.netty.channel;

import org.cassandraunit.shaded.io.netty.buffer.ByteBuf;
import org.cassandraunit.shaded.io.netty.buffer.ByteBufAllocator;
import org.cassandraunit.shaded.io.netty.channel.RecvByteBufAllocator;

public class FixedRecvByteBufAllocator
implements RecvByteBufAllocator {
    private final RecvByteBufAllocator.Handle handle;

    public FixedRecvByteBufAllocator(int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("bufferSize must greater than 0: " + bufferSize);
        }
        this.handle = new HandleImpl(bufferSize);
    }

    @Override
    public RecvByteBufAllocator.Handle newHandle() {
        return this.handle;
    }

    private static final class HandleImpl
    implements RecvByteBufAllocator.Handle {
        private final int bufferSize;

        HandleImpl(int bufferSize) {
            this.bufferSize = bufferSize;
        }

        @Override
        public ByteBuf allocate(ByteBufAllocator alloc) {
            return alloc.ioBuffer(this.bufferSize);
        }

        @Override
        public int guess() {
            return this.bufferSize;
        }

        @Override
        public void record(int actualReadBytes) {
        }
    }
}

