/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.shaded.com.addthis.metrics3.reporter.config;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import io.github.hengyunabc.zabbix.sender.DataObject;
import io.github.hengyunabc.zabbix.sender.SenderResult;
import io.github.hengyunabc.zabbix.sender.ZabbixSender;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZabbixReporter
extends ScheduledReporter {
    private static final Logger log = LoggerFactory.getLogger(ZabbixReporter.class);
    private final ZabbixSender sender;
    private final String hostName;
    private final String prefix;

    public ZabbixReporter(ZabbixSender sender, String hostName, String prefix, MetricRegistry registry, String name, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit) {
        super(registry, name, filter, rateUnit, durationUnit);
        this.sender = sender;
        this.hostName = hostName;
        this.prefix = prefix;
    }

    private DataObject toDataObject(String key, String suffix, Object value) {
        return DataObject.builder().host(this.hostName).key(this.prefix + key + suffix).value("" + value).build();
    }

    private void addSnapshotDataObject(String key, Snapshot snapshot, List<DataObject> dataObjectList) {
        dataObjectList.add(this.toDataObject(key, ".min", snapshot.getMin()));
        dataObjectList.add(this.toDataObject(key, ".max", snapshot.getMax()));
        dataObjectList.add(this.toDataObject(key, ".mean", snapshot.getMean()));
        dataObjectList.add(this.toDataObject(key, ".stddev", snapshot.getStdDev()));
        dataObjectList.add(this.toDataObject(key, ".median", snapshot.getMedian()));
        dataObjectList.add(this.toDataObject(key, ".75th", snapshot.get75thPercentile()));
        dataObjectList.add(this.toDataObject(key, ".95th", snapshot.get95thPercentile()));
        dataObjectList.add(this.toDataObject(key, ".98th", snapshot.get98thPercentile()));
        dataObjectList.add(this.toDataObject(key, ".99th", snapshot.get99thPercentile()));
        dataObjectList.add(this.toDataObject(key, ".99.9th", snapshot.get999thPercentile()));
    }

    private void addSnapshotDataObjectWithConvertDuration(String key, Snapshot snapshot, List<DataObject> dataObjectList) {
        dataObjectList.add(this.toDataObject(key, ".min", this.convertDuration(snapshot.getMin())));
        dataObjectList.add(this.toDataObject(key, ".max", this.convertDuration(snapshot.getMax())));
        dataObjectList.add(this.toDataObject(key, ".mean", this.convertDuration(snapshot.getMean())));
        dataObjectList.add(this.toDataObject(key, ".stddev", this.convertDuration(snapshot.getStdDev())));
        dataObjectList.add(this.toDataObject(key, ".median", this.convertDuration(snapshot.getMedian())));
        dataObjectList.add(this.toDataObject(key, ".75th", this.convertDuration(snapshot.get75thPercentile())));
        dataObjectList.add(this.toDataObject(key, ".95th", this.convertDuration(snapshot.get95thPercentile())));
        dataObjectList.add(this.toDataObject(key, ".98th", this.convertDuration(snapshot.get98thPercentile())));
        dataObjectList.add(this.toDataObject(key, ".99th", this.convertDuration(snapshot.get99thPercentile())));
        dataObjectList.add(this.toDataObject(key, ".99.9th", this.convertDuration(snapshot.get999thPercentile())));
    }

    private void addMeterDataObject(String key, Metered meter, List<DataObject> dataObjectList) {
        dataObjectList.add(this.toDataObject(key, ".count", meter.getCount()));
        dataObjectList.add(this.toDataObject(key, ".meanRate", this.convertRate(meter.getMeanRate())));
        dataObjectList.add(this.toDataObject(key, ".1-minuteRate", this.convertRate(meter.getOneMinuteRate())));
        dataObjectList.add(this.toDataObject(key, ".5-minuteRate", this.convertRate(meter.getFiveMinuteRate())));
        dataObjectList.add(this.toDataObject(key, ".15-minuteRate", this.convertRate(meter.getFifteenMinuteRate())));
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        DataObject dataObject;
        ArrayList<DataObject> dataObjectList = new ArrayList<DataObject>();
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            dataObject = DataObject.builder().host(this.hostName).key(this.prefix + entry.getKey()).value(entry.getValue().getValue().toString()).build();
            dataObjectList.add(dataObject);
        }
        for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
            dataObject = DataObject.builder().host(this.hostName).key(this.prefix + entry.getKey()).value("" + ((Counter)entry.getValue()).getCount()).build();
            dataObjectList.add(dataObject);
        }
        for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
            Histogram histogram = (Histogram)entry.getValue();
            Snapshot snapshot = histogram.getSnapshot();
            this.addSnapshotDataObject(entry.getKey(), snapshot, dataObjectList);
        }
        for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
            Meter meter = (Meter)entry.getValue();
            this.addMeterDataObject(entry.getKey(), (Metered)meter, dataObjectList);
        }
        for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
            Timer timer = (Timer)entry.getValue();
            this.addMeterDataObject(entry.getKey(), (Metered)timer, dataObjectList);
            this.addSnapshotDataObjectWithConvertDuration(entry.getKey(), timer.getSnapshot(), dataObjectList);
        }
        try {
            SenderResult senderResult = this.sender.send(dataObjectList);
            if (!senderResult.success()) {
                log.warn("metrics reporting to zabbix {} unsuccessful: {}", new Object[]{this.sender.getHost(), this.sender.getPort(), senderResult});
            } else if (log.isDebugEnabled()) {
                log.debug("metrics reported to zabbix {} {}: {}", new Object[]{this.sender.getHost(), this.sender.getPort(), senderResult});
            }
        }
        catch (IOException e) {
            log.error("failed to report metrics to " + this.sender.getHost() + ':' + this.sender.getPort(), (Throwable)e);
        }
    }
}

