/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.cassandra.utils.BiMultiValMap;
import org.cassandraunit.shaded.com.google.common.collect.SortedSetMultimap;
import org.cassandraunit.shaded.com.google.common.collect.TreeMultimap;

public class SortedBiMultiValMap<K, V>
extends BiMultiValMap<K, V> {
    private static final Comparator DEFAULT_COMPARATOR = (o1, o2) -> ((Comparable)o1).compareTo(o2);

    protected SortedBiMultiValMap(SortedMap<K, V> forwardMap, SortedSetMultimap<V, K> reverseMap) {
        super(forwardMap, reverseMap);
    }

    public static <K extends Comparable<K>, V extends Comparable<V>> SortedBiMultiValMap<K, V> create() {
        return new SortedBiMultiValMap(new TreeMap(), TreeMultimap.create());
    }

    public static <K, V> SortedBiMultiValMap<K, V> create(Comparator<K> keyComparator, Comparator<V> valueComparator) {
        if (keyComparator == null) {
            keyComparator = SortedBiMultiValMap.defaultComparator();
        }
        if (valueComparator == null) {
            valueComparator = SortedBiMultiValMap.defaultComparator();
        }
        return new SortedBiMultiValMap(new TreeMap(keyComparator), TreeMultimap.create(valueComparator, keyComparator));
    }

    public static <K extends Comparable<K>, V extends Comparable<V>> SortedBiMultiValMap<K, V> create(BiMultiValMap<K, V> map) {
        SortedBiMultiValMap<K, V> newMap = SortedBiMultiValMap.create();
        SortedBiMultiValMap.copy(map, newMap);
        return newMap;
    }

    public static <K, V> SortedBiMultiValMap<K, V> create(BiMultiValMap<K, V> map, Comparator<K> keyComparator, Comparator<V> valueComparator) {
        SortedBiMultiValMap<K, V> newMap = SortedBiMultiValMap.create(keyComparator, valueComparator);
        SortedBiMultiValMap.copy(map, newMap);
        return newMap;
    }

    private static <K, V> void copy(BiMultiValMap<K, V> map, BiMultiValMap<K, V> newMap) {
        newMap.forwardMap.putAll(map.forwardMap);
        for (Map.Entry<V, Collection<K>> entry : map.inverse().asMap().entrySet()) {
            newMap.reverseMap.putAll(entry.getKey(), (Iterable)entry.getValue());
        }
    }

    private static <T> Comparator<T> defaultComparator() {
        return DEFAULT_COMPARATOR;
    }
}

