/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.cassandraunit.shaded.io.netty.channel.ChannelHandler;
import org.cassandraunit.shaded.io.netty.channel.ChannelHandlerContext;
import org.cassandraunit.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
final class ConnectionLimitHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionLimitHandler.class);
    private final ConcurrentMap<InetAddress, AtomicLong> connectionsPerClient = new ConcurrentHashMap<InetAddress, AtomicLong>();
    private final AtomicLong counter = new AtomicLong(0L);

    ConnectionLimitHandler() {
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        long count = this.counter.incrementAndGet();
        long limit = DatabaseDescriptor.getNativeTransportMaxConcurrentConnections();
        if (limit < 0L) {
            limit = Long.MAX_VALUE;
        }
        if (count > limit) {
            logger.warn("Exceeded maximum native connection limit of {} by using {} connections", (Object)limit, (Object)count);
            ctx.close();
        } else {
            long perIpLimit = DatabaseDescriptor.getNativeTransportMaxConcurrentConnectionsPerIp();
            if (perIpLimit > 0L) {
                AtomicLong old;
                InetAddress address = ((InetSocketAddress)ctx.channel().remoteAddress()).getAddress();
                AtomicLong perIpCount = (AtomicLong)this.connectionsPerClient.get(address);
                if (perIpCount == null && (old = this.connectionsPerClient.putIfAbsent(address, perIpCount = new AtomicLong(0L))) != null) {
                    perIpCount = old;
                }
                if (perIpCount.incrementAndGet() > perIpLimit) {
                    logger.warn("Exceeded maximum native connection limit per ip of {} by using {} connections", (Object)perIpLimit, (Object)perIpCount);
                    ctx.close();
                    return;
                }
            }
            ctx.fireChannelActive();
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.counter.decrementAndGet();
        InetAddress address = ((InetSocketAddress)ctx.channel().remoteAddress()).getAddress();
        AtomicLong count = (AtomicLong)this.connectionsPerClient.get(address);
        if (count != null && count.decrementAndGet() <= 0L) {
            this.connectionsPerClient.remove(address);
        }
        ctx.fireChannelInactive();
    }
}

