/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.cassandra.cache.AutoSavingCache;
import org.apache.cassandra.cache.CacheProvider;
import org.apache.cassandra.cache.ConcurrentLinkedHashCache;
import org.apache.cassandra.cache.CounterCacheKey;
import org.apache.cassandra.cache.ICache;
import org.apache.cassandra.cache.IRowCacheEntry;
import org.apache.cassandra.cache.KeyCacheKey;
import org.apache.cassandra.cache.RowCacheKey;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ClockAndCount;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.big.BigFormat;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.service.CacheServiceMBean;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MBeanWrapper;
import org.apache.cassandra.utils.Pair;
import org.cassandraunit.shaded.com.google.common.util.concurrent.Futures;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheService
implements CacheServiceMBean {
    private static final Logger logger = LoggerFactory.getLogger(CacheService.class);
    public static final String MBEAN_NAME = "org.apache.cassandra.db:type=Caches";
    public static final CacheService instance = new CacheService();
    public final AutoSavingCache<KeyCacheKey, RowIndexEntry> keyCache;
    public final AutoSavingCache<RowCacheKey, IRowCacheEntry> rowCache;
    public final AutoSavingCache<CounterCacheKey, ClockAndCount> counterCache;

    private CacheService() {
        MBeanWrapper.instance.registerMBean((Object)this, MBEAN_NAME);
        this.keyCache = this.initKeyCache();
        this.rowCache = this.initRowCache();
        this.counterCache = this.initCounterCache();
    }

    private AutoSavingCache<KeyCacheKey, RowIndexEntry> initKeyCache() {
        logger.info("Initializing key cache with capacity of {} MBs.", (Object)DatabaseDescriptor.getKeyCacheSizeInMB());
        long keyCacheInMemoryCapacity = DatabaseDescriptor.getKeyCacheSizeInMB() * 1024L * 1024L;
        ConcurrentLinkedHashCache kc = ConcurrentLinkedHashCache.create(keyCacheInMemoryCapacity);
        AutoSavingCache<KeyCacheKey, RowIndexEntry> keyCache = new AutoSavingCache<KeyCacheKey, RowIndexEntry>(kc, CacheType.KEY_CACHE, new KeyCacheSerializer());
        int keyCacheKeysToSave = DatabaseDescriptor.getKeyCacheKeysToSave();
        keyCache.scheduleSaving(DatabaseDescriptor.getKeyCacheSavePeriod(), keyCacheKeysToSave);
        return keyCache;
    }

    private AutoSavingCache<RowCacheKey, IRowCacheEntry> initRowCache() {
        CacheProvider cacheProvider;
        logger.info("Initializing row cache with capacity of {} MBs", (Object)DatabaseDescriptor.getRowCacheSizeInMB());
        String cacheProviderClassName = DatabaseDescriptor.getRowCacheSizeInMB() > 0L ? DatabaseDescriptor.getRowCacheClassName() : "org.apache.cassandra.cache.NopCacheProvider";
        try {
            Class<?> cacheProviderClass = Class.forName(cacheProviderClassName);
            cacheProvider = (CacheProvider)cacheProviderClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot find configured row cache provider class " + DatabaseDescriptor.getRowCacheClassName());
        }
        ICache rc = cacheProvider.create();
        AutoSavingCache<RowCacheKey, IRowCacheEntry> rowCache = new AutoSavingCache<RowCacheKey, IRowCacheEntry>(rc, CacheType.ROW_CACHE, new RowCacheSerializer());
        int rowCacheKeysToSave = DatabaseDescriptor.getRowCacheKeysToSave();
        rowCache.scheduleSaving(DatabaseDescriptor.getRowCacheSavePeriod(), rowCacheKeysToSave);
        return rowCache;
    }

    private AutoSavingCache<CounterCacheKey, ClockAndCount> initCounterCache() {
        logger.info("Initializing counter cache with capacity of {} MBs", (Object)DatabaseDescriptor.getCounterCacheSizeInMB());
        long capacity = DatabaseDescriptor.getCounterCacheSizeInMB() * 1024L * 1024L;
        AutoSavingCache<CounterCacheKey, ClockAndCount> cache = new AutoSavingCache<CounterCacheKey, ClockAndCount>(ConcurrentLinkedHashCache.create(capacity), CacheType.COUNTER_CACHE, new CounterCacheSerializer());
        int keysToSave = DatabaseDescriptor.getCounterCacheKeysToSave();
        logger.info("Scheduling counter cache save to every {} seconds (going to save {} keys).", (Object)DatabaseDescriptor.getCounterCacheSavePeriod(), keysToSave == Integer.MAX_VALUE ? "all" : Integer.valueOf(keysToSave));
        cache.scheduleSaving(DatabaseDescriptor.getCounterCacheSavePeriod(), keysToSave);
        return cache;
    }

    @Override
    public int getRowCacheSavePeriodInSeconds() {
        return DatabaseDescriptor.getRowCacheSavePeriod();
    }

    @Override
    public void setRowCacheSavePeriodInSeconds(int seconds) {
        if (seconds < 0) {
            throw new RuntimeException("RowCacheSavePeriodInSeconds must be non-negative.");
        }
        DatabaseDescriptor.setRowCacheSavePeriod(seconds);
        this.rowCache.scheduleSaving(seconds, DatabaseDescriptor.getRowCacheKeysToSave());
    }

    @Override
    public int getKeyCacheSavePeriodInSeconds() {
        return DatabaseDescriptor.getKeyCacheSavePeriod();
    }

    @Override
    public void setKeyCacheSavePeriodInSeconds(int seconds) {
        if (seconds < 0) {
            throw new RuntimeException("KeyCacheSavePeriodInSeconds must be non-negative.");
        }
        DatabaseDescriptor.setKeyCacheSavePeriod(seconds);
        this.keyCache.scheduleSaving(seconds, DatabaseDescriptor.getKeyCacheKeysToSave());
    }

    @Override
    public int getCounterCacheSavePeriodInSeconds() {
        return DatabaseDescriptor.getCounterCacheSavePeriod();
    }

    @Override
    public void setCounterCacheSavePeriodInSeconds(int seconds) {
        if (seconds < 0) {
            throw new RuntimeException("CounterCacheSavePeriodInSeconds must be non-negative.");
        }
        DatabaseDescriptor.setCounterCacheSavePeriod(seconds);
        this.counterCache.scheduleSaving(seconds, DatabaseDescriptor.getCounterCacheKeysToSave());
    }

    @Override
    public int getRowCacheKeysToSave() {
        return DatabaseDescriptor.getRowCacheKeysToSave();
    }

    @Override
    public void setRowCacheKeysToSave(int count) {
        if (count < 0) {
            throw new RuntimeException("RowCacheKeysToSave must be non-negative.");
        }
        DatabaseDescriptor.setRowCacheKeysToSave(count);
        this.rowCache.scheduleSaving(this.getRowCacheSavePeriodInSeconds(), count);
    }

    @Override
    public int getKeyCacheKeysToSave() {
        return DatabaseDescriptor.getKeyCacheKeysToSave();
    }

    @Override
    public void setKeyCacheKeysToSave(int count) {
        if (count < 0) {
            throw new RuntimeException("KeyCacheKeysToSave must be non-negative.");
        }
        DatabaseDescriptor.setKeyCacheKeysToSave(count);
        this.keyCache.scheduleSaving(this.getKeyCacheSavePeriodInSeconds(), count);
    }

    @Override
    public int getCounterCacheKeysToSave() {
        return DatabaseDescriptor.getCounterCacheKeysToSave();
    }

    @Override
    public void setCounterCacheKeysToSave(int count) {
        if (count < 0) {
            throw new RuntimeException("CounterCacheKeysToSave must be non-negative.");
        }
        DatabaseDescriptor.setCounterCacheKeysToSave(count);
        this.counterCache.scheduleSaving(this.getCounterCacheSavePeriodInSeconds(), count);
    }

    @Override
    public void invalidateKeyCache() {
        this.keyCache.clear();
    }

    public void invalidateKeyCacheForCf(Pair<String, String> ksAndCFName) {
        Iterator keyCacheIterator = this.keyCache.keyIterator();
        while (keyCacheIterator.hasNext()) {
            KeyCacheKey key = (KeyCacheKey)keyCacheIterator.next();
            if (!key.ksAndCFName.equals(ksAndCFName)) continue;
            keyCacheIterator.remove();
        }
    }

    @Override
    public void invalidateRowCache() {
        this.rowCache.clear();
    }

    public void invalidateRowCacheForCf(Pair<String, String> ksAndCFName) {
        Iterator rowCacheIterator = this.rowCache.keyIterator();
        while (rowCacheIterator.hasNext()) {
            RowCacheKey rowCacheKey = (RowCacheKey)rowCacheIterator.next();
            if (!rowCacheKey.ksAndCFName.equals(ksAndCFName)) continue;
            rowCacheIterator.remove();
        }
    }

    public void invalidateCounterCacheForCf(Pair<String, String> ksAndCFName) {
        Iterator counterCacheIterator = this.counterCache.keyIterator();
        while (counterCacheIterator.hasNext()) {
            CounterCacheKey counterCacheKey = (CounterCacheKey)counterCacheIterator.next();
            if (!counterCacheKey.ksAndCFName.equals(ksAndCFName)) continue;
            counterCacheIterator.remove();
        }
    }

    @Override
    public void invalidateCounterCache() {
        this.counterCache.clear();
    }

    @Override
    public void setRowCacheCapacityInMB(long capacity) {
        if (capacity < 0L) {
            throw new RuntimeException("capacity should not be negative.");
        }
        this.rowCache.setCapacity(capacity * 1024L * 1024L);
    }

    @Override
    public void setKeyCacheCapacityInMB(long capacity) {
        if (capacity < 0L) {
            throw new RuntimeException("capacity should not be negative.");
        }
        this.keyCache.setCapacity(capacity * 1024L * 1024L);
    }

    @Override
    public void setCounterCacheCapacityInMB(long capacity) {
        if (capacity < 0L) {
            throw new RuntimeException("capacity should not be negative.");
        }
        this.counterCache.setCapacity(capacity * 1024L * 1024L);
    }

    @Override
    public void saveCaches() throws ExecutionException, InterruptedException {
        ArrayList futures = new ArrayList(3);
        logger.debug("submitting cache saves");
        futures.add(this.keyCache.submitWrite(DatabaseDescriptor.getKeyCacheKeysToSave()));
        futures.add(this.rowCache.submitWrite(DatabaseDescriptor.getRowCacheKeysToSave()));
        futures.add(this.counterCache.submitWrite(DatabaseDescriptor.getCounterCacheKeysToSave()));
        FBUtilities.waitOnFutures(futures);
        logger.debug("cache saves completed");
    }

    public static class KeyCacheSerializer
    implements AutoSavingCache.CacheSerializer<KeyCacheKey, RowIndexEntry> {
        @Override
        public void serialize(KeyCacheKey key, DataOutputPlus out, ColumnFamilyStore cfs) throws IOException {
            if (!key.desc.version.storeRows()) {
                return;
            }
            RowIndexEntry entry = (RowIndexEntry)CacheService.instance.keyCache.getInternal(key);
            if (entry == null) {
                return;
            }
            out.write(cfs.metadata.ksAndCFBytes);
            ByteBufferUtil.writeWithLength(key.key, (DataOutput)out);
            out.writeInt(key.desc.generation);
            out.writeBoolean(true);
            SerializationHeader header = new SerializationHeader(false, cfs.metadata, cfs.metadata.partitionColumns(), EncodingStats.NO_STATS);
            key.desc.getFormat().getIndexSerializer(cfs.metadata, key.desc.version, header).serializeForCache(entry, out);
        }

        @Override
        public Future<Pair<KeyCacheKey, RowIndexEntry>> deserialize(DataInputPlus input, ColumnFamilyStore cfs) throws IOException {
            SSTableReader reader;
            int keyLength = input.readInt();
            if (keyLength > 65535) {
                throw new IOException(String.format("Corrupted key cache. Key length of %d is longer than maximum of %d", keyLength, 65535));
            }
            ByteBuffer key = ByteBufferUtil.read(input, keyLength);
            int generation = input.readInt();
            input.readBoolean();
            if (cfs == null || !cfs.isKeyCacheEnabled() || (reader = this.findDesc(generation, cfs.getSSTables(SSTableSet.CANONICAL))) == null) {
                RowIndexEntry.Serializer.skipForCache(input, BigFormat.instance.getLatestVersion());
                return null;
            }
            RowIndexEntry.IndexSerializer<?> indexSerializer = reader.descriptor.getFormat().getIndexSerializer(reader.metadata, reader.descriptor.version, reader.header);
            RowIndexEntry<?> entry = indexSerializer.deserializeForCache(input);
            return Futures.immediateFuture(Pair.create(new KeyCacheKey(cfs.metadata.ksAndCFName, reader.descriptor, key), entry));
        }

        private SSTableReader findDesc(int generation, Iterable<SSTableReader> collection) {
            for (SSTableReader sstable : collection) {
                if (sstable.descriptor.generation != generation) continue;
                return sstable;
            }
            return null;
        }
    }

    public static class RowCacheSerializer
    implements AutoSavingCache.CacheSerializer<RowCacheKey, IRowCacheEntry> {
        @Override
        public void serialize(RowCacheKey key, DataOutputPlus out, ColumnFamilyStore cfs) throws IOException {
            assert (!cfs.isIndex());
            out.write(cfs.metadata.ksAndCFBytes);
            ByteBufferUtil.writeWithLength(key.key, (DataOutput)out);
        }

        @Override
        public Future<Pair<RowCacheKey, IRowCacheEntry>> deserialize(DataInputPlus in, final ColumnFamilyStore cfs) throws IOException {
            final ByteBuffer buffer = ByteBufferUtil.readWithLength(in);
            if (cfs == null || !cfs.isRowCacheEnabled()) {
                return null;
            }
            final int rowsToCache = cfs.metadata.params.caching.rowsPerPartitionToCache();
            assert (!cfs.isIndex());
            return StageManager.getStage(Stage.READ).submit(new Callable<Pair<RowCacheKey, IRowCacheEntry>>(){

                /*
                 * Exception decompiling
                 */
                @Override
                public Pair<RowCacheKey, IRowCacheEntry> call() throws Exception {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
        }
    }

    public static class CounterCacheSerializer
    implements AutoSavingCache.CacheSerializer<CounterCacheKey, ClockAndCount> {
        @Override
        public void serialize(CounterCacheKey key, DataOutputPlus out, ColumnFamilyStore cfs) throws IOException {
            assert (cfs.metadata.isCounter());
            out.write(cfs.metadata.ksAndCFBytes);
            ByteBufferUtil.writeWithLength(key.partitionKey, (DataOutput)out);
            ByteBufferUtil.writeWithLength(key.cellName, (DataOutput)out);
        }

        @Override
        public Future<Pair<CounterCacheKey, ClockAndCount>> deserialize(DataInputPlus in, final ColumnFamilyStore cfs) throws IOException {
            final ByteBuffer partitionKey = ByteBufferUtil.readWithLength(in);
            final ByteBuffer cellName = ByteBufferUtil.readWithLength(in);
            if (cfs == null || !cfs.metadata.isCounter() || !cfs.isCounterCacheEnabled()) {
                return null;
            }
            assert (cfs.metadata.isCounter());
            return StageManager.getStage(Stage.READ).submit(new Callable<Pair<CounterCacheKey, ClockAndCount>>(){

                /*
                 * Exception decompiling
                 */
                @Override
                public Pair<CounterCacheKey, ClockAndCount> call() throws Exception {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
        }
    }

    public static enum CacheType {
        KEY_CACHE("KeyCache"),
        ROW_CACHE("RowCache"),
        COUNTER_CACHE("CounterCache");

        private final String name;

        private CacheType(String typeName) {
            this.name = typeName;
        }

        public String toString() {
            return this.name;
        }
    }
}

