/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hints;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.cassandra.hints.HintsDescriptor;
import org.apache.cassandra.hints.HintsStore;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.utils.NativeLibrary;
import org.apache.cassandra.utils.SyncUtil;
import org.cassandraunit.shaded.com.google.common.collect.ImmutableMap;

final class HintsCatalog {
    private final File hintsDirectory;
    private final Map<UUID, HintsStore> stores;
    private final ImmutableMap<String, Object> writerParams;

    private HintsCatalog(File hintsDirectory, ImmutableMap<String, Object> writerParams, Map<UUID, List<HintsDescriptor>> descriptors) {
        this.hintsDirectory = hintsDirectory;
        this.writerParams = writerParams;
        this.stores = new ConcurrentHashMap<UUID, HintsStore>();
        for (Map.Entry<UUID, List<HintsDescriptor>> entry : descriptors.entrySet()) {
            this.stores.put(entry.getKey(), HintsStore.create(entry.getKey(), hintsDirectory, writerParams, entry.getValue()));
        }
    }

    static HintsCatalog load(File hintsDirectory, ImmutableMap<String, Object> writerParams) {
        try {
            Map<UUID, List<HintsDescriptor>> stores = Files.list(hintsDirectory.toPath()).filter(HintsDescriptor::isHintFileName).map(HintsDescriptor::readFromFileQuietly).filter(Optional::isPresent).map(Optional::get).collect(Collectors.groupingBy(h -> h.hostId));
            return new HintsCatalog(hintsDirectory, writerParams, stores);
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, hintsDirectory);
        }
    }

    Stream<HintsStore> stores() {
        return this.stores.values().stream();
    }

    void maybeLoadStores(Iterable<UUID> hostIds) {
        for (UUID hostId : hostIds) {
            this.get(hostId);
        }
    }

    HintsStore get(UUID hostId) {
        HintsStore store = this.stores.get(hostId);
        return store == null ? this.stores.computeIfAbsent(hostId, id -> HintsStore.create(id, this.hintsDirectory, this.writerParams, Collections.emptyList())) : store;
    }

    @Nullable
    HintsStore getNullable(UUID hostId) {
        return this.stores.get(hostId);
    }

    void deleteAllHints() {
        this.stores.keySet().forEach(this::deleteAllHints);
    }

    void deleteAllHints(UUID hostId) {
        HintsStore store = this.stores.get(hostId);
        if (store != null) {
            store.deleteAllHints();
        }
    }

    boolean hasFiles() {
        return this.stores().anyMatch(HintsStore::hasFiles);
    }

    void exciseStore(UUID hostId) {
        this.deleteAllHints(hostId);
        this.stores.remove(hostId);
    }

    void fsyncDirectory() {
        int fd = NativeLibrary.tryOpenDirectory(this.hintsDirectory.getAbsolutePath());
        if (fd != -1) {
            SyncUtil.trySync(fd);
            NativeLibrary.tryCloseFD(fd);
        }
    }

    ImmutableMap<String, Object> getWriterParams() {
        return this.writerParams;
    }
}

