/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.db.marshal.AbstractCompositeType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ColumnToCollectionType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.io.util.DataOutputBufferFixed;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.cassandraunit.shaded.com.google.common.collect.ImmutableList;

public class CompositeType
extends AbstractCompositeType {
    public static final int STATIC_MARKER = 65535;
    public final List<AbstractType<?>> types;
    private static final ConcurrentMap<List<AbstractType<?>>, CompositeType> instances = new ConcurrentHashMap();

    public static CompositeType getInstance(TypeParser parser) throws ConfigurationException, SyntaxException {
        return CompositeType.getInstance(parser.getTypeParameters());
    }

    public static CompositeType getInstance(AbstractType ... types) {
        return CompositeType.getInstance(Arrays.asList(types));
    }

    @Override
    protected boolean readIsStatic(ByteBuffer bb) {
        return CompositeType.readStatic(bb);
    }

    private static boolean readStatic(ByteBuffer bb) {
        if (bb.remaining() < 2) {
            return false;
        }
        int header = ByteBufferUtil.getShortLength(bb, bb.position());
        if ((header & 0xFFFF) != 65535) {
            return false;
        }
        ByteBufferUtil.readShortLength(bb);
        return true;
    }

    public static CompositeType getInstance(List<AbstractType<?>> types) {
        CompositeType previous;
        assert (types != null && !types.isEmpty());
        CompositeType ct = (CompositeType)instances.get(types);
        if (ct == null && (previous = instances.putIfAbsent(types, ct = new CompositeType(types))) != null) {
            ct = previous;
        }
        return ct;
    }

    protected CompositeType(List<AbstractType<?>> types) {
        this.types = ImmutableList.copyOf(types);
    }

    @Override
    protected AbstractType<?> getComparator(int i, ByteBuffer bb) {
        try {
            return this.types.get(i);
        }
        catch (IndexOutOfBoundsException e) {
            throw new RuntimeException("Cannot get comparator " + i + " in " + this + ". This might due to a mismatch between the schema and the data read", e);
        }
    }

    @Override
    protected AbstractType<?> getComparator(int i, ByteBuffer bb1, ByteBuffer bb2) {
        return this.getComparator(i, bb1);
    }

    @Override
    protected AbstractType<?> getAndAppendComparator(int i, ByteBuffer bb, StringBuilder sb) {
        return this.types.get(i);
    }

    @Override
    protected AbstractCompositeType.ParsedComparator parseComparator(int i, String part) {
        return new StaticParsedComparator(this.types.get(i), part);
    }

    @Override
    protected AbstractType<?> validateComparator(int i, ByteBuffer bb) throws MarshalException {
        if (i >= this.types.size()) {
            throw new MarshalException("Too many bytes for comparator");
        }
        return this.types.get(i);
    }

    @Override
    public ByteBuffer decompose(Object ... objects) {
        assert (objects.length == this.types.size());
        ByteBuffer[] serialized = new ByteBuffer[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            ByteBuffer buffer;
            serialized[i] = buffer = this.types.get(i).decompose(objects[i]);
        }
        return CompositeType.build(serialized);
    }

    @Override
    public ByteBuffer[] split(ByteBuffer name) {
        ByteBuffer[] l = new ByteBuffer[this.types.size()];
        ByteBuffer bb = name.duplicate();
        CompositeType.readStatic(bb);
        int i = 0;
        while (bb.remaining() > 0) {
            l[i++] = ByteBufferUtil.readBytesWithShortLength(bb);
            bb.get();
        }
        return i == l.length ? l : Arrays.copyOfRange(l, 0, i);
    }

    public static List<ByteBuffer> splitName(ByteBuffer name) {
        ArrayList<ByteBuffer> l = new ArrayList<ByteBuffer>();
        ByteBuffer bb = name.duplicate();
        CompositeType.readStatic(bb);
        while (bb.remaining() > 0) {
            l.add(ByteBufferUtil.readBytesWithShortLength(bb));
            bb.get();
        }
        return l;
    }

    public static byte lastEOC(ByteBuffer name) {
        return name.get(name.limit() - 1);
    }

    public static ByteBuffer extractComponent(ByteBuffer bb, int idx) {
        bb = bb.duplicate();
        CompositeType.readStatic(bb);
        int i = 0;
        while (bb.remaining() > 0) {
            ByteBuffer c = ByteBufferUtil.readBytesWithShortLength(bb);
            if (i == idx) {
                return c;
            }
            bb.get();
            ++i;
        }
        return null;
    }

    public ByteBuffer extractLastComponent(ByteBuffer bb) {
        int idx = this.types.get(this.types.size() - 1) instanceof ColumnToCollectionType ? this.types.size() - 2 : this.types.size() - 1;
        return CompositeType.extractComponent(bb, idx);
    }

    public static boolean isStaticName(ByteBuffer bb) {
        return bb.remaining() >= 2 && (ByteBufferUtil.getShortLength(bb, bb.position()) & 0xFFFF) == 65535;
    }

    @Override
    public int componentsCount() {
        return this.types.size();
    }

    @Override
    public List<AbstractType<?>> getComponents() {
        return this.types;
    }

    @Override
    public boolean isCompatibleWith(AbstractType<?> previous) {
        if (this == previous) {
            return true;
        }
        if (!(previous instanceof CompositeType)) {
            return false;
        }
        CompositeType cp = (CompositeType)previous;
        if (this.types.size() < cp.types.size()) {
            return false;
        }
        for (int i = 0; i < cp.types.size(); ++i) {
            AbstractType<?> tprev = cp.types.get(i);
            AbstractType<?> tnew = this.types.get(i);
            if (tnew.isCompatibleWith(tprev)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isValueCompatibleWithInternal(AbstractType<?> otherType) {
        if (this == otherType) {
            return true;
        }
        if (!(otherType instanceof CompositeType)) {
            return false;
        }
        CompositeType cp = (CompositeType)otherType;
        if (this.types.size() < cp.types.size()) {
            return false;
        }
        for (int i = 0; i < cp.types.size(); ++i) {
            AbstractType<?> tprev = cp.types.get(i);
            AbstractType<?> tnew = this.types.get(i);
            if (tnew.isValueCompatibleWith(tprev)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + TypeParser.stringifyTypeParameters(this.types);
    }

    public Builder builder() {
        return new Builder(this);
    }

    public Builder builder(boolean isStatic) {
        return new Builder(this, isStatic);
    }

    public static ByteBuffer build(ByteBuffer ... buffers) {
        return CompositeType.build(false, buffers);
    }

    public static ByteBuffer build(boolean isStatic, ByteBuffer ... buffers) {
        int totalLength = isStatic ? 2 : 0;
        for (ByteBuffer bb : buffers) {
            totalLength += 2 + bb.remaining() + 1;
        }
        ByteBuffer out = ByteBuffer.allocate(totalLength);
        if (isStatic) {
            out.putShort((short)-1);
        }
        for (ByteBuffer bb : buffers) {
            ByteBufferUtil.writeShortLength(out, bb.remaining());
            int toCopy = bb.remaining();
            ByteBufferUtil.arrayCopy(bb, bb.position(), out, out.position(), toCopy);
            out.position(out.position() + toCopy);
            out.put((byte)0);
        }
        out.flip();
        return out;
    }

    public static class Builder {
        private final CompositeType composite;
        private final List<ByteBuffer> components;
        private final byte[] endOfComponents;
        private int serializedSize;
        private final boolean isStatic;

        public Builder(CompositeType composite) {
            this(composite, false);
        }

        public Builder(CompositeType composite, boolean isStatic) {
            this(composite, new ArrayList<ByteBuffer>(composite.types.size()), new byte[composite.types.size()], isStatic);
        }

        private Builder(CompositeType composite, List<ByteBuffer> components, byte[] endOfComponents, boolean isStatic) {
            assert (endOfComponents.length == composite.types.size());
            this.composite = composite;
            this.components = components;
            this.endOfComponents = endOfComponents;
            this.isStatic = isStatic;
            if (isStatic) {
                this.serializedSize = 2;
            }
        }

        private Builder(Builder b) {
            this(b.composite, new ArrayList<ByteBuffer>(b.components), Arrays.copyOf(b.endOfComponents, b.endOfComponents.length), b.isStatic);
            this.serializedSize = b.serializedSize;
        }

        public Builder add(ByteBuffer bb) {
            if (this.components.size() >= this.composite.types.size()) {
                throw new IllegalStateException("Composite column is already fully constructed");
            }
            this.components.add(bb);
            this.serializedSize += 3 + bb.remaining();
            return this;
        }

        public Builder add(ColumnIdentifier name) {
            return this.add(name.bytes);
        }

        public int componentCount() {
            return this.components.size();
        }

        public int remainingCount() {
            return this.composite.types.size() - this.components.size();
        }

        public ByteBuffer get(int i) {
            return this.components.get(i);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ByteBuffer build() {
            try (DataOutputBufferFixed out = new DataOutputBufferFixed(this.serializedSize);){
                if (this.isStatic) {
                    out.writeShort(65535);
                }
                for (int i = 0; i < this.components.size(); ++i) {
                    ByteBufferUtil.writeWithShortLength(this.components.get(i), out);
                    out.write(this.endOfComponents[i]);
                }
                ByteBuffer byteBuffer = ByteBuffer.wrap(out.getData(), 0, out.getLength());
                return byteBuffer;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public ByteBuffer buildAsEndOfRange() {
            if (this.components.isEmpty()) {
                return ByteBufferUtil.EMPTY_BYTE_BUFFER;
            }
            ByteBuffer bb = this.build();
            bb.put(bb.remaining() - 1, (byte)1);
            return bb;
        }

        public ByteBuffer buildForRelation(Operator op) {
            int current = this.components.size() - 1;
            switch (op) {
                case LT: {
                    this.endOfComponents[current] = -1;
                    break;
                }
                case GT: 
                case LTE: {
                    this.endOfComponents[current] = 1;
                    break;
                }
                default: {
                    this.endOfComponents[current] = 0;
                }
            }
            return this.build();
        }

        public Builder copy() {
            return new Builder(this);
        }

        public ByteBuffer getComponent(int i) {
            if (i >= this.components.size()) {
                throw new IllegalArgumentException();
            }
            return this.components.get(i);
        }
    }

    private static class StaticParsedComparator
    implements AbstractCompositeType.ParsedComparator {
        final AbstractType<?> type;
        final String part;

        StaticParsedComparator(AbstractType<?> type, String part) {
            this.type = type;
            this.part = part;
        }

        @Override
        public AbstractType<?> getAbstractType() {
            return this.type;
        }

        @Override
        public String getRemainingPart() {
            return this.part;
        }

        @Override
        public int getComparatorSerializedSize() {
            return 0;
        }

        @Override
        public void serializeComparator(ByteBuffer bb) {
        }
    }
}

