/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.io.File;
import java.util.Arrays;
import java.util.function.Predicate;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionIterator;
import org.apache.cassandra.db.compaction.CompactionStrategyManager;
import org.apache.cassandra.db.compaction.CompactionTask;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableRewriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.cassandra.utils.UUIDGen;
import org.cassandraunit.shaded.com.google.common.base.Throwables;
import org.cassandraunit.shaded.com.google.common.collect.Sets;

public class Upgrader {
    private final ColumnFamilyStore cfs;
    private final SSTableReader sstable;
    private final LifecycleTransaction transaction;
    private final File directory;
    private final CompactionController controller;
    private final CompactionStrategyManager strategyManager;
    private final long estimatedRows;
    private final OutputHandler outputHandler;

    public Upgrader(ColumnFamilyStore cfs, LifecycleTransaction txn, OutputHandler outputHandler) {
        this.cfs = cfs;
        this.transaction = txn;
        this.sstable = txn.onlyOne();
        this.outputHandler = outputHandler;
        this.directory = new File(this.sstable.getFilename()).getParentFile();
        this.controller = new UpgradeController(cfs);
        this.strategyManager = cfs.getCompactionStrategyManager();
        long estimatedTotalKeys = Math.max((long)cfs.metadata.params.minIndexInterval, SSTableReader.getApproximateKeyCount(Arrays.asList(this.sstable)));
        long estimatedSSTables = Math.max(1L, SSTableReader.getTotalBytes(Arrays.asList(this.sstable)) / this.strategyManager.getMaxSSTableBytes());
        this.estimatedRows = (long)Math.ceil((double)estimatedTotalKeys / (double)estimatedSSTables);
    }

    private SSTableWriter createCompactionWriter(long repairedAt) {
        MetadataCollector sstableMetadataCollector = new MetadataCollector(this.cfs.getComparator());
        sstableMetadataCollector.sstableLevel(this.sstable.getSSTableLevel());
        return SSTableWriter.create(Descriptor.fromFilename(this.cfs.getSSTablePath(this.directory)), this.estimatedRows, (Long)repairedAt, this.cfs.metadata, sstableMetadataCollector, SerializationHeader.make(this.cfs.metadata, Sets.newHashSet(this.sstable)), this.cfs.indexManager.listIndexes(), (LifecycleNewTracker)this.transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgrade(boolean keepOriginals) {
        this.outputHandler.output("Upgrading " + this.sstable);
        int nowInSec = FBUtilities.nowInSeconds();
        try (SSTableRewriter writer = SSTableRewriter.construct(this.cfs, this.transaction, keepOriginals, CompactionTask.getMaxDataAge(this.transaction.originals()));
             AbstractCompactionStrategy.ScannerList scanners = this.strategyManager.getScanners(this.transaction.originals());
             CompactionIterator iter = new CompactionIterator(this.transaction.opType(), scanners.scanners, this.controller, nowInSec, UUIDGen.getTimeUUID());){
            writer.switchWriter(this.createCompactionWriter(this.sstable.getSSTableMetadata().repairedAt));
            while (iter.hasNext()) {
                writer.append(iter.next());
            }
            writer.finish();
            this.outputHandler.output("Upgrade of " + this.sstable + " complete.");
        }
        catch (Exception e) {
            Throwables.propagate(e);
        }
        finally {
            this.controller.close();
        }
    }

    private static class UpgradeController
    extends CompactionController {
        public UpgradeController(ColumnFamilyStore cfs) {
            super(cfs, Integer.MAX_VALUE);
        }

        @Override
        public Predicate<Long> getPurgeEvaluator(DecoratedKey key) {
            return time -> false;
        }
    }
}

