/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.BlacklistedDirectories;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.DiskBoundaries;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Splitter;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.service.PendingRangeCalculatorService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskBoundaryManager {
    private static final Logger logger = LoggerFactory.getLogger(DiskBoundaryManager.class);
    private volatile DiskBoundaries diskBoundaries;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiskBoundaries getDiskBoundaries(ColumnFamilyStore cfs) {
        if (!cfs.getPartitioner().splitter().isPresent()) {
            return new DiskBoundaries(cfs.getDirectories().getWriteableLocations(), BlacklistedDirectories.getDirectoriesVersion());
        }
        if (this.diskBoundaries == null || this.diskBoundaries.isOutOfDate()) {
            DiskBoundaryManager diskBoundaryManager = this;
            synchronized (diskBoundaryManager) {
                if (this.diskBoundaries == null || this.diskBoundaries.isOutOfDate()) {
                    logger.debug("Refreshing disk boundary cache for {}.{}", (Object)cfs.keyspace.getName(), (Object)cfs.getTableName());
                    DiskBoundaries oldBoundaries = this.diskBoundaries;
                    this.diskBoundaries = DiskBoundaryManager.getDiskBoundaryValue(cfs);
                    logger.debug("Updating boundaries from {} to {} for {}.{}", new Object[]{oldBoundaries, this.diskBoundaries, cfs.keyspace.getName(), cfs.getTableName()});
                }
            }
        }
        return this.diskBoundaries;
    }

    public void invalidate() {
        if (this.diskBoundaries != null) {
            this.diskBoundaries.invalidate();
        }
    }

    private static DiskBoundaries getDiskBoundaryValue(ColumnFamilyStore cfs) {
        Directories.DataDirectory[] dirs;
        int directoriesVersion;
        Collection localRanges;
        TokenMetadata tmd;
        long ringVersion;
        do {
            tmd = StorageService.instance.getTokenMetadata();
            ringVersion = tmd.getRingVersion();
            if (StorageService.instance.isBootstrapMode() && !StorageService.isReplacingSameAddress()) {
                PendingRangeCalculatorService.instance.blockUntilFinished();
                localRanges = tmd.getPendingRanges(cfs.keyspace.getName(), FBUtilities.getBroadcastAddress());
            } else {
                localRanges = cfs.keyspace.getReplicationStrategy().getAddressRanges(tmd.cloneAfterAllSettled()).get(FBUtilities.getBroadcastAddress());
            }
            logger.debug("Got local ranges {} (ringVersion = {})", localRanges, (Object)ringVersion);
        } while (ringVersion != tmd.getRingVersion());
        do {
            directoriesVersion = BlacklistedDirectories.getDirectoriesVersion();
            dirs = cfs.getDirectories().getWriteableLocations();
        } while (directoriesVersion != BlacklistedDirectories.getDirectoriesVersion());
        if (localRanges == null || localRanges.isEmpty()) {
            return new DiskBoundaries(dirs, null, ringVersion, directoriesVersion);
        }
        List<Range<Token>> sortedLocalRanges = Range.sort(localRanges);
        List<PartitionPosition> positions = DiskBoundaryManager.getDiskBoundaries(sortedLocalRanges, cfs.getPartitioner(), dirs);
        return new DiskBoundaries(dirs, positions, ringVersion, directoriesVersion);
    }

    private static List<PartitionPosition> getDiskBoundaries(List<Range<Token>> sortedLocalRanges, IPartitioner partitioner, Directories.DataDirectory[] dataDirectories) {
        assert (partitioner.splitter().isPresent());
        Splitter splitter = partitioner.splitter().get();
        boolean dontSplitRanges = DatabaseDescriptor.getNumTokens() > 1;
        List<Token> boundaries = splitter.splitOwnedRanges(dataDirectories.length, sortedLocalRanges, dontSplitRanges);
        if (dontSplitRanges && boundaries.size() < dataDirectories.length) {
            boundaries = splitter.splitOwnedRanges(dataDirectories.length, sortedLocalRanges, false);
        }
        ArrayList<PartitionPosition> diskBoundaries = new ArrayList<PartitionPosition>();
        for (int i = 0; i < boundaries.size() - 1; ++i) {
            diskBoundaries.add(boundaries.get(i).maxKeyBound());
        }
        diskBoundaries.add(partitioner.getMaximumToken().maxKeyBound());
        return diskBoundaries;
    }
}

