/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.shaded.org.apache.cassandra.thrift;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.service.CassandraDaemon;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.server.TServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TTransportFactory;
import org.cassandraunit.shaded.org.apache.cassandra.thrift.Cassandra;
import org.cassandraunit.shaded.org.apache.cassandra.thrift.CassandraServer;
import org.cassandraunit.shaded.org.apache.cassandra.thrift.TServerCustomFactory;
import org.cassandraunit.shaded.org.apache.cassandra.thrift.TServerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftServer
implements CassandraDaemon.Server {
    private static Logger logger = LoggerFactory.getLogger(ThriftServer.class);
    public static final String SYNC = "sync";
    public static final String ASYNC = "async";
    public static final String HSHA = "hsha";
    protected final InetAddress address;
    protected final int port;
    protected final int backlog;
    private volatile ThriftServerThread server;

    public ThriftServer(InetAddress address, int port, int backlog) {
        this.address = address;
        this.port = port;
        this.backlog = backlog;
    }

    @Override
    public void start() {
        if (this.server == null) {
            CassandraServer iface = this.getCassandraServer();
            this.server = new ThriftServerThread(this.address, this.port, this.backlog, this.getProcessor(iface), this.getTransportFactory());
            this.server.start();
        }
    }

    @Override
    public synchronized void stop() {
        if (this.server != null) {
            this.server.stopServer();
            try {
                this.server.join();
            }
            catch (InterruptedException e) {
                logger.error("Interrupted while waiting thrift server to stop", (Throwable)e);
            }
            this.server = null;
        }
    }

    @Override
    public boolean isRunning() {
        return this.server != null;
    }

    protected CassandraServer getCassandraServer() {
        return new CassandraServer();
    }

    protected TProcessor getProcessor(CassandraServer server) {
        return new Cassandra.Processor<CassandraServer>(server);
    }

    protected TTransportFactory getTransportFactory() {
        int tFramedTransportSize = DatabaseDescriptor.getThriftFramedTransportSize();
        return new TFramedTransport.Factory(tFramedTransportSize);
    }

    private static class ThriftServerThread
    extends Thread {
        private final TServer serverEngine;

        public ThriftServerThread(InetAddress listenAddr, int listenPort, int listenBacklog, TProcessor processor, TTransportFactory transportFactory) {
            logger.info(String.format("Binding thrift service to %s:%s", listenAddr, listenPort));
            TServerFactory.Args args = new TServerFactory.Args();
            args.tProtocolFactory = new TBinaryProtocol.Factory(true, true);
            args.addr = new InetSocketAddress(listenAddr, listenPort);
            args.listenBacklog = listenBacklog;
            args.processor = processor;
            args.keepAlive = DatabaseDescriptor.getRpcKeepAlive();
            args.sendBufferSize = DatabaseDescriptor.getRpcSendBufferSize();
            args.recvBufferSize = DatabaseDescriptor.getRpcRecvBufferSize();
            args.inTransportFactory = transportFactory;
            args.outTransportFactory = transportFactory;
            this.serverEngine = new TServerCustomFactory(DatabaseDescriptor.getRpcServerType()).buildTServer(args);
        }

        @Override
        public void run() {
            logger.info("Listening for thrift clients...");
            this.serverEngine.serve();
        }

        public void stopServer() {
            logger.info("Stop listening to thrift clients");
            this.serverEngine.stop();
        }
    }
}

