/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.shaded.org.apache.cassandra.thrift;

import org.apache.thrift.server.TServer;
import org.cassandraunit.shaded.org.apache.cassandra.thrift.CustomTNonBlockingServer;
import org.cassandraunit.shaded.org.apache.cassandra.thrift.CustomTThreadPoolServer;
import org.cassandraunit.shaded.org.apache.cassandra.thrift.THsHaDisruptorServer;
import org.cassandraunit.shaded.org.apache.cassandra.thrift.TServerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TServerCustomFactory
implements TServerFactory {
    private static Logger logger = LoggerFactory.getLogger(TServerCustomFactory.class);
    private final String serverType;

    public TServerCustomFactory(String serverType) {
        assert (serverType != null);
        this.serverType = serverType;
    }

    @Override
    public TServer buildTServer(TServerFactory.Args args) {
        TServer server;
        if ("sync".equalsIgnoreCase(this.serverType)) {
            server = new CustomTThreadPoolServer.Factory().buildTServer(args);
        } else if ("async".equalsIgnoreCase(this.serverType)) {
            server = new CustomTNonBlockingServer.Factory().buildTServer(args);
            logger.info(String.format("Using non-blocking/asynchronous thrift server on %s : %s", args.addr.getHostName(), args.addr.getPort()));
        } else if ("hsha".equalsIgnoreCase(this.serverType)) {
            server = new THsHaDisruptorServer.Factory().buildTServer(args);
            logger.info(String.format("Using custom half-sync/half-async thrift server on %s : %s", args.addr.getHostName(), args.addr.getPort()));
        } else {
            TServerFactory serverFactory;
            try {
                serverFactory = (TServerFactory)Class.forName(this.serverType).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to instantiate server factory:" + this.serverType, e);
            }
            server = serverFactory.buildTServer(args);
            logger.info(String.format("Using custom thrift server %s on %s : %s", server.getClass().getName(), args.addr.getHostName(), args.addr.getPort()));
        }
        return server;
    }
}

