/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.shaded.org.apache.cassandra.thrift;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLServerSocket;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.security.SSLFactory;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.cassandraunit.shaded.com.google.common.util.concurrent.Uninterruptibles;
import org.cassandraunit.shaded.org.apache.cassandra.thrift.TCustomServerSocket;
import org.cassandraunit.shaded.org.apache.cassandra.thrift.TServerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomTThreadPoolServer
extends TServer {
    private static final Logger logger = LoggerFactory.getLogger((String)CustomTThreadPoolServer.class.getName());
    private final ExecutorService executorService;
    private volatile boolean stopped;
    private final TThreadPoolServer.Args args;
    private final AtomicInteger activeClients = new AtomicInteger(0);

    public CustomTThreadPoolServer(TThreadPoolServer.Args args, ExecutorService executorService) {
        super((TServer.AbstractServerArgs)args);
        this.executorService = executorService;
        this.args = args;
    }

    public void serve() {
        try {
            this.serverTransport_.listen();
        }
        catch (TTransportException ttx) {
            logger.error("Error occurred during listening.", (Throwable)ttx);
            return;
        }
        this.stopped = false;
        while (!this.stopped) {
            block7: {
                while (this.activeClients.get() >= this.args.maxWorkerThreads) {
                    Uninterruptibles.sleepUninterruptibly(10L, TimeUnit.MILLISECONDS);
                }
                try {
                    TTransport client = this.serverTransport_.accept();
                    this.activeClients.incrementAndGet();
                    WorkerProcess wp = new WorkerProcess(client);
                    this.executorService.execute(wp);
                }
                catch (TTransportException ttx) {
                    if (ttx.getCause() instanceof SocketTimeoutException) continue;
                    if (this.stopped) break block7;
                    logger.warn("Transport error occurred during acceptance of message.", (Throwable)ttx);
                }
                catch (RejectedExecutionException e) {
                    logger.trace("Dropping client connection because our limit of {} has been reached", (Object)this.args.maxWorkerThreads);
                    continue;
                }
            }
            if (this.activeClients.get() < this.args.maxWorkerThreads) continue;
            logger.warn("Maximum number of clients {} reached", (Object)this.args.maxWorkerThreads);
        }
        this.executorService.shutdown();
    }

    public void stop() {
        this.stopped = true;
        this.serverTransport_.interrupt();
    }

    static /* synthetic */ TTransportFactory access$100(CustomTThreadPoolServer x0) {
        return x0.inputTransportFactory_;
    }

    static /* synthetic */ TTransportFactory access$200(CustomTThreadPoolServer x0) {
        return x0.outputTransportFactory_;
    }

    static /* synthetic */ TProcessorFactory access$300(CustomTThreadPoolServer x0) {
        return x0.processorFactory_;
    }

    static /* synthetic */ TProtocolFactory access$400(CustomTThreadPoolServer x0) {
        return x0.inputProtocolFactory_;
    }

    static /* synthetic */ TProtocolFactory access$500(CustomTThreadPoolServer x0) {
        return x0.outputProtocolFactory_;
    }

    static /* synthetic */ boolean access$600(CustomTThreadPoolServer x0) {
        return x0.stopped;
    }

    static /* synthetic */ TProtocolFactory access$700(CustomTThreadPoolServer x0) {
        return x0.inputProtocolFactory_;
    }

    static /* synthetic */ TProtocolFactory access$800(CustomTThreadPoolServer x0) {
        return x0.outputProtocolFactory_;
    }

    static /* synthetic */ AtomicInteger access$1000(CustomTThreadPoolServer x0) {
        return x0.activeClients;
    }

    public static class Factory
    implements TServerFactory {
        @Override
        public TServer buildTServer(TServerFactory.Args args) {
            TCustomServerSocket serverTransport;
            InetSocketAddress addr = args.addr;
            try {
                EncryptionOptions.ClientEncryptionOptions clientEnc = DatabaseDescriptor.getClientEncryptionOptions();
                if (clientEnc.enabled) {
                    logger.info("enabling encrypted thrift connections between client and server");
                    TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters(clientEnc.protocol, new String[0]);
                    params.setKeyStore(clientEnc.keystore, clientEnc.keystore_password);
                    if (clientEnc.require_client_auth) {
                        params.setTrustStore(clientEnc.truststore, clientEnc.truststore_password);
                        params.requireClientAuth(true);
                    }
                    TServerSocket sslServer = TSSLTransportFactory.getServerSocket((int)addr.getPort(), (int)0, (InetAddress)addr.getAddress(), (TSSLTransportFactory.TSSLTransportParameters)params);
                    SSLServerSocket sslServerSocket = (SSLServerSocket)sslServer.getServerSocket();
                    String[] suites = SSLFactory.filterCipherSuites(sslServerSocket.getSupportedCipherSuites(), clientEnc.cipher_suites);
                    sslServerSocket.setEnabledCipherSuites(suites);
                    serverTransport = new TCustomServerSocket(sslServerSocket, args.keepAlive, args.sendBufferSize, args.recvBufferSize);
                } else {
                    serverTransport = new TCustomServerSocket(addr, args.keepAlive, args.sendBufferSize, args.recvBufferSize, args.listenBacklog);
                }
            }
            catch (TTransportException e) {
                throw new RuntimeException(String.format("Unable to create thrift socket to %s:%s", addr.getAddress(), addr.getPort()), e);
            }
            TThreadPoolServer.Args serverArgs = (TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverTransport).minWorkerThreads(DatabaseDescriptor.getRpcMinThreads().intValue()).maxWorkerThreads(DatabaseDescriptor.getRpcMaxThreads().intValue()).inputTransportFactory(args.inTransportFactory)).outputTransportFactory(args.outTransportFactory)).inputProtocolFactory(args.tProtocolFactory)).outputProtocolFactory(args.tProtocolFactory)).processor(args.processor);
            ThreadPoolExecutor executorService = new ThreadPoolExecutor(serverArgs.minWorkerThreads, serverArgs.maxWorkerThreads, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new NamedThreadFactory("Thrift"));
            return new CustomTThreadPoolServer(serverArgs, executorService);
        }
    }

    private class WorkerProcess
    implements Runnable {
        private TTransport client_;

        private WorkerProcess(TTransport client) {
            this.client_ = client;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

