/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.cassandraunit.shaded.com.google.common.collect.ImmutableSet;
import org.cassandraunit.shaded.com.google.common.collect.Sets;

public class DirectorySizeCalculator
extends SimpleFileVisitor<Path> {
    protected final AtomicLong size = new AtomicLong(0L);
    protected Set<String> visited = Sets.newHashSet();
    protected Set<String> alive = Sets.newHashSet();
    protected final File path;

    public DirectorySizeCalculator(File path) {
        this.path = path;
        this.rebuildFileList();
    }

    public DirectorySizeCalculator(List<File> files) {
        this.path = null;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (File file : files) {
            builder.add(file.getName());
        }
        this.alive = builder.build();
    }

    public boolean isAcceptable(Path file) {
        return true;
    }

    public void rebuildFileList() {
        assert (this.path != null);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (File file : this.path.listFiles()) {
            builder.add(file.getName());
        }
        this.size.set(0L);
        this.alive = builder.build();
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (this.isAcceptable(file)) {
            this.size.addAndGet(attrs.size());
            this.visited.add(file.toFile().getName());
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    public long getAllocatedSize() {
        return this.size.get();
    }
}

