/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="rebuild", description="Rebuild data by streaming from other nodes (similarly to bootstrap)")
public class Rebuild
extends NodeTool.NodeToolCmd {
    @Arguments(usage="<src-dc-name>", description="Name of DC from which to select sources for streaming. By default, pick any DC")
    private String sourceDataCenterName = null;
    @Option(title="specific_keyspace", name={"-ks", "--keyspace"}, description="Use -ks to rebuild specific keyspace.")
    private String keyspace = null;
    @Option(title="specific_tokens", name={"-ts", "--tokens"}, description="Use -ts to rebuild specific token ranges, in the format of \"(start_token_1,end_token_1],(start_token_2,end_token_2],...(start_token_n,end_token_n]\".")
    private String tokens = null;

    @Override
    public void execute(NodeProbe probe) {
        if (this.keyspace == null && this.tokens != null) {
            throw new IllegalArgumentException("Cannot specify tokens without keyspace.");
        }
        probe.rebuild(this.sourceDataCenterName, this.keyspace, this.tokens);
    }
}

