/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import java.util.Map;
import org.apache.cassandra.schema.ReplicationParams;
import org.cassandraunit.shaded.com.google.common.base.MoreObjects;
import org.cassandraunit.shaded.com.google.common.base.Objects;

public final class KeyspaceParams {
    public static final boolean DEFAULT_DURABLE_WRITES = true;
    public final boolean durableWrites;
    public final ReplicationParams replication;

    public KeyspaceParams(boolean durableWrites, ReplicationParams replication) {
        this.durableWrites = durableWrites;
        this.replication = replication;
    }

    public static KeyspaceParams create(boolean durableWrites, Map<String, String> replication) {
        return new KeyspaceParams(durableWrites, ReplicationParams.fromMap(replication));
    }

    public static KeyspaceParams local() {
        return new KeyspaceParams(true, ReplicationParams.local());
    }

    public static KeyspaceParams simple(int replicationFactor) {
        return new KeyspaceParams(true, ReplicationParams.simple(replicationFactor));
    }

    public static KeyspaceParams simpleTransient(int replicationFactor) {
        return new KeyspaceParams(false, ReplicationParams.simple(replicationFactor));
    }

    public static KeyspaceParams nts(Object ... args) {
        return new KeyspaceParams(true, ReplicationParams.nts(args));
    }

    public void validate(String name) {
        this.replication.validate(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyspaceParams)) {
            return false;
        }
        KeyspaceParams p = (KeyspaceParams)o;
        return this.durableWrites == p.durableWrites && this.replication.equals(p.replication);
    }

    public int hashCode() {
        return Objects.hashCode(this.durableWrites, this.replication);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add(Option.DURABLE_WRITES.toString(), this.durableWrites).add(Option.REPLICATION.toString(), this.replication).toString();
    }

    public static enum Option {
        DURABLE_WRITES,
        REPLICATION;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

