/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import java.net.InetAddress;
import org.apache.cassandra.exceptions.RepairException;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.TreeResponse;
import org.apache.cassandra.repair.messages.ValidationRequest;
import org.apache.cassandra.utils.MerkleTrees;
import org.cassandraunit.shaded.com.google.common.util.concurrent.AbstractFuture;

public class ValidationTask
extends AbstractFuture<TreeResponse>
implements Runnable {
    private final RepairJobDesc desc;
    private final InetAddress endpoint;
    private final int gcBefore;

    public ValidationTask(RepairJobDesc desc, InetAddress endpoint, int gcBefore) {
        this.desc = desc;
        this.endpoint = endpoint;
        this.gcBefore = gcBefore;
    }

    @Override
    public void run() {
        ValidationRequest request = new ValidationRequest(this.desc, this.gcBefore);
        MessagingService.instance().sendOneWay(request.createMessage(), this.endpoint);
    }

    public void treesReceived(MerkleTrees trees) {
        if (trees == null) {
            this.setException(new RepairException(this.desc, "Validation failed in " + this.endpoint));
        } else {
            this.set(new TreeResponse(this.endpoint, trees));
        }
    }
}

