/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.File;
import java.io.IOException;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.util.BufferManagingRebufferer;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.DataIntegrityMetadata;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.Rebufferer;
import org.apache.cassandra.io.util.SimpleChunkReader;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.ChecksumType;

public class ChecksummedRandomAccessReader {

    public static final class Builder
    extends RandomAccessReader.Builder {
        private final DataIntegrityMetadata.ChecksumValidator validator;

        public Builder(File file, File crcFile) throws IOException {
            super(new ChannelProxy(file));
            this.validator = new DataIntegrityMetadata.ChecksumValidator(ChecksumType.CRC32, RandomAccessReader.open(crcFile), file.getPath());
        }

        @Override
        protected Rebufferer createRebufferer() {
            return new ChecksummedRebufferer(this.channel, this.validator);
        }

        @Override
        public RandomAccessReader build() {
            return this.buildWithChannel();
        }
    }

    static class ChecksummedRebufferer
    extends BufferManagingRebufferer {
        private final DataIntegrityMetadata.ChecksumValidator validator;

        public ChecksummedRebufferer(ChannelProxy channel, DataIntegrityMetadata.ChecksumValidator validator) {
            super(new SimpleChunkReader(channel, channel.size(), BufferType.ON_HEAP, validator.chunkSize));
            this.validator = validator;
        }

        @Override
        public Rebufferer.BufferHolder rebuffer(long desiredPosition) {
            if (desiredPosition != this.offset + (long)this.buffer.position()) {
                this.validator.seek(desiredPosition);
            }
            this.offset = this.alignedPosition(desiredPosition);
            this.source.readChunk(this.offset, this.buffer);
            try {
                this.validator.validate(ByteBufferUtil.getArray(this.buffer), 0, this.buffer.remaining());
            }
            catch (IOException e) {
                throw new CorruptFileException(e, this.channel().filePath());
            }
            return this;
        }

        @Override
        public void close() {
            try {
                this.source.close();
            }
            finally {
                this.validator.close();
            }
        }

        @Override
        long alignedPosition(long desiredPosition) {
            return desiredPosition / (long)this.buffer.capacity() * (long)this.buffer.capacity();
        }
    }

    public static class CorruptFileException
    extends RuntimeException {
        public final String filePath;

        public CorruptFileException(Exception cause, String filePath) {
            super(cause);
            this.filePath = filePath;
        }
    }
}

