/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.view;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.ReadQuery;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.commitlog.CommitLogPosition;
import org.apache.cassandra.db.filter.AbstractClusteringIndexFilter;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.ClusteringIndexSliceFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.view.View;
import org.apache.cassandra.db.view.ViewUpdateGenerator;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.btree.BTreeSet;
import org.cassandraunit.shaded.com.google.common.collect.Iterables;
import org.cassandraunit.shaded.com.google.common.collect.Iterators;
import org.cassandraunit.shaded.com.google.common.collect.PeekingIterator;

public class TableViews
extends AbstractCollection<View> {
    private final CFMetaData baseTableMetadata;
    private final List<View> views = new CopyOnWriteArrayList<View>();

    public TableViews(CFMetaData baseTableMetadata) {
        this.baseTableMetadata = baseTableMetadata;
    }

    @Override
    public int size() {
        return this.views.size();
    }

    @Override
    public Iterator<View> iterator() {
        return this.views.iterator();
    }

    public boolean contains(String viewName) {
        return Iterables.any(this.views, view -> view.name.equals(viewName));
    }

    @Override
    public boolean add(View view) {
        assert (!this.contains(view.name));
        return this.views.add(view);
    }

    public Iterable<ColumnFamilyStore> allViewsCfs() {
        Keyspace keyspace = Keyspace.open(this.baseTableMetadata.ksName);
        return Iterables.transform(this.views, view -> keyspace.getColumnFamilyStore(view.getDefinition().viewName));
    }

    public void forceBlockingFlush() {
        for (ColumnFamilyStore viewCfs : this.allViewsCfs()) {
            viewCfs.forceBlockingFlush();
        }
    }

    public void dumpMemtables() {
        for (ColumnFamilyStore viewCfs : this.allViewsCfs()) {
            viewCfs.dumpMemtable();
        }
    }

    public void truncateBlocking(CommitLogPosition replayAfter, long truncatedAt) {
        for (ColumnFamilyStore viewCfs : this.allViewsCfs()) {
            viewCfs.discardSSTables(truncatedAt);
            SystemKeyspace.saveTruncationRecord(viewCfs, truncatedAt, replayAfter);
        }
    }

    public void removeByName(String viewName) {
        this.views.removeIf(v -> v.name.equals(viewName));
    }

    public void pushViewReplicaUpdates(PartitionUpdate update, boolean writeCommitLog, AtomicLong baseComplete) {
        Collection<Mutation> mutations;
        assert (update.metadata().cfId.equals(this.baseTableMetadata.cfId));
        Collection<View> views = this.updatedViews(update);
        if (views.isEmpty()) {
            return;
        }
        int nowInSec = FBUtilities.nowInSeconds();
        SinglePartitionReadCommand command = this.readExistingRowsCommand(update, views, nowInSec);
        if (command == null) {
            return;
        }
        ColumnFamilyStore cfs = Keyspace.openAndGetStore(update.metadata());
        long start = System.nanoTime();
        try (ReadExecutionController orderGroup = command.executionController();
             UnfilteredRowIterator existings = UnfilteredPartitionIterators.getOnlyElement(command.executeLocally(orderGroup), command);
             UnfilteredRowIterator updates = update.unfilteredIterator();){
            mutations = this.generateViewUpdates(views, updates, existings, nowInSec);
        }
        Keyspace.openAndGetStore((CFMetaData)update.metadata()).metric.viewReadTime.update(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        if (!mutations.isEmpty()) {
            StorageProxy.mutateMV(update.partitionKey().getKey(), mutations, writeCommitLog, baseComplete);
        }
    }

    public Collection<Mutation> generateViewUpdates(Collection<View> views, UnfilteredRowIterator updates, UnfilteredRowIterator existings, int nowInSec) {
        Unfiltered existing;
        assert (updates.metadata().cfId.equals(this.baseTableMetadata.cfId));
        ArrayList<ViewUpdateGenerator> generators = new ArrayList<ViewUpdateGenerator>(views.size());
        for (View view : views) {
            generators.add(new ViewUpdateGenerator(view, updates.partitionKey(), nowInSec));
        }
        DeletionTracker existingsDeletion = new DeletionTracker(existings.partitionLevelDeletion());
        DeletionTracker updatesDeletion = new DeletionTracker(updates.partitionLevelDeletion());
        PeekingIterator<Unfiltered> existingsIter = Iterators.peekingIterator(existings);
        PeekingIterator<Unfiltered> updatesIter = Iterators.peekingIterator(updates);
        while (existingsIter.hasNext() && updatesIter.hasNext()) {
            Row existingRow;
            Row updateRow;
            existing = existingsIter.peek();
            Unfiltered update = updatesIter.peek();
            int cmp = this.baseTableMetadata.comparator.compare(update, existing);
            if (cmp < 0) {
                if (update.isRangeTombstoneMarker()) {
                    updatesDeletion.update(updatesIter.next());
                    continue;
                }
                updateRow = ((Row)updatesIter.next()).withRowDeletion(updatesDeletion.currentDeletion());
                existingRow = TableViews.emptyRow(updateRow.clustering(), existingsDeletion.currentDeletion());
            } else if (cmp > 0) {
                if (existing.isRangeTombstoneMarker()) {
                    existingsDeletion.update(existingsIter.next());
                    continue;
                }
                existingRow = ((Row)existingsIter.next()).withRowDeletion(existingsDeletion.currentDeletion());
                updateRow = TableViews.emptyRow(existingRow.clustering(), updatesDeletion.currentDeletion());
                if (updateRow == null) {
                    continue;
                }
            } else {
                if (update.isRangeTombstoneMarker()) {
                    assert (existing.isRangeTombstoneMarker());
                    updatesDeletion.update(updatesIter.next());
                    existingsDeletion.update(existingsIter.next());
                    continue;
                }
                assert (!existing.isRangeTombstoneMarker());
                existingRow = ((Row)existingsIter.next()).withRowDeletion(existingsDeletion.currentDeletion());
                updateRow = ((Row)updatesIter.next()).withRowDeletion(updatesDeletion.currentDeletion());
            }
            TableViews.addToViewUpdateGenerators(existingRow, updateRow, generators, nowInSec);
        }
        if (!updatesDeletion.currentDeletion().isLive()) {
            while (existingsIter.hasNext()) {
                existing = existingsIter.next();
                if (existing.isRangeTombstoneMarker()) continue;
                Row existingRow = (Row)existing;
                TableViews.addToViewUpdateGenerators(existingRow, TableViews.emptyRow(existingRow.clustering(), updatesDeletion.currentDeletion()), generators, nowInSec);
            }
        }
        while (updatesIter.hasNext()) {
            Unfiltered update = updatesIter.next();
            if (update.isRangeTombstoneMarker()) continue;
            Row updateRow = (Row)update;
            TableViews.addToViewUpdateGenerators(TableViews.emptyRow(updateRow.clustering(), DeletionTime.LIVE), updateRow, generators, nowInSec);
        }
        return this.buildMutations(this.baseTableMetadata, generators);
    }

    public Collection<View> updatedViews(PartitionUpdate updates) {
        ArrayList<View> matchingViews = new ArrayList<View>(this.views.size());
        for (View view : this.views) {
            ReadQuery selectQuery = view.getReadQuery();
            if (!selectQuery.selectsKey(updates.partitionKey())) continue;
            matchingViews.add(view);
        }
        return matchingViews;
    }

    private SinglePartitionReadCommand readExistingRowsCommand(PartitionUpdate updates, Collection<View> views, int nowInSec) {
        BTreeSet<Clusterable> bTreeSet;
        Slices.Builder sliceBuilder = null;
        DeletionInfo deletionInfo = updates.deletionInfo();
        CFMetaData metadata = updates.metadata();
        DecoratedKey key = updates.partitionKey();
        if (!deletionInfo.isLive()) {
            sliceBuilder = new Slices.Builder(metadata.comparator);
            if (!deletionInfo.getPartitionDeletion().isLive()) {
                for (View view : views) {
                    sliceBuilder.addAll(view.getSelectStatement().clusteringIndexFilterAsSlices());
                }
            } else {
                assert (deletionInfo.hasRanges());
                Iterator<RangeTombstone> iter = deletionInfo.rangeIterator(false);
                while (iter.hasNext()) {
                    sliceBuilder.add(iter.next().deletedSlice());
                }
            }
        }
        BTreeSet.Builder<Clusterable> namesBuilder = sliceBuilder == null ? BTreeSet.builder(metadata.comparator) : null;
        for (Row row : updates) {
            if (!this.affectsAnyViews(key, row, views)) continue;
            if (namesBuilder == null) {
                sliceBuilder.add(Slice.make(row.clustering()));
                continue;
            }
            namesBuilder.add(row.clustering());
        }
        BTreeSet<Clusterable> bTreeSet2 = bTreeSet = namesBuilder == null ? null : namesBuilder.build();
        if (bTreeSet != null && bTreeSet.isEmpty()) {
            return null;
        }
        AbstractClusteringIndexFilter clusteringFilter = bTreeSet == null ? new ClusteringIndexSliceFilter(sliceBuilder.build(), false) : new ClusteringIndexNamesFilter(bTreeSet, false);
        ColumnFilter queriedColumns = views.size() == 1 ? Iterables.getOnlyElement(views).getSelectStatement().queriedColumns() : ColumnFilter.all(metadata);
        RowFilter rowFilter = RowFilter.NONE;
        return SinglePartitionReadCommand.create(metadata, nowInSec, queriedColumns, rowFilter, DataLimits.NONE, key, clusteringFilter);
    }

    private boolean affectsAnyViews(DecoratedKey partitionKey, Row update, Collection<View> views) {
        for (View view : views) {
            if (!view.mayBeAffectedBy(partitionKey, update)) continue;
            return true;
        }
        return false;
    }

    private static void addToViewUpdateGenerators(Row existingBaseRow, Row updateBaseRow, Collection<ViewUpdateGenerator> generators, int nowInSec) {
        assert (!updateBaseRow.isEmpty());
        Row mergedBaseRow = existingBaseRow == null ? updateBaseRow : Rows.merge(existingBaseRow, updateBaseRow, nowInSec);
        for (ViewUpdateGenerator generator : generators) {
            generator.addBaseTableUpdate(existingBaseRow, mergedBaseRow);
        }
    }

    private static Row emptyRow(Clustering clustering, DeletionTime deletion) {
        return deletion.isLive() ? null : BTreeRow.emptyDeletedRow(clustering, Row.Deletion.regular(deletion));
    }

    private Collection<Mutation> buildMutations(CFMetaData baseTableMetadata, List<ViewUpdateGenerator> generators) {
        if (generators.size() == 1) {
            Collection<PartitionUpdate> updates = generators.get(0).generateViewUpdates();
            ArrayList<Mutation> mutations = new ArrayList<Mutation>(updates.size());
            for (PartitionUpdate update : updates) {
                mutations.add(new Mutation(update));
            }
            return mutations;
        }
        HashMap<DecoratedKey, Mutation> mutations = new HashMap<DecoratedKey, Mutation>();
        for (ViewUpdateGenerator generator : generators) {
            for (PartitionUpdate update : generator.generateViewUpdates()) {
                DecoratedKey key = update.partitionKey();
                Mutation mutation = (Mutation)mutations.get(key);
                if (mutation == null) {
                    mutation = new Mutation(baseTableMetadata.ksName, key);
                    mutations.put(key, mutation);
                }
                mutation.add(update);
            }
        }
        return mutations.values();
    }

    private static class DeletionTracker {
        private final DeletionTime partitionDeletion;
        private DeletionTime deletion;

        public DeletionTracker(DeletionTime partitionDeletion) {
            this.partitionDeletion = partitionDeletion;
        }

        public void update(Unfiltered marker) {
            assert (marker instanceof RangeTombstoneMarker);
            RangeTombstoneMarker rtm = (RangeTombstoneMarker)marker;
            this.deletion = rtm.isOpen(false) ? rtm.openDeletionTime(false) : null;
        }

        public DeletionTime currentDeletion() {
            return this.deletion == null ? this.partitionDeletion : this.deletion;
        }
    }
}

