/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.serializers.BytesSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.cassandraunit.shaded.com.google.common.collect.ImmutableMap;

public class ColumnToCollectionType
extends AbstractType<ByteBuffer> {
    private static final Map<Map<ByteBuffer, CollectionType>, ColumnToCollectionType> instances = new HashMap<Map<ByteBuffer, CollectionType>, ColumnToCollectionType>();
    public final Map<ByteBuffer, CollectionType> defined;

    public static ColumnToCollectionType getInstance(TypeParser parser) throws SyntaxException, ConfigurationException {
        return ColumnToCollectionType.getInstance(parser.getCollectionsParameters());
    }

    public static synchronized ColumnToCollectionType getInstance(Map<ByteBuffer, CollectionType> defined) {
        assert (defined != null);
        ColumnToCollectionType t = instances.get(defined);
        if (t == null) {
            t = new ColumnToCollectionType(defined);
            instances.put(defined, t);
        }
        return t;
    }

    private ColumnToCollectionType(Map<ByteBuffer, CollectionType> defined) {
        super(AbstractType.ComparisonType.CUSTOM);
        this.defined = ImmutableMap.copyOf(defined);
    }

    @Override
    public int compareCustom(ByteBuffer o1, ByteBuffer o2) {
        throw new UnsupportedOperationException("ColumnToCollectionType should only be used in composite types, never alone");
    }

    @Override
    public int compareCollectionMembers(ByteBuffer o1, ByteBuffer o2, ByteBuffer collectionName) {
        CollectionType t = this.defined.get(collectionName);
        if (t == null) {
            throw new RuntimeException(ByteBufferUtil.bytesToHex(collectionName) + " is not defined as a collection");
        }
        return t.nameComparator().compare(o1, o2);
    }

    @Override
    public String getString(ByteBuffer bytes) {
        return BytesType.instance.getString(bytes);
    }

    @Override
    public ByteBuffer fromString(String source) {
        try {
            return ByteBufferUtil.hexToBytes(source);
        }
        catch (NumberFormatException e) {
            throw new MarshalException(String.format("cannot parse '%s' as hex bytes", source), e);
        }
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toJSONString(ByteBuffer buffer, int protocolVersion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void validate(ByteBuffer bytes) {
        throw new UnsupportedOperationException("ColumnToCollectionType should only be used in composite types, never alone");
    }

    @Override
    public TypeSerializer<ByteBuffer> getSerializer() {
        return BytesSerializer.instance;
    }

    @Override
    public void validateCollectionMember(ByteBuffer bytes, ByteBuffer collectionName) throws MarshalException {
        CollectionType t = this.defined.get(collectionName);
        if (t == null) {
            throw new MarshalException(ByteBufferUtil.bytesToHex(collectionName) + " is not defined as a collection");
        }
        t.nameComparator().validate(bytes);
    }

    @Override
    public boolean isCompatibleWith(AbstractType<?> previous) {
        if (!(previous instanceof ColumnToCollectionType)) {
            return false;
        }
        ColumnToCollectionType prev = (ColumnToCollectionType)previous;
        for (Map.Entry<ByteBuffer, CollectionType> entry : prev.defined.entrySet()) {
            CollectionType newType = this.defined.get(entry.getKey());
            if (newType != null && newType.isCompatibleWith(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + TypeParser.stringifyCollectionsParameters(this.defined);
    }
}

