/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.selection.Selectable;
import org.cassandraunit.shaded.com.google.common.base.Function;
import org.cassandraunit.shaded.com.google.common.collect.Lists;

public class RawSelector {
    public final Selectable.Raw selectable;
    public final ColumnIdentifier alias;

    public RawSelector(Selectable.Raw selectable, ColumnIdentifier alias) {
        this.selectable = selectable;
        this.alias = alias;
    }

    public static List<Selectable> toSelectables(List<RawSelector> raws, final CFMetaData cfm) {
        return Lists.transform(raws, new Function<RawSelector, Selectable>(){

            @Override
            public Selectable apply(RawSelector raw) {
                return raw.selectable.prepare(cfm);
            }
        });
    }

    public boolean processesSelection() {
        return this.selectable.processesSelection();
    }
}

