/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.AssignmentTestable;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.Terms;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.serializers.MapSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;

public abstract class Maps {
    private Maps() {
    }

    public static ColumnSpecification keySpecOf(ColumnSpecification column) {
        return new ColumnSpecification(column.ksName, column.cfName, new ColumnIdentifier("key(" + column.name + ")", true), ((MapType)column.type).getKeysType());
    }

    public static ColumnSpecification valueSpecOf(ColumnSpecification column) {
        return new ColumnSpecification(column.ksName, column.cfName, new ColumnIdentifier("value(" + column.name + ")", true), ((MapType)column.type).getValuesType());
    }

    public static class DiscarderByKey
    extends Operation {
        public DiscarderByKey(ColumnDefinition column, Term k) {
            super(column, k);
        }

        @Override
        public void execute(DecoratedKey partitionKey, UpdateParameters params) throws InvalidRequestException {
            assert (this.column.type.isMultiCell()) : "Attempted to delete a single key in a frozen map";
            Term.Terminal key = this.t.bind(params.options);
            if (key == null) {
                throw new InvalidRequestException("Invalid null map key");
            }
            if (key == Constants.UNSET_VALUE) {
                throw new InvalidRequestException("Invalid unset map key");
            }
            params.addTombstone(this.column, CellPath.create(key.get(params.options.getProtocolVersion())));
        }
    }

    public static class Putter
    extends Operation {
        public Putter(ColumnDefinition column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(DecoratedKey partitionKey, UpdateParameters params) throws InvalidRequestException {
            assert (this.column.type.isMultiCell()) : "Attempted to add items to a frozen map";
            Term.Terminal value = this.t.bind(params.options);
            if (value != Constants.UNSET_VALUE) {
                Putter.doPut(value, this.column, params);
            }
        }

        static void doPut(Term.Terminal value, ColumnDefinition column, UpdateParameters params) throws InvalidRequestException {
            if (column.type.isMultiCell()) {
                if (value == null) {
                    return;
                }
                Map<ByteBuffer, ByteBuffer> elements = ((Value)value).map;
                for (Map.Entry<ByteBuffer, ByteBuffer> entry : elements.entrySet()) {
                    params.addCell(column, CellPath.create(entry.getKey()), entry.getValue());
                }
            } else if (value == null) {
                params.addTombstone(column);
            } else {
                params.addCell(column, value.get(4));
            }
        }
    }

    public static class SetterByKey
    extends Operation {
        private final Term k;

        public SetterByKey(ColumnDefinition column, Term k, Term t) {
            super(column, t);
            this.k = k;
        }

        @Override
        public void collectMarkerSpecification(VariableSpecifications boundNames) {
            super.collectMarkerSpecification(boundNames);
            this.k.collectMarkerSpecification(boundNames);
        }

        @Override
        public void execute(DecoratedKey partitionKey, UpdateParameters params) throws InvalidRequestException {
            assert (this.column.type.isMultiCell()) : "Attempted to set a value for a single key on a frozen map";
            ByteBuffer key = this.k.bindAndGet(params.options);
            ByteBuffer value = this.t.bindAndGet(params.options);
            if (key == null) {
                throw new InvalidRequestException("Invalid null map key");
            }
            if (key == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                throw new InvalidRequestException("Invalid unset map key");
            }
            CellPath path = CellPath.create(key);
            if (value == null) {
                params.addTombstone(this.column, path);
            } else if (value != ByteBufferUtil.UNSET_BYTE_BUFFER) {
                params.addCell(this.column, path, value);
            }
        }
    }

    public static class Setter
    extends Operation {
        public Setter(ColumnDefinition column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(DecoratedKey partitionKey, UpdateParameters params) throws InvalidRequestException {
            Term.Terminal value = this.t.bind(params.options);
            if (value == Constants.UNSET_VALUE) {
                return;
            }
            if (this.column.type.isMultiCell()) {
                params.setComplexDeletionTimeForOverwrite(this.column);
            }
            Putter.doPut(value, this.column, params);
        }
    }

    public static class Marker
    extends AbstractMarker {
        protected Marker(int bindIndex, ColumnSpecification receiver) {
            super(bindIndex, receiver);
            assert (receiver.type instanceof MapType);
        }

        @Override
        public Term.Terminal bind(QueryOptions options) throws InvalidRequestException {
            ByteBuffer value = options.getValues().get(this.bindIndex);
            if (value == null) {
                return null;
            }
            if (value == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                return Constants.UNSET_VALUE;
            }
            return Value.fromSerialized(value, (MapType)this.receiver.type, options.getProtocolVersion());
        }
    }

    public static class DelayedValue
    extends Term.NonTerminal {
        private final Comparator<ByteBuffer> comparator;
        private final Map<Term, Term> elements;

        public DelayedValue(Comparator<ByteBuffer> comparator, Map<Term, Term> elements) {
            this.comparator = comparator;
            this.elements = elements;
        }

        @Override
        public boolean containsBindMarker() {
            return false;
        }

        @Override
        public void collectMarkerSpecification(VariableSpecifications boundNames) {
        }

        @Override
        public Term.Terminal bind(QueryOptions options) throws InvalidRequestException {
            TreeMap<ByteBuffer, ByteBuffer> buffers = new TreeMap<ByteBuffer, ByteBuffer>(this.comparator);
            for (Map.Entry<Term, Term> entry : this.elements.entrySet()) {
                ByteBuffer keyBytes = entry.getKey().bindAndGet(options);
                if (keyBytes == null) {
                    throw new InvalidRequestException("null is not supported inside collections");
                }
                if (keyBytes == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                    throw new InvalidRequestException("unset value is not supported for map keys");
                }
                ByteBuffer valueBytes = entry.getValue().bindAndGet(options);
                if (valueBytes == null) {
                    throw new InvalidRequestException("null is not supported inside collections");
                }
                if (valueBytes == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                    return Constants.UNSET_VALUE;
                }
                buffers.put(keyBytes, valueBytes);
            }
            return new Value(buffers);
        }

        @Override
        public void addFunctionsTo(List<Function> functions) {
            Terms.addFunctions(this.elements.keySet(), functions);
            Terms.addFunctions(this.elements.values(), functions);
        }
    }

    public static class Value
    extends Term.Terminal {
        public final Map<ByteBuffer, ByteBuffer> map;

        public Value(Map<ByteBuffer, ByteBuffer> map) {
            this.map = map;
        }

        public static Value fromSerialized(ByteBuffer value, MapType type, int version) throws InvalidRequestException {
            try {
                Object m = ((MapSerializer)type.getSerializer()).deserializeForNativeProtocol(value, version);
                LinkedHashMap<ByteBuffer, ByteBuffer> map = new LinkedHashMap<ByteBuffer, ByteBuffer>(m.size());
                for (Map.Entry entry : m.entrySet()) {
                    map.put(type.getKeysType().decompose(entry.getKey()), type.getValuesType().decompose(entry.getValue()));
                }
                return new Value(map);
            }
            catch (MarshalException e) {
                throw new InvalidRequestException(e.getMessage());
            }
        }

        @Override
        public ByteBuffer get(int protocolVersion) {
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(2 * this.map.size());
            for (Map.Entry<ByteBuffer, ByteBuffer> entry : this.map.entrySet()) {
                buffers.add(entry.getKey());
                buffers.add(entry.getValue());
            }
            return CollectionSerializer.pack(buffers, this.map.size(), protocolVersion);
        }

        public boolean equals(MapType mt, Value v) {
            if (this.map.size() != v.map.size()) {
                return false;
            }
            Iterator<Map.Entry<ByteBuffer, ByteBuffer>> thisIter = this.map.entrySet().iterator();
            Iterator<Map.Entry<ByteBuffer, ByteBuffer>> thatIter = v.map.entrySet().iterator();
            while (thisIter.hasNext()) {
                Map.Entry<ByteBuffer, ByteBuffer> thisEntry = thisIter.next();
                Map.Entry<ByteBuffer, ByteBuffer> thatEntry = thatIter.next();
                if (mt.getKeysType().compare(thisEntry.getKey(), thatEntry.getKey()) == 0 && mt.getValuesType().compare(thisEntry.getValue(), thatEntry.getValue()) == 0) continue;
                return false;
            }
            return true;
        }
    }

    public static class Literal
    extends Term.Raw {
        public final List<Pair<Term.Raw, Term.Raw>> entries;

        public Literal(List<Pair<Term.Raw, Term.Raw>> entries) {
            this.entries = entries;
        }

        @Override
        public Term prepare(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            this.validateAssignableTo(keyspace, receiver);
            ColumnSpecification keySpec = Maps.keySpecOf(receiver);
            ColumnSpecification valueSpec = Maps.valueSpecOf(receiver);
            HashMap<Term, Term> values = new HashMap<Term, Term>(this.entries.size());
            boolean allTerminal = true;
            for (Pair<Term.Raw, Term.Raw> entry : this.entries) {
                Term k = ((Term.Raw)entry.left).prepare(keyspace, keySpec);
                Term v = ((Term.Raw)entry.right).prepare(keyspace, valueSpec);
                if (k.containsBindMarker() || v.containsBindMarker()) {
                    throw new InvalidRequestException(String.format("Invalid map literal for %s: bind variables are not supported inside collection literals", receiver.name));
                }
                if (k instanceof Term.NonTerminal || v instanceof Term.NonTerminal) {
                    allTerminal = false;
                }
                values.put(k, v);
            }
            DelayedValue value = new DelayedValue(((MapType)receiver.type).getKeysType(), values);
            return allTerminal ? value.bind(QueryOptions.DEFAULT) : value;
        }

        private void validateAssignableTo(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            if (!(receiver.type instanceof MapType)) {
                throw new InvalidRequestException(String.format("Invalid map literal for %s of type %s", receiver.name, receiver.type.asCQL3Type()));
            }
            ColumnSpecification keySpec = Maps.keySpecOf(receiver);
            ColumnSpecification valueSpec = Maps.valueSpecOf(receiver);
            for (Pair<Term.Raw, Term.Raw> entry : this.entries) {
                if (!((Term.Raw)entry.left).testAssignment(keyspace, keySpec).isAssignable()) {
                    throw new InvalidRequestException(String.format("Invalid map literal for %s: key %s is not of type %s", receiver.name, entry.left, keySpec.type.asCQL3Type()));
                }
                if (((Term.Raw)entry.right).testAssignment(keyspace, valueSpec).isAssignable()) continue;
                throw new InvalidRequestException(String.format("Invalid map literal for %s: value %s is not of type %s", receiver.name, entry.right, valueSpec.type.asCQL3Type()));
            }
        }

        @Override
        public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
            if (!(receiver.type instanceof MapType)) {
                return AssignmentTestable.TestResult.NOT_ASSIGNABLE;
            }
            if (this.entries.isEmpty()) {
                return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
            }
            ColumnSpecification keySpec = Maps.keySpecOf(receiver);
            ColumnSpecification valueSpec = Maps.valueSpecOf(receiver);
            AssignmentTestable.TestResult res = AssignmentTestable.TestResult.EXACT_MATCH;
            for (Pair<Term.Raw, Term.Raw> entry : this.entries) {
                AssignmentTestable.TestResult t1 = ((Term.Raw)entry.left).testAssignment(keyspace, keySpec);
                AssignmentTestable.TestResult t2 = ((Term.Raw)entry.right).testAssignment(keyspace, valueSpec);
                if (t1 == AssignmentTestable.TestResult.NOT_ASSIGNABLE || t2 == AssignmentTestable.TestResult.NOT_ASSIGNABLE) {
                    return AssignmentTestable.TestResult.NOT_ASSIGNABLE;
                }
                if (t1 == AssignmentTestable.TestResult.EXACT_MATCH && t2 == AssignmentTestable.TestResult.EXACT_MATCH) continue;
                res = AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
            }
            return res;
        }

        @Override
        public AbstractType<?> getExactTypeIfKnown(String keyspace) {
            AbstractType<?> keyType = null;
            AbstractType<?> valueType = null;
            for (Pair<Term.Raw, Term.Raw> entry : this.entries) {
                if (keyType == null) {
                    keyType = ((Term.Raw)entry.left).getExactTypeIfKnown(keyspace);
                }
                if (valueType == null) {
                    valueType = ((Term.Raw)entry.right).getExactTypeIfKnown(keyspace);
                }
                if (keyType == null || valueType == null) continue;
                return MapType.getInstance(keyType, valueType, false);
            }
            return null;
        }

        @Override
        public String getText() {
            return this.entries.stream().map(entry -> String.format("%s: %s", ((Term.Raw)entry.left).getText(), ((Term.Raw)entry.right).getText())).collect(Collectors.joining(", ", "{", "}"));
        }
    }
}

