/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.spin.impl.xml.dom.query;

import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.camunda.spin.SpinList;
import org.camunda.spin.impl.SpinListImpl;
import org.camunda.spin.impl.xml.dom.DomXmlAttributeIterable;
import org.camunda.spin.impl.xml.dom.DomXmlElement;
import org.camunda.spin.impl.xml.dom.DomXmlElementIterable;
import org.camunda.spin.impl.xml.dom.DomXmlLogger;
import org.camunda.spin.impl.xml.dom.format.DomXmlDataFormat;
import org.camunda.spin.xml.SpinXPathQuery;
import org.camunda.spin.xml.SpinXmlAttribute;
import org.camunda.spin.xml.SpinXmlElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DomXPathQuery
extends SpinXPathQuery {
    private static final DomXmlLogger LOG = DomXmlLogger.XML_DOM_LOGGER;
    protected final DomXmlElement domElement;
    protected final XPathExpression query;
    private final DomXmlDataFormat dataFormat;

    public DomXPathQuery(DomXmlElement domElement, XPathExpression query, DomXmlDataFormat dataFormat) {
        this.domElement = domElement;
        this.query = query;
        this.dataFormat = dataFormat;
    }

    public SpinXmlElement element() {
        try {
            Element element = (Element)this.query.evaluate(this.domElement.unwrap(), XPathConstants.NODE);
            return this.dataFormat.createElementWrapper(element);
        }
        catch (XPathExpressionException e) {
            throw LOG.unableToEvaluateXPathExpressionOnElement(this.domElement, e);
        }
        catch (ClassCastException e) {
            throw LOG.unableToCastXPathResultTo(Element.class, e);
        }
    }

    public SpinList<SpinXmlElement> elementList() {
        try {
            NodeList nodeList = (NodeList)this.query.evaluate(this.domElement.unwrap(), XPathConstants.NODESET);
            return new SpinListImpl((Iterable)new DomXmlElementIterable(nodeList, this.dataFormat));
        }
        catch (XPathExpressionException e) {
            throw LOG.unableToEvaluateXPathExpressionOnElement(this.domElement, e);
        }
        catch (ClassCastException e) {
            throw LOG.unableToCastXPathResultTo(NodeList.class, e);
        }
    }

    public SpinXmlAttribute attribute() {
        try {
            Attr attribute = (Attr)this.query.evaluate(this.domElement.unwrap(), XPathConstants.NODE);
            return this.dataFormat.createAttributeWrapper(attribute);
        }
        catch (XPathExpressionException e) {
            throw LOG.unableToEvaluateXPathExpressionOnElement(this.domElement, e);
        }
        catch (ClassCastException e) {
            throw LOG.unableToCastXPathResultTo(Attr.class, e);
        }
    }

    public SpinList<SpinXmlAttribute> attributeList() {
        try {
            NodeList nodeList = (NodeList)this.query.evaluate(this.domElement.unwrap(), XPathConstants.NODESET);
            return new SpinListImpl((Iterable)new DomXmlAttributeIterable(nodeList, this.dataFormat));
        }
        catch (XPathExpressionException e) {
            throw LOG.unableToEvaluateXPathExpressionOnElement(this.domElement, e);
        }
        catch (ClassCastException e) {
            throw LOG.unableToCastXPathResultTo(NodeList.class, e);
        }
    }

    public String string() {
        try {
            return (String)this.query.evaluate(this.domElement.unwrap(), XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            throw LOG.unableToEvaluateXPathExpressionOnElement(this.domElement, e);
        }
        catch (ClassCastException e) {
            throw LOG.unableToCastXPathResultTo(String.class, e);
        }
    }

    public Double number() {
        try {
            return (Double)this.query.evaluate(this.domElement.unwrap(), XPathConstants.NUMBER);
        }
        catch (XPathExpressionException e) {
            throw LOG.unableToEvaluateXPathExpressionOnElement(this.domElement, e);
        }
        catch (ClassCastException e) {
            throw LOG.unableToCastXPathResultTo(Double.class, e);
        }
    }

    public Boolean bool() {
        try {
            return (Boolean)this.query.evaluate(this.domElement.unwrap(), XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException e) {
            throw LOG.unableToEvaluateXPathExpressionOnElement(this.domElement, e);
        }
        catch (ClassCastException e) {
            throw LOG.unableToCastXPathResultTo(Boolean.class, e);
        }
    }
}

