/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.spin.impl.xml.dom;

import java.util.NoSuchElementException;
import javax.xml.xpath.XPathExpressionException;
import org.camunda.commons.logging.BaseLogger;
import org.camunda.spin.impl.logging.SpinLogger;
import org.camunda.spin.xml.SpinXPathException;
import org.camunda.spin.xml.SpinXmlAttribute;
import org.camunda.spin.xml.SpinXmlAttributeException;
import org.camunda.spin.xml.SpinXmlDataFormatException;
import org.camunda.spin.xml.SpinXmlElement;
import org.camunda.spin.xml.SpinXmlElementException;
import org.camunda.spin.xml.SpinXmlElementImplementationException;
import org.w3c.dom.Node;

public class DomXmlLogger
extends SpinLogger {
    public static final String PROJECT_CODE = "SPIN/DOM-XML";
    public static final DomXmlLogger XML_DOM_LOGGER = (DomXmlLogger)BaseLogger.createLogger(DomXmlLogger.class, (String)"SPIN/DOM-XML", (String)"org.camunda.spin.xml", (String)"01");

    public void usingDocumentBuilderFactory(String name) {
        this.logDebug("001", "Using document builder factory '{}'", new Object[]{name});
    }

    public void createdDocumentBuilder() {
        this.logDebug("002", "Successfully created new document builder", new Object[0]);
    }

    public void documentBuilderFactoryConfiguration(String property, String value) {
        this.logDebug("003", "DocumentBuilderFactory configuration '{}' '{}'", new Object[]{property, value});
    }

    public void parsingInput() {
        this.logDebug("004", "Parsing input into DOM document.", new Object[0]);
    }

    public SpinXmlDataFormatException unableToCreateParser(Exception cause) {
        return new SpinXmlDataFormatException(this.exceptionMessage("005", "Unable to create DocumentBuilder", new Object[0]), (Throwable)cause);
    }

    public SpinXmlAttributeException unableToFindAttributeWithNamespaceAndName(String namespace, String attributeName) {
        return new SpinXmlAttributeException(this.exceptionMessage("006", "Unable to find attribute with namespace '{}' and name '{}'", new Object[]{namespace, attributeName}));
    }

    public SpinXmlElementException unableToFindChildElementWithNamespaceAndName(String namespace, String elementName) {
        return new SpinXmlElementException(this.exceptionMessage("007", "Unable to find child element with namespace '{}' and name '{}'", new Object[]{namespace, elementName}));
    }

    public SpinXmlElementException moreThanOneChildElementFoundForNamespaceAndName(String namespace, String elementName) {
        return new SpinXmlElementException(this.exceptionMessage("008", "More than one child element was found for namespace '{}' and name '{}'", new Object[]{namespace, elementName}));
    }

    public SpinXmlDataFormatException unableToParseInput(Exception e) {
        return new SpinXmlDataFormatException(this.exceptionMessage("009", "Unable to parse input into DOM document", new Object[0]), (Throwable)e);
    }

    public SpinXmlAttributeException unableToSetAttributeValueToNull(String namespace, String attributeName) {
        return new SpinXmlAttributeException(this.exceptionMessage("010", "Unable to set value of the attribute '{}:{}' to 'null'", new Object[]{namespace, attributeName}));
    }

    public SpinXmlElementException unableToAdoptElement(SpinXmlElement elementToAdopt) {
        return new SpinXmlElementException(this.exceptionMessage("011", "Unable to adopt element '{}:{}'", new Object[]{elementToAdopt.namespace(), elementToAdopt.name()}));
    }

    public UnsupportedOperationException methodNotSupportedByClass(String methodName, Class<?> implementationClass) {
        return new UnsupportedOperationException(this.exceptionMessage("012", "The method '{}' is not implemented by class '{}'", new Object[]{methodName, implementationClass.getName()}));
    }

    public NoSuchElementException iteratorHasNoMoreElements(Class<?> iteratorClass) {
        return new NoSuchElementException(this.exceptionMessage("013", "The iterator '{}' has no more elements", new Object[]{iteratorClass.getName()}));
    }

    public SpinXmlElementException elementHasNoParent(SpinXmlElement element) {
        return new SpinXmlElementException(this.exceptionMessage("014", "The element '{}:{}' has no parent element.", new Object[]{element.namespace(), element.name()}));
    }

    public SpinXmlElementImplementationException unableToReplaceElementInImplementation(SpinXmlElement existingElement, SpinXmlElement newElement, Exception cause) {
        return new SpinXmlElementImplementationException(this.exceptionMessage("015", "Unable to replace the existing element '{}:{}' by the new element '{}:{}' in the underlying implementation", new Object[]{existingElement.namespace(), existingElement.name(), newElement.namespace(), newElement.name()}), (Throwable)cause);
    }

    public SpinXmlElementImplementationException unableToSetAttributeInImplementation(SpinXmlElement element, String namespace, String attributeName, String value, Exception cause) {
        return new SpinXmlElementImplementationException(this.exceptionMessage("016", "Unable to set attribute '{}:{}' to value '{}' on element '{}:{}' in the underlying implementation", new Object[]{namespace, attributeName, value, element.namespace(), element.name()}), (Throwable)cause);
    }

    public SpinXmlElementImplementationException unableToAppendElementInImplementation(SpinXmlElement element, SpinXmlElement childElement, Exception cause) {
        return new SpinXmlElementImplementationException(this.exceptionMessage("017", "Unable to append new child element '{}:{}' to element '{}:{}' in the underlying implementation", new Object[]{childElement.namespace(), childElement.name(), element.namespace(), element.name()}), (Throwable)cause);
    }

    public SpinXmlElementImplementationException unableToInsertElementInImplementation(SpinXmlElement element, SpinXmlElement childElement, Exception cause) {
        return new SpinXmlElementImplementationException(this.exceptionMessage("018", "Unable to insert new child element '{}:{}' to element '{}:{}' in the underlying implementation", new Object[]{childElement.namespace(), childElement.name(), element.namespace(), element.name()}), (Throwable)cause);
    }

    public SpinXmlElementImplementationException unableToRemoveChildInImplementation(SpinXmlElement element, SpinXmlElement childElement, Exception cause) {
        return new SpinXmlElementImplementationException(this.exceptionMessage("019", "Unable to remove child element '{}:{}' from element '{}:{}' in the underlying implementation", new Object[]{childElement.namespace(), childElement.name(), element.namespace(), element.name()}), (Throwable)cause);
    }

    public SpinXmlAttributeException unableToWriteAttribute(SpinXmlAttribute attribute, Exception cause) {
        return new SpinXmlAttributeException(this.exceptionMessage("020", "Unable to write attribute '{}:{}'", new Object[]{attribute.namespace(), attribute.name()}), (Throwable)cause);
    }

    public SpinXmlElementException unableToCreateTransformer(Exception cause) {
        return new SpinXmlElementException(this.exceptionMessage("021", "Unable to create a transformer to write element", new Object[0]), (Throwable)cause);
    }

    public SpinXmlElementException unableToTransformElement(Node element, Exception cause) {
        return new SpinXmlElementException(this.exceptionMessage("022", "Unable to transform element '{}:{}'", new Object[]{element.getNamespaceURI(), element.getNodeName()}), (Throwable)cause);
    }

    public SpinXPathException unableToCompileXPathQuery(String expression, XPathExpressionException cause) {
        return new SpinXPathException(this.exceptionMessage("023", "Unable to compile xPath query '{}'", new Object[]{expression}), (Throwable)cause);
    }

    public SpinXPathException unableToEvaluateXPathExpressionOnElement(SpinXmlElement element, Exception cause) {
        return new SpinXPathException(this.exceptionMessage("024", "Unable to evaluate XPath expression on element '{}:{}'", new Object[]{element.namespace(), element.name()}), (Throwable)cause);
    }

    public SpinXPathException unableToCastXPathResultTo(Class<?> castClass, Exception cause) {
        return new SpinXPathException(this.exceptionMessage("025", "Unable to cast XPath expression to class '{}'", new Object[]{castClass.getName()}), (Throwable)cause);
    }

    public SpinXmlDataFormatException unableToDetectCanonicalType(Object parameter) {
        return new SpinXmlDataFormatException(this.exceptionMessage("026", "Cannot detect canonical data type for parameter '{}'", new Object[]{parameter}));
    }

    public SpinXmlDataFormatException unableToMapInput(Object parameter, Throwable cause) {
        return new SpinXmlDataFormatException(this.exceptionMessage("027", "Unable to map object '{}' to xml element", new Object[]{parameter.toString()}), cause);
    }

    public SpinXmlDataFormatException unableToDeserialize(Object node, String canonicalClassName, Throwable cause) {
        return new SpinXmlDataFormatException(this.exceptionMessage("028", "Cannot deserialize '{}...' to java class '{}'", new Object[]{node.toString(), canonicalClassName}), cause);
    }

    public SpinXmlDataFormatException unableToCreateMarshaller(Throwable cause) {
        return new SpinXmlDataFormatException(this.exceptionMessage("029", "Cannot create marshaller", new Object[0]), cause);
    }

    public SpinXmlDataFormatException unableToCreateContext(Throwable cause) {
        return new SpinXmlDataFormatException(this.exceptionMessage("030", "Cannot create context", new Object[0]), cause);
    }

    public SpinXmlDataFormatException unableToCreateUnmarshaller(Throwable cause) {
        return new SpinXmlDataFormatException(this.exceptionMessage("031", "Cannot create unmarshaller", new Object[0]), cause);
    }

    public SpinXmlDataFormatException unableToSetEventHandler(String className, Throwable cause) {
        return new SpinXmlDataFormatException(this.exceptionMessage("032", "Cannot set event handler to '{}'", new Object[]{className}), cause);
    }

    public SpinXmlDataFormatException unableToSetProperty(String propertyName, String className, Throwable cause) {
        return new SpinXmlDataFormatException(this.exceptionMessage("033", "Cannot set property '{}' to '{}'", new Object[]{propertyName, className}), cause);
    }
}

