/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.spin.impl.xml.dom.format;

import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.camunda.commons.utils.EnsureUtil;
import org.camunda.spin.impl.xml.dom.DomXmlLogger;
import org.camunda.spin.impl.xml.dom.format.DomXmlDataFormat;
import org.camunda.spin.impl.xml.dom.format.spi.JaxBContextProvider;
import org.camunda.spin.spi.DataFormatMapper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DomXmlDataFormatMapper
implements DataFormatMapper {
    protected DomXmlDataFormat format;
    private static final DomXmlLogger LOG = DomXmlLogger.XML_DOM_LOGGER;

    public DomXmlDataFormatMapper(DomXmlDataFormat format) {
        this.format = format;
    }

    public boolean canMap(Object parameter) {
        if (parameter == null) {
            return false;
        }
        return parameter.getClass().getAnnotation(XmlRootElement.class) != null;
    }

    public String getCanonicalTypeName(Object object) {
        return object.getClass().getName();
    }

    public Object mapJavaToInternal(Object parameter) {
        EnsureUtil.ensureNotNull((String)"Parameter", (Object)parameter);
        try {
            Marshaller marshaller = this.getMarshaller(parameter.getClass());
            DOMResult domResult = new DOMResult();
            marshaller.marshal(parameter, (Result)domResult);
            Node node = domResult.getNode();
            return ((Document)node).getDocumentElement();
        }
        catch (JAXBException e) {
            throw LOG.unableToMapInput(parameter, e);
        }
    }

    public <T> T mapInternalToJava(Object parameter, Class<T> javaClass) {
        EnsureUtil.ensureNotNull((String)"Parameter", (Object)parameter);
        EnsureUtil.ensureNotNull((String)"Type", javaClass);
        Node xmlNode = (Node)parameter;
        try {
            Unmarshaller unmarshaller = this.getUnmarshaller(javaClass);
            return (T)unmarshaller.unmarshal((Source)new DOMSource(xmlNode));
        }
        catch (JAXBException e) {
            throw LOG.unableToDeserialize(parameter, javaClass.getCanonicalName(), e);
        }
    }

    public <T> T mapInternalToJava(Object parameter, String classIdentifier) {
        EnsureUtil.ensureNotNull((String)"Parameter", (Object)parameter);
        EnsureUtil.ensureNotNull((String)"classIdentifier", (Object)classIdentifier);
        try {
            Class<?> javaClass = Class.forName(classIdentifier);
            return (T)this.mapInternalToJava(parameter, javaClass);
        }
        catch (ClassNotFoundException e) {
            throw LOG.unableToDeserialize(parameter, classIdentifier, e);
        }
    }

    protected Marshaller getMarshaller(Class<?> parameter) throws JAXBException {
        JaxBContextProvider jaxBContextProvider = this.format.getJaxBContextProvider();
        return jaxBContextProvider.createMarshaller(parameter);
    }

    protected Unmarshaller getUnmarshaller(Class<?> parameter) throws JAXBException {
        JaxBContextProvider jaxBContextProvider = this.format.getJaxBContextProvider();
        return jaxBContextProvider.createUnmarshaller(parameter);
    }
}

