/*
 * Decompiled with CFR 0.152.
 */
package spinjar.com.jayway.jsonpath.internal.filter;

import java.util.Collection;
import java.util.LinkedList;
import spinjar.com.jayway.jsonpath.Configuration;
import spinjar.com.jayway.jsonpath.Filter;
import spinjar.com.jayway.jsonpath.Option;
import spinjar.com.jayway.jsonpath.PathNotFoundException;
import spinjar.com.jayway.jsonpath.internal.PathToken;
import spinjar.com.jayway.jsonpath.internal.filter.PathTokenFilter;
import spinjar.com.jayway.jsonpath.spi.JsonProvider;

public class FieldFilter
extends PathTokenFilter {
    private final String[] split;
    private final PathToken pathToken;

    public FieldFilter(PathToken pathToken) {
        super(pathToken.getFragment());
        this.pathToken = pathToken;
        this.split = this.condition.split("','");
    }

    @Override
    public Object filter(Object obj, Configuration configuration, LinkedList<Filter> filters, boolean inArrayContext) {
        JsonProvider jsonProvider = configuration.getProvider();
        if (jsonProvider.isArray(obj)) {
            if (!inArrayContext) {
                throw new PathNotFoundException("Path '" + this.condition + "' is being applied to an array. Arrays can not have attributes.");
            }
            Iterable result = jsonProvider.createArray();
            for (Object current : jsonProvider.toIterable(obj)) {
                if (!jsonProvider.isMap(current)) continue;
                Collection<String> keys = jsonProvider.getPropertyKeys(current);
                if (this.split.length == 1) {
                    if (!keys.contains(this.condition)) continue;
                    Object o = jsonProvider.getProperty(current, this.condition);
                    boolean isArr = jsonProvider.isArray(o);
                    boolean isEnd = this.pathToken.isEndToken();
                    if (isArr && !isEnd) {
                        for (Object item : jsonProvider.toIterable(o)) {
                            jsonProvider.setProperty(result, jsonProvider.length(result), item);
                        }
                        continue;
                    }
                    jsonProvider.setProperty(result, jsonProvider.length(result), jsonProvider.getProperty(current, this.condition));
                    continue;
                }
                Object res = jsonProvider.createMap();
                for (String prop : this.split) {
                    if (!keys.contains(prop)) continue;
                    jsonProvider.setProperty(res, prop, jsonProvider.getProperty(current, prop));
                }
                jsonProvider.setProperty(result, jsonProvider.length(result), res);
            }
            return result;
        }
        if (jsonProvider.isMap(obj)) {
            Collection<String> keys = jsonProvider.getPropertyKeys(obj);
            if (!keys.contains(this.condition) && this.split.length == 1) {
                if (configuration.getOptions().contains((Object)Option.THROW_ON_MISSING_PROPERTY)) {
                    throw new PathNotFoundException("Path '" + this.condition + "' not found in the current context:\n" + jsonProvider.toJson(obj));
                }
                if (this.pathToken.isEndToken()) {
                    return null;
                }
                throw new PathNotFoundException("Path '" + this.condition + "' not found in the current context:\n" + jsonProvider.toJson(obj));
            }
            if (this.split.length == 1) {
                return jsonProvider.getProperty(obj, this.condition);
            }
            Object res = jsonProvider.createMap();
            for (String prop : this.split) {
                if (!keys.contains(prop)) continue;
                jsonProvider.setProperty(res, prop, jsonProvider.getProperty(obj, prop));
            }
            return res;
        }
        throw new PathNotFoundException("Failed to access property: '" + this.condition + "' on object " + obj);
    }

    @Override
    public Object filter(Object obj, Configuration configuration) {
        JsonProvider jsonProvider = configuration.getProvider();
        if (jsonProvider.isArray(obj)) {
            return obj;
        }
        return jsonProvider.getProperty(obj, this.condition);
    }

    @Override
    public Object getRef(Object obj, Configuration configuration) {
        return this.filter(obj, configuration);
    }

    @Override
    public boolean isArrayFilter() {
        return false;
    }
}

