/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.spin.impl.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import org.camunda.commons.utils.IoUtil;
import org.camunda.spin.impl.logging.SpinCoreLogger;
import org.camunda.spin.impl.logging.SpinLogger;

public class SpinIoUtil
extends IoUtil {
    public static final Charset ENCODING_CHARSET = Charset.forName("UTF-8");
    private static final SpinCoreLogger LOG = SpinLogger.CORE_LOGGER;

    public static InputStream convertOutputStreamToInputStream(OutputStream outputStream) {
        byte[] data = ((ByteArrayOutputStream)outputStream).toByteArray();
        return new ByteArrayInputStream(data);
    }

    public static String getStringFromInputStream(InputStream inputStream) throws IOException {
        return SpinIoUtil.getStringFromInputStream(inputStream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringFromInputStream(InputStream inputStream, boolean trim) throws IOException {
        BufferedReader bufferedReader = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = bufferedReader.readLine()) != null) {
                if (trim) {
                    stringBuilder.append(line.trim());
                    continue;
                }
                stringBuilder.append(line).append("\n");
            }
        }
        catch (Throwable throwable) {
            SpinIoUtil.closeSilently(bufferedReader);
            throw throwable;
        }
        SpinIoUtil.closeSilently((Closeable)bufferedReader);
        return stringBuilder.toString();
    }

    public static String getStringFromReader(Reader reader) throws IOException {
        return SpinIoUtil.getStringFromReader(reader, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringFromReader(Reader reader, boolean trim) throws IOException {
        BufferedReader bufferedReader = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            bufferedReader = new BufferedReader(reader);
            while ((line = bufferedReader.readLine()) != null) {
                if (trim) {
                    stringBuilder.append(line.trim());
                    continue;
                }
                stringBuilder.append(line).append("\n");
            }
        }
        catch (Throwable throwable) {
            SpinIoUtil.closeSilently(bufferedReader);
            throw throwable;
        }
        SpinIoUtil.closeSilently((Closeable)bufferedReader);
        return stringBuilder.toString();
    }

    public static Reader classpathResourceAsReader(String fileName) {
        try {
            File classpathFile = SpinIoUtil.getClasspathFile((String)fileName);
            return new FileReader(classpathFile);
        }
        catch (FileNotFoundException e) {
            throw LOG.fileNotFoundException(fileName, e);
        }
    }

    public static Reader stringAsReader(String string) {
        return new StringReader(string);
    }
}

