/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.spin.impl.json.jackson.format;

import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Map;
import spinjar.com.fasterxml.jackson.databind.JavaType;
import spinjar.com.fasterxml.jackson.databind.type.TypeFactory;

public class TypeHelper {
    static boolean bindingsArePresent(Class<?> erasedType, int expectedTypeParametersCount) {
        if (erasedType == null) {
            return false;
        }
        TypeVariable<Class<?>>[] typeParameters = erasedType.getTypeParameters();
        if (typeParameters.length == 0) {
            return false;
        }
        if (typeParameters.length != expectedTypeParametersCount) {
            throw new IllegalArgumentException("Cannot create TypeBindings for class " + erasedType.getName() + " with " + expectedTypeParametersCount + " type parameter: class expects " + typeParameters.length + " type parameters.");
        }
        return true;
    }

    static JavaType constructType(Object value) {
        Map.Entry firstEntry;
        TypeFactory typeFactory = TypeFactory.defaultInstance();
        if (value instanceof Collection && !((Collection)value).isEmpty()) {
            Object firstElement = ((Collection)value).iterator().next();
            if (TypeHelper.bindingsArePresent(value.getClass(), 1)) {
                JavaType elementType = TypeHelper.constructType(firstElement);
                return typeFactory.constructCollectionType(TypeHelper.guessCollectionType(value), elementType);
            }
        } else if (value instanceof Map && !((Map)value).isEmpty() && TypeHelper.bindingsArePresent((firstEntry = ((Map)value).entrySet().iterator().next()).getClass(), 2)) {
            JavaType keyType = TypeHelper.constructType(firstEntry.getKey());
            JavaType valueType = TypeHelper.constructType(firstEntry.getValue());
            return typeFactory.constructMapType(Map.class, keyType, valueType);
        }
        return typeFactory.constructType(value.getClass());
    }

    static Class<? extends Collection> guessCollectionType(Object value) {
        if (value instanceof Collection) {
            return value.getClass();
        }
        throw new IllegalArgumentException("Could not detect class for " + value + " of type " + value.getClass().getName());
    }
}

