/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.spin.spi;

import java.io.IOException;
import java.io.Reader;
import java.util.regex.Pattern;
import org.camunda.spin.impl.logging.SpinCoreLogger;
import org.camunda.spin.spi.DataFormatReader;

public abstract class TextBasedDataFormatReader
implements DataFormatReader {
    private static final SpinCoreLogger LOG = SpinCoreLogger.CORE_LOGGER;

    @Override
    public boolean canRead(Reader input, int readLimit) {
        char[] firstCharacters = new char[readLimit];
        try {
            input.read(firstCharacters, 0, readLimit);
        }
        catch (IOException e) {
            throw LOG.unableToReadFromReader(e);
        }
        Pattern pattern = this.getInputDetectionPattern();
        return pattern.matcher(new String(firstCharacters)).find();
    }

    protected abstract Pattern getInputDetectionPattern();
}

