/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.spin.impl.test;

import java.io.Closeable;
import java.io.File;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.camunda.spin.impl.logging.SpinLogger;
import org.camunda.spin.impl.test.Script;
import org.camunda.spin.impl.test.ScriptEngineRule;
import org.camunda.spin.impl.test.ScriptVariable;
import org.camunda.spin.impl.test.SpinTestLogger;
import org.camunda.spin.impl.util.SpinIoUtil;
import org.camunda.spin.scripting.SpinScriptEnv;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ScriptRule
implements TestRule {
    private static final SpinTestLogger LOG = SpinLogger.TEST_LOGGER;
    private String script;
    private String scriptPath;
    private ScriptEngine scriptEngine;
    protected final Map<String, Object> variables = new HashMap<String, Object>();

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ScriptRule.this.loadScript(description);
                base.evaluate();
                ScriptRule.this.tearDownVariables();
            }
        };
    }

    protected void tearDownVariables() {
        for (Object variable : this.variables.values()) {
            if (variable == null || !Reader.class.isAssignableFrom(variable.getClass())) continue;
            Reader reader = (Reader)variable;
            SpinIoUtil.closeSilently((Closeable)reader);
        }
    }

    private void loadScript(Description description) {
        boolean execute;
        this.scriptEngine = this.getScriptEngine(description);
        if (this.scriptEngine == null) {
            return;
        }
        this.script = this.getScript(description);
        this.collectScriptVariables(description);
        if (this.scriptEngine.getFactory().getLanguageName().equalsIgnoreCase("ruby")) {
            this.variables.put("org.jruby.embed.clear.variables", true);
        }
        if (execute = this.isExecuteScript(description)) {
            this.executeScript();
        }
    }

    private ScriptEngine getScriptEngine(Description description) {
        try {
            ScriptEngineRule scriptEngineRule = (ScriptEngineRule)description.getTestClass().getField("scriptEngine").get(null);
            return scriptEngineRule.getScriptEngine();
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    private String getScript(Description description) {
        Script scriptAnnotation = (Script)description.getAnnotation(Script.class);
        if (scriptAnnotation == null) {
            return null;
        }
        String scriptBasename = this.getScriptBasename(scriptAnnotation, description);
        this.scriptPath = this.getScriptPath(scriptBasename, description);
        File file = SpinIoUtil.getClasspathFile((String)this.scriptPath, (ClassLoader)description.getTestClass().getClassLoader());
        return SpinIoUtil.fileAsString((File)file);
    }

    private void collectScriptVariables(Description description) {
        ScriptVariable scriptVariable = (ScriptVariable)description.getAnnotation(ScriptVariable.class);
        this.collectScriptVariable(scriptVariable, description);
        Script script = (Script)description.getAnnotation(Script.class);
        if (script != null) {
            for (ScriptVariable variable : script.variables()) {
                this.collectScriptVariable(variable, description);
            }
        }
    }

    private void collectScriptVariable(ScriptVariable scriptVariable, Description description) {
        if (scriptVariable == null) {
            return;
        }
        String name = scriptVariable.name();
        String value = scriptVariable.value();
        String filename = scriptVariable.file();
        boolean isNull = scriptVariable.isNull();
        if (isNull) {
            this.variables.put(name, null);
            LOG.scriptVariableFound(name, "isNull", null);
        } else if (!filename.isEmpty()) {
            Reader fileAsReader = SpinIoUtil.classpathResourceAsReader(filename);
            this.variables.put(name, fileAsReader);
            LOG.scriptVariableFound(name, "reader", filename);
        } else {
            this.variables.put(name, value);
            LOG.scriptVariableFound(name, "string", value);
        }
    }

    private boolean isExecuteScript(Description description) {
        Script annotation = (Script)description.getAnnotation(Script.class);
        return annotation != null && annotation.execute();
    }

    private void executeScript() {
        if (this.scriptEngine != null) {
            try {
                String environment = SpinScriptEnv.get(this.scriptEngine.getFactory().getLanguageName());
                SimpleBindings bindings = new SimpleBindings(this.variables);
                LOG.executeScriptWithScriptEngine(this.scriptPath, this.scriptEngine.getFactory().getEngineName());
                this.scriptEngine.eval(environment, (Bindings)bindings);
                this.scriptEngine.eval(this.script, (Bindings)bindings);
            }
            catch (ScriptException e) {
                throw LOG.scriptExecutionError(this.scriptPath, e);
            }
        }
    }

    public ScriptRule execute(Map<String, Object> scriptVariables) {
        this.variables.putAll(scriptVariables);
        this.executeScript();
        return this;
    }

    public ScriptRule execute() {
        this.executeScript();
        return this;
    }

    private String getScriptBasename(Script scriptAnnotation, Description description) {
        String scriptBasename = scriptAnnotation.value();
        if (scriptBasename.isEmpty()) {
            scriptBasename = scriptAnnotation.name();
        }
        if (scriptBasename.isEmpty()) {
            scriptBasename = description.getTestClass().getSimpleName() + "." + description.getMethodName();
        }
        return scriptBasename;
    }

    private String getPackageDirectoryPath(Description description) {
        String packageName = description.getTestClass().getPackage().getName();
        return this.replaceDotsWithPathSeparators(packageName) + File.separator;
    }

    private String replaceDotsWithPathSeparators(String path) {
        return path.replace(".", File.separator);
    }

    private String getScriptPath(String scriptBasename, Description description) {
        return this.getPackageDirectoryPath(description) + scriptBasename + this.getScriptExtension();
    }

    private String getScriptExtension() {
        String languageName = this.scriptEngine.getFactory().getLanguageName();
        String extension = SpinScriptEnv.getExtension(languageName);
        if (extension == null) {
            LOG.noScriptExtensionFoundForScriptLanguage(languageName);
            return "";
        }
        return "." + extension;
    }

    public <T> T getVariable(String name) {
        try {
            if (this.scriptEngine.getFactory().getLanguageName().equals("ECMAScript")) {
                return (T)this.getVariableJs(name);
            }
            return (T)this.variables.get(name);
        }
        catch (ClassCastException e) {
            throw LOG.cannotCastVariableError(name, e);
        }
    }

    private Object getVariableJs(String name) {
        Object variable = this.variables.get(name);
        if (variable == null && this.variables.containsKey("nashorn.global")) {
            variable = ((Map)this.variables.get("nashorn.global")).get(name);
        }
        return variable;
    }

    public ScriptRule setVariable(String name, Object value) {
        this.variables.put(name, value);
        return this;
    }
}

