/*
 * Decompiled with CFR 0.152.
 */
package spinjar.com.jayway.jsonpath.internal;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import spinjar.com.jayway.jsonpath.InvalidPathException;
import spinjar.com.jayway.jsonpath.internal.PathToken;

public class PathTokenizer
implements Iterable<PathToken> {
    private static Pattern INVALID_PATH_PATTERN = Pattern.compile("[^\\?\\+=\\-\\*/!]\\(");
    private List<PathToken> pathTokens = new LinkedList<PathToken>();
    private char[] pathChars;
    private transient int index = 0;

    public PathTokenizer(String jsonPath) {
        if (INVALID_PATH_PATTERN.matcher(jsonPath).matches()) {
            throw new InvalidPathException("Invalid path: " + jsonPath);
        }
        if (!jsonPath.startsWith("$") && !jsonPath.startsWith("$[")) {
            jsonPath = "$." + jsonPath;
        }
        this.pathChars = jsonPath.toCharArray();
        List<String> tokens = this.splitPath();
        int len = tokens.size();
        int i = 0;
        for (String pathFragment : tokens) {
            this.pathTokens.add(new PathToken(pathFragment, i, i == len - 1));
            ++i;
        }
    }

    public List<String> getFragments() {
        LinkedList<String> fragments = new LinkedList<String>();
        for (PathToken pathToken : this.pathTokens) {
            fragments.add(pathToken.getFragment());
        }
        return fragments;
    }

    public int size() {
        return this.pathTokens.size();
    }

    public String getPath() {
        return new String(this.pathChars);
    }

    public LinkedList<PathToken> getPathTokens() {
        return new LinkedList<PathToken>(this.pathTokens);
    }

    @Override
    public Iterator<PathToken> iterator() {
        return this.pathTokens.iterator();
    }

    public PathToken removeLastPathToken() {
        PathToken lastPathToken = this.pathTokens.get(this.pathTokens.size() - 1);
        this.pathTokens.remove(this.pathTokens.size() - 1);
        return lastPathToken;
    }

    private boolean isEmpty() {
        return this.index == this.pathChars.length;
    }

    private char peek() {
        return this.pathChars[this.index];
    }

    private char poll() {
        char peek = this.peek();
        ++this.index;
        return peek;
    }

    public List<String> splitPath() {
        LinkedList<String> fragments = new LinkedList<String>();
        block5: while (!this.isEmpty()) {
            this.skip(' ');
            char current = this.peek();
            switch (current) {
                case '$': {
                    fragments.add(Character.toString(current));
                    this.poll();
                    continue block5;
                }
                case '.': {
                    this.poll();
                    if (this.isEmpty() || this.peek() != '.') continue block5;
                    this.poll();
                    fragments.add("..");
                    this.assertNotInvalidPeek('.');
                    continue block5;
                }
                case '[': {
                    fragments.add(this.extract(true, ']'));
                    continue block5;
                }
            }
            fragments.add(this.extract(false, '[', '.'));
        }
        return fragments;
    }

    private String extract(boolean includeSopChar, char ... stopChars) {
        StringBuilder sb = new StringBuilder();
        while (!this.isEmpty() && !this.isStopChar(this.peek(), stopChars)) {
            if (this.peek() == '(') {
                do {
                    sb.append(this.poll());
                } while (this.peek() != ')');
                sb.append(this.poll());
                continue;
            }
            char c = this.poll();
            if (this.isStopChar(c, stopChars)) {
                if (!includeSopChar) continue;
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        if (includeSopChar) {
            this.assertValidPeek(false, stopChars);
            sb.append(this.poll());
        } else {
            this.assertValidPeek(true, stopChars);
        }
        return this.clean(sb);
    }

    private String clean(StringBuilder sb) {
        String src = sb.toString();
        src = this.trim(src, "'");
        src = this.trim(src, ")");
        src = this.trim(src, "(");
        src = this.trimLeft(src, "?");
        if ((src = this.trimLeft(src, "@")).length() >= 5 && src.subSequence(0, 2).equals("['")) {
            src = src.substring(2);
            src = src.substring(0, src.length() - 2);
        }
        return src.trim();
    }

    private String trim(String src, String trim) {
        return this.trimLeft(this.trimRight(src, trim), trim);
    }

    private String trimRight(String src, String trim) {
        String scanFor = trim + " ";
        if (src.contains(scanFor)) {
            while (src.contains(scanFor)) {
                src = src.replace(scanFor, trim);
            }
        }
        return src;
    }

    private String trimLeft(String src, String trim) {
        String scanFor = " " + trim;
        if (src.contains(scanFor)) {
            while (src.contains(scanFor)) {
                src = src.replace(scanFor, trim);
            }
        }
        return src;
    }

    private boolean isStopChar(char c, char ... scanFor) {
        boolean found = false;
        for (char check : scanFor) {
            if (check != c) continue;
            found = true;
            break;
        }
        return found;
    }

    private void skip(char target) {
        if (this.isEmpty()) {
            return;
        }
        while (this.pathChars[this.index] == target) {
            this.poll();
        }
    }

    private void assertNotInvalidPeek(char ... invalidChars) {
        if (this.isEmpty()) {
            return;
        }
        char peek = this.peek();
        for (char check : invalidChars) {
            if (check != peek) continue;
            throw new InvalidPathException("Char: " + peek + " at current position is not valid!");
        }
    }

    private void assertValidPeek(boolean acceptEmpty, char ... validChars) {
        if (this.isEmpty() && acceptEmpty) {
            return;
        }
        if (this.isEmpty()) {
            throw new InvalidPathException("Path is incomplete");
        }
        boolean found = false;
        char peek = this.peek();
        for (char check : validChars) {
            if (check != peek) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new InvalidPathException("Path is invalid");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("---------------------------------------------------------------------------").append("\n");
        sb.append("PATH: ").append(this.getPath()).append("\n");
        sb.append(String.format("%-50s%-10s%-10s%-10s", "Fragment", "Root", "End", "Array")).append("\n");
        sb.append("---------------------------------------------------------------------------").append("\n");
        for (PathToken pathToken : this.pathTokens) {
            sb.append(String.format("%-50s%-10b%-10b%-10b", pathToken.getFragment(), pathToken.isRootToken(), pathToken.isEndToken(), pathToken.isArrayIndexToken())).append("\n");
        }
        return sb.toString();
    }
}

