/*
 * Decompiled with CFR 0.152.
 */
package spinjar.com.jayway.jsonpath;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import spinjar.com.jayway.jsonpath.Option;
import spinjar.com.jayway.jsonpath.internal.Utils;
import spinjar.com.jayway.jsonpath.spi.JsonProvider;
import spinjar.com.jayway.jsonpath.spi.JsonProviderFactory;

public class Configuration {
    private final JsonProvider provider;
    private final EnumSet<Option> options;

    private Configuration(JsonProvider provider, EnumSet<Option> options) {
        Utils.notNull(provider, "provider can not be null", new Object[0]);
        Utils.notNull(options, "options can not be null", new Object[0]);
        this.provider = provider;
        this.options = options;
    }

    public Configuration provider(JsonProvider provider) {
        return Configuration.builder().jsonProvider(provider).options(this.options).build();
    }

    public JsonProvider getProvider() {
        return this.provider;
    }

    public Configuration options(Option ... options) {
        return Configuration.builder().jsonProvider(this.provider).options(options).build();
    }

    public Set<Option> getOptions() {
        return Collections.unmodifiableSet(this.options);
    }

    public static Configuration defaultConfiguration() {
        return new Configuration(JsonProviderFactory.createProvider(), EnumSet.noneOf(Option.class));
    }

    public static ConfigurationBuilder builder() {
        return new ConfigurationBuilder();
    }

    public static class ConfigurationBuilder {
        private JsonProvider provider;
        private EnumSet<Option> options = EnumSet.noneOf(Option.class);

        public ConfigurationBuilder jsonProvider(JsonProvider provider) {
            this.provider = provider;
            return this;
        }

        public ConfigurationBuilder options(Option ... flags) {
            this.options.addAll(Arrays.asList(flags));
            return this;
        }

        public ConfigurationBuilder options(Set<Option> options) {
            this.options.addAll(options);
            return this;
        }

        public Configuration build() {
            if (this.provider == null) {
                this.provider = JsonProviderFactory.createProvider();
            }
            return new Configuration(this.provider, this.options);
        }
    }
}

