/*
 * Decompiled with CFR 0.152.
 */
package spinjar.com.fasterxml.jackson.databind;

import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import spinjar.com.fasterxml.jackson.annotation.ObjectIdGenerator;
import spinjar.com.fasterxml.jackson.core.JsonGenerator;
import spinjar.com.fasterxml.jackson.core.JsonProcessingException;
import spinjar.com.fasterxml.jackson.databind.AnnotationIntrospector;
import spinjar.com.fasterxml.jackson.databind.BeanProperty;
import spinjar.com.fasterxml.jackson.databind.DatabindContext;
import spinjar.com.fasterxml.jackson.databind.JavaType;
import spinjar.com.fasterxml.jackson.databind.JsonMappingException;
import spinjar.com.fasterxml.jackson.databind.JsonSerializer;
import spinjar.com.fasterxml.jackson.databind.SerializationConfig;
import spinjar.com.fasterxml.jackson.databind.SerializationFeature;
import spinjar.com.fasterxml.jackson.databind.cfg.ContextAttributes;
import spinjar.com.fasterxml.jackson.databind.introspect.Annotated;
import spinjar.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import spinjar.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import spinjar.com.fasterxml.jackson.databind.ser.FilterProvider;
import spinjar.com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import spinjar.com.fasterxml.jackson.databind.ser.SerializerCache;
import spinjar.com.fasterxml.jackson.databind.ser.SerializerFactory;
import spinjar.com.fasterxml.jackson.databind.ser.impl.FailingSerializer;
import spinjar.com.fasterxml.jackson.databind.ser.impl.ReadOnlyClassToSerializerMap;
import spinjar.com.fasterxml.jackson.databind.ser.impl.TypeWrappedSerializer;
import spinjar.com.fasterxml.jackson.databind.ser.impl.UnknownSerializer;
import spinjar.com.fasterxml.jackson.databind.ser.impl.WritableObjectId;
import spinjar.com.fasterxml.jackson.databind.ser.std.NullSerializer;
import spinjar.com.fasterxml.jackson.databind.type.TypeFactory;
import spinjar.com.fasterxml.jackson.databind.util.ClassUtil;
import spinjar.com.fasterxml.jackson.databind.util.RootNameLookup;

public abstract class SerializerProvider
extends DatabindContext {
    protected static final boolean CACHE_UNKNOWN_MAPPINGS = false;
    public static final JsonSerializer<Object> DEFAULT_NULL_KEY_SERIALIZER = new FailingSerializer("Null key for a Map not allowed in JSON (use a converting NullKeySerializer?)");
    protected static final JsonSerializer<Object> DEFAULT_UNKNOWN_SERIALIZER = new UnknownSerializer();
    protected final SerializationConfig _config;
    protected final Class<?> _serializationView;
    protected final SerializerFactory _serializerFactory;
    protected final SerializerCache _serializerCache;
    protected final RootNameLookup _rootNames;
    protected transient ContextAttributes _attributes;
    protected JsonSerializer<Object> _unknownTypeSerializer = DEFAULT_UNKNOWN_SERIALIZER;
    protected JsonSerializer<Object> _keySerializer;
    protected JsonSerializer<Object> _nullValueSerializer = NullSerializer.instance;
    protected JsonSerializer<Object> _nullKeySerializer = DEFAULT_NULL_KEY_SERIALIZER;
    protected final ReadOnlyClassToSerializerMap _knownSerializers;
    protected DateFormat _dateFormat;
    protected final boolean _stdNullValueSerializer;

    public SerializerProvider() {
        this._config = null;
        this._serializerFactory = null;
        this._serializerCache = new SerializerCache();
        this._knownSerializers = null;
        this._rootNames = new RootNameLookup();
        this._serializationView = null;
        this._attributes = null;
        this._stdNullValueSerializer = true;
    }

    protected SerializerProvider(SerializerProvider src, SerializationConfig config, SerializerFactory f) {
        if (config == null) {
            throw new NullPointerException();
        }
        this._serializerFactory = f;
        this._config = config;
        this._serializerCache = src._serializerCache;
        this._unknownTypeSerializer = src._unknownTypeSerializer;
        this._keySerializer = src._keySerializer;
        this._nullValueSerializer = src._nullValueSerializer;
        this._nullKeySerializer = src._nullKeySerializer;
        this._stdNullValueSerializer = this._nullValueSerializer == DEFAULT_NULL_KEY_SERIALIZER;
        this._rootNames = src._rootNames;
        this._knownSerializers = this._serializerCache.getReadOnlyLookupMap();
        this._serializationView = config.getActiveView();
        this._attributes = config.getAttributes();
    }

    protected SerializerProvider(SerializerProvider src) {
        this._config = null;
        this._serializationView = null;
        this._serializerFactory = null;
        this._knownSerializers = null;
        this._serializerCache = new SerializerCache();
        this._rootNames = new RootNameLookup();
        this._unknownTypeSerializer = src._unknownTypeSerializer;
        this._keySerializer = src._keySerializer;
        this._nullValueSerializer = src._nullValueSerializer;
        this._nullKeySerializer = src._nullKeySerializer;
        this._stdNullValueSerializer = src._stdNullValueSerializer;
    }

    public void setDefaultKeySerializer(JsonSerializer<Object> ks) {
        if (ks == null) {
            throw new IllegalArgumentException("Can not pass null JsonSerializer");
        }
        this._keySerializer = ks;
    }

    public void setNullValueSerializer(JsonSerializer<Object> nvs) {
        if (nvs == null) {
            throw new IllegalArgumentException("Can not pass null JsonSerializer");
        }
        this._nullValueSerializer = nvs;
    }

    public void setNullKeySerializer(JsonSerializer<Object> nks) {
        if (nks == null) {
            throw new IllegalArgumentException("Can not pass null JsonSerializer");
        }
        this._nullKeySerializer = nks;
    }

    public final SerializationConfig getConfig() {
        return this._config;
    }

    @Override
    public final AnnotationIntrospector getAnnotationIntrospector() {
        return this._config.getAnnotationIntrospector();
    }

    @Override
    public final TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    @Override
    public final Class<?> getActiveView() {
        return this._serializationView;
    }

    @Deprecated
    public final Class<?> getSerializationView() {
        return this._serializationView;
    }

    @Override
    public Object getAttribute(Object key) {
        return this._attributes.getAttribute(key);
    }

    @Override
    public SerializerProvider setAttribute(Object key, Object value) {
        this._attributes = this._attributes.withPerCallAttribute(key, value);
        return this;
    }

    public final boolean isEnabled(SerializationFeature feature) {
        return this._config.isEnabled(feature);
    }

    public final boolean hasSerializationFeatures(int featureMask) {
        return this._config.hasSerializationFeatures(featureMask);
    }

    public final FilterProvider getFilterProvider() {
        return this._config.getFilterProvider();
    }

    public Locale getLocale() {
        return this._config.getLocale();
    }

    public TimeZone getTimeZone() {
        return this._config.getTimeZone();
    }

    public abstract WritableObjectId findObjectId(Object var1, ObjectIdGenerator<?> var2);

    public JsonSerializer<Object> findValueSerializer(Class<?> valueType, BeanProperty property) throws JsonMappingException {
        JsonSerializer<Object> ser = this._knownSerializers.untypedValueSerializer(valueType);
        if (ser == null && (ser = this._serializerCache.untypedValueSerializer(valueType)) == null && (ser = this._serializerCache.untypedValueSerializer(this._config.constructType(valueType))) == null && (ser = this._createAndCacheUntypedSerializer(valueType)) == null) {
            ser = this.getUnknownTypeSerializer(valueType);
            return ser;
        }
        return this.handleSecondaryContextualization(ser, property);
    }

    public JsonSerializer<Object> findValueSerializer(JavaType valueType, BeanProperty property) throws JsonMappingException {
        JsonSerializer<Object> ser = this._knownSerializers.untypedValueSerializer(valueType);
        if (ser == null && (ser = this._serializerCache.untypedValueSerializer(valueType)) == null && (ser = this._createAndCacheUntypedSerializer(valueType)) == null) {
            ser = this.getUnknownTypeSerializer(valueType.getRawClass());
            return ser;
        }
        return this.handleSecondaryContextualization(ser, property);
    }

    public JsonSerializer<Object> findValueSerializer(Class<?> valueType) throws JsonMappingException {
        JsonSerializer<Object> ser = this._knownSerializers.untypedValueSerializer(valueType);
        if (ser == null && (ser = this._serializerCache.untypedValueSerializer(valueType)) == null && (ser = this._serializerCache.untypedValueSerializer(this._config.constructType(valueType))) == null && (ser = this._createAndCacheUntypedSerializer(valueType)) == null) {
            ser = this.getUnknownTypeSerializer(valueType);
        }
        return ser;
    }

    public JsonSerializer<Object> findValueSerializer(JavaType valueType) throws JsonMappingException {
        JsonSerializer<Object> ser = this._knownSerializers.untypedValueSerializer(valueType);
        if (ser == null && (ser = this._serializerCache.untypedValueSerializer(valueType)) == null && (ser = this._createAndCacheUntypedSerializer(valueType)) == null) {
            ser = this.getUnknownTypeSerializer(valueType.getRawClass());
        }
        return ser;
    }

    public JsonSerializer<Object> findPrimaryPropertySerializer(JavaType valueType, BeanProperty property) throws JsonMappingException {
        JsonSerializer<Object> ser = this._knownSerializers.untypedValueSerializer(valueType);
        if (ser == null && (ser = this._serializerCache.untypedValueSerializer(valueType)) == null && (ser = this._createAndCacheUntypedSerializer(valueType)) == null) {
            ser = this.getUnknownTypeSerializer(valueType.getRawClass());
            return ser;
        }
        return this.handlePrimaryContextualization(ser, property);
    }

    public JsonSerializer<Object> findPrimaryPropertySerializer(Class<?> valueType, BeanProperty property) throws JsonMappingException {
        JsonSerializer<Object> ser = this._knownSerializers.untypedValueSerializer(valueType);
        if (ser == null && (ser = this._serializerCache.untypedValueSerializer(valueType)) == null && (ser = this._serializerCache.untypedValueSerializer(this._config.constructType(valueType))) == null && (ser = this._createAndCacheUntypedSerializer(valueType)) == null) {
            ser = this.getUnknownTypeSerializer(valueType);
            return ser;
        }
        return this.handlePrimaryContextualization(ser, property);
    }

    public JsonSerializer<Object> findTypedValueSerializer(Class<?> valueType, boolean cache, BeanProperty property) throws JsonMappingException {
        JsonSerializer ser = this._knownSerializers.typedValueSerializer(valueType);
        if (ser != null) {
            return ser;
        }
        ser = this._serializerCache.typedValueSerializer(valueType);
        if (ser != null) {
            return ser;
        }
        ser = this.findValueSerializer(valueType, property);
        TypeSerializer typeSer = this._serializerFactory.createTypeSerializer(this._config, this._config.constructType(valueType));
        if (typeSer != null) {
            typeSer = typeSer.forProperty(property);
            ser = new TypeWrappedSerializer(typeSer, ser);
        }
        if (cache) {
            this._serializerCache.addTypedSerializer(valueType, ser);
        }
        return ser;
    }

    public JsonSerializer<Object> findTypedValueSerializer(JavaType valueType, boolean cache, BeanProperty property) throws JsonMappingException {
        JsonSerializer ser = this._knownSerializers.typedValueSerializer(valueType);
        if (ser != null) {
            return ser;
        }
        ser = this._serializerCache.typedValueSerializer(valueType);
        if (ser != null) {
            return ser;
        }
        ser = this.findValueSerializer(valueType, property);
        TypeSerializer typeSer = this._serializerFactory.createTypeSerializer(this._config, valueType);
        if (typeSer != null) {
            typeSer = typeSer.forProperty(property);
            ser = new TypeWrappedSerializer(typeSer, ser);
        }
        if (cache) {
            this._serializerCache.addTypedSerializer(valueType, ser);
        }
        return ser;
    }

    public JsonSerializer<Object> findKeySerializer(JavaType keyType, BeanProperty property) throws JsonMappingException {
        JsonSerializer<Object> ser = this._serializerFactory.createKeySerializer(this._config, keyType, this._keySerializer);
        return this._handleContextualResolvable(ser, property);
    }

    public JsonSerializer<Object> getDefaultNullKeySerializer() {
        return this._nullKeySerializer;
    }

    public JsonSerializer<Object> getDefaultNullValueSerializer() {
        return this._nullValueSerializer;
    }

    public JsonSerializer<Object> findNullKeySerializer(JavaType serializationType, BeanProperty property) throws JsonMappingException {
        return this._nullKeySerializer;
    }

    public JsonSerializer<Object> findNullValueSerializer(BeanProperty property) throws JsonMappingException {
        return this._nullValueSerializer;
    }

    public JsonSerializer<Object> getUnknownTypeSerializer(Class<?> unknownType) {
        return this._unknownTypeSerializer;
    }

    public boolean isUnknownTypeSerializer(JsonSerializer<?> ser) {
        return ser == this._unknownTypeSerializer || ser == null;
    }

    public abstract JsonSerializer<Object> serializerInstance(Annotated var1, Object var2) throws JsonMappingException;

    public JsonSerializer<?> handlePrimaryContextualization(JsonSerializer<?> ser, BeanProperty property) throws JsonMappingException {
        if (ser != null && ser instanceof ContextualSerializer) {
            ser = ((ContextualSerializer)((Object)ser)).createContextual(this, property);
        }
        return ser;
    }

    public JsonSerializer<?> handleSecondaryContextualization(JsonSerializer<?> ser, BeanProperty property) throws JsonMappingException {
        if (ser != null && ser instanceof ContextualSerializer) {
            ser = ((ContextualSerializer)((Object)ser)).createContextual(this, property);
        }
        return ser;
    }

    public final void defaultSerializeValue(Object value, JsonGenerator jgen) throws IOException {
        if (value == null) {
            if (this._stdNullValueSerializer) {
                jgen.writeNull();
            } else {
                this._nullValueSerializer.serialize(null, jgen, this);
            }
        } else {
            Class<?> cls = value.getClass();
            this.findTypedValueSerializer(cls, true, null).serialize(value, jgen, this);
        }
    }

    public final void defaultSerializeField(String fieldName, Object value, JsonGenerator jgen) throws IOException {
        jgen.writeFieldName(fieldName);
        if (value == null) {
            if (this._stdNullValueSerializer) {
                jgen.writeNull();
            } else {
                this._nullValueSerializer.serialize(null, jgen, this);
            }
        } else {
            Class<?> cls = value.getClass();
            this.findTypedValueSerializer(cls, true, null).serialize(value, jgen, this);
        }
    }

    public final void defaultSerializeDateValue(long timestamp, JsonGenerator jgen) throws IOException {
        if (this.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            jgen.writeNumber(timestamp);
        } else {
            jgen.writeString(this._dateFormat().format(new Date(timestamp)));
        }
    }

    public final void defaultSerializeDateValue(Date date, JsonGenerator jgen) throws IOException {
        if (this.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            jgen.writeNumber(date.getTime());
        } else {
            jgen.writeString(this._dateFormat().format(date));
        }
    }

    public void defaultSerializeDateKey(long timestamp, JsonGenerator jgen) throws IOException {
        if (this.isEnabled(SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS)) {
            jgen.writeFieldName(String.valueOf(timestamp));
        } else {
            jgen.writeFieldName(this._dateFormat().format(new Date(timestamp)));
        }
    }

    public void defaultSerializeDateKey(Date date, JsonGenerator jgen) throws IOException {
        if (this.isEnabled(SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS)) {
            jgen.writeFieldName(String.valueOf(date.getTime()));
        } else {
            jgen.writeFieldName(this._dateFormat().format(date));
        }
    }

    public final void defaultSerializeNull(JsonGenerator jgen) throws IOException {
        if (this._stdNullValueSerializer) {
            jgen.writeNull();
        } else {
            this._nullValueSerializer.serialize(null, jgen, this);
        }
    }

    public JsonMappingException mappingException(String message, Object ... args) {
        if (args != null && args.length > 0) {
            message = String.format(message, args);
        }
        return new JsonMappingException(message);
    }

    protected void _reportIncompatibleRootType(Object value, JavaType rootType) throws IOException, JsonProcessingException {
        Class<?> wrapperType;
        if (rootType.isPrimitive() && (wrapperType = ClassUtil.wrapperType(rootType.getRawClass())).isAssignableFrom(value.getClass())) {
            return;
        }
        throw new JsonMappingException("Incompatible types: declared root type (" + rootType + ") vs " + value.getClass().getName());
    }

    protected JsonSerializer<Object> _findExplicitUntypedSerializer(Class<?> runtimeType) throws JsonMappingException {
        JsonSerializer<Object> ser = this._knownSerializers.untypedValueSerializer(runtimeType);
        if (ser == null && (ser = this._serializerCache.untypedValueSerializer(runtimeType)) == null) {
            ser = this._createAndCacheUntypedSerializer(runtimeType);
        }
        if (this.isUnknownTypeSerializer(ser)) {
            return null;
        }
        return ser;
    }

    protected JsonSerializer<Object> _createAndCacheUntypedSerializer(Class<?> rawType) throws JsonMappingException {
        JsonSerializer<Object> ser;
        JavaType type = this._config.constructType(rawType);
        try {
            ser = this._createUntypedSerializer(type);
        }
        catch (IllegalArgumentException iae) {
            throw new JsonMappingException(iae.getMessage(), null, iae);
        }
        if (ser != null) {
            this._serializerCache.addAndResolveNonTypedSerializer(type, ser, this);
        }
        return ser;
    }

    protected JsonSerializer<Object> _createAndCacheUntypedSerializer(JavaType type) throws JsonMappingException {
        JsonSerializer<Object> ser;
        try {
            ser = this._createUntypedSerializer(type);
        }
        catch (IllegalArgumentException iae) {
            throw new JsonMappingException(iae.getMessage(), null, iae);
        }
        if (ser != null) {
            this._serializerCache.addAndResolveNonTypedSerializer(type, ser, this);
        }
        return ser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonSerializer<Object> _createUntypedSerializer(JavaType type) throws JsonMappingException {
        SerializerCache serializerCache = this._serializerCache;
        synchronized (serializerCache) {
            return this._serializerFactory.createSerializer(this, type);
        }
    }

    protected JsonSerializer<Object> _handleContextualResolvable(JsonSerializer<?> ser, BeanProperty property) throws JsonMappingException {
        if (ser instanceof ResolvableSerializer) {
            ((ResolvableSerializer)((Object)ser)).resolve(this);
        }
        return this.handleSecondaryContextualization(ser, property);
    }

    protected JsonSerializer<Object> _handleResolvable(JsonSerializer<?> ser) throws JsonMappingException {
        if (ser instanceof ResolvableSerializer) {
            ((ResolvableSerializer)((Object)ser)).resolve(this);
        }
        return ser;
    }

    protected final DateFormat _dateFormat() {
        if (this._dateFormat != null) {
            return this._dateFormat;
        }
        DateFormat df = this._config.getDateFormat();
        this._dateFormat = df = (DateFormat)df.clone();
        return df;
    }
}

