/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.spin.impl.xml.dom.format;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import org.camunda.spin.impl.xml.dom.DomXmlAttribute;
import org.camunda.spin.impl.xml.dom.DomXmlElement;
import org.camunda.spin.impl.xml.dom.DomXmlLogger;
import org.camunda.spin.impl.xml.dom.format.DomXmlDataFormatMapper;
import org.camunda.spin.impl.xml.dom.format.DomXmlDataFormatReader;
import org.camunda.spin.impl.xml.dom.format.DomXmlDataFormatWriter;
import org.camunda.spin.impl.xml.dom.format.spi.DefaultJaxBContextProvider;
import org.camunda.spin.impl.xml.dom.format.spi.JaxBContextProvider;
import org.camunda.spin.spi.DataFormat;
import org.camunda.spin.xml.SpinXmlAttribute;
import org.camunda.spin.xml.SpinXmlElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class DomXmlDataFormat
implements DataFormat<SpinXmlElement> {
    protected static final DomXmlLogger LOG = DomXmlLogger.XML_DOM_LOGGER;
    protected DocumentBuilderFactory documentBuilderFactory;
    protected TransformerFactory transformerFactory;
    protected JaxBContextProvider jaxBContextProvider;
    protected DomXmlDataFormatReader reader;
    protected DomXmlDataFormatWriter writer;
    protected DomXmlDataFormatMapper mapper;
    protected final String name;

    public DomXmlDataFormat(String name) {
        this(name, DomXmlDataFormat.defaultDocumentBuilderFactory());
    }

    public DomXmlDataFormat(String name, JaxBContextProvider contextProvider) {
        this(name, DomXmlDataFormat.defaultDocumentBuilderFactory(), contextProvider);
    }

    public DomXmlDataFormat(String name, DocumentBuilderFactory documentBuilderFactory, JaxBContextProvider contextProvider) {
        this(name, documentBuilderFactory, DomXmlDataFormat.defaultTransformerFactory(), contextProvider);
    }

    public DomXmlDataFormat(String name, DocumentBuilderFactory documentBuilderFactory) {
        this(name, documentBuilderFactory, DomXmlDataFormat.defaultTransformerFactory(), DomXmlDataFormat.defaultJaxBContextProvider());
    }

    public DomXmlDataFormat(String name, DocumentBuilderFactory documentBuilderFactory, TransformerFactory transformerFactory, JaxBContextProvider contextProvider) {
        this.name = name;
        this.documentBuilderFactory = documentBuilderFactory;
        LOG.usingDocumentBuilderFactory(documentBuilderFactory.getClass().getName());
        this.transformerFactory = transformerFactory;
        this.jaxBContextProvider = contextProvider;
        this.init();
    }

    protected void init() {
        this.reader = new DomXmlDataFormatReader(this);
        this.writer = new DomXmlDataFormatWriter(this);
        this.mapper = new DomXmlDataFormatMapper(this);
    }

    @Override
    public Class<? extends SpinXmlElement> getWrapperType() {
        return DomXmlElement.class;
    }

    @Override
    public SpinXmlElement createWrapperInstance(Object parameter) {
        return this.createElementWrapper((Element)parameter);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public SpinXmlElement createElementWrapper(Element element) {
        return new DomXmlElement(element, this);
    }

    public SpinXmlAttribute createAttributeWrapper(Attr attr) {
        return new DomXmlAttribute(attr, this);
    }

    @Override
    public DomXmlDataFormatReader getReader() {
        return this.reader;
    }

    @Override
    public DomXmlDataFormatWriter getWriter() {
        return this.writer;
    }

    @Override
    public DomXmlDataFormatMapper getMapper() {
        return this.mapper;
    }

    public DocumentBuilderFactory getDocumentBuilderFactory() {
        return this.documentBuilderFactory;
    }

    public TransformerFactory getTransformerFactory() {
        return this.transformerFactory;
    }

    public JaxBContextProvider getJaxBContextProvider() {
        return this.jaxBContextProvider;
    }

    public void setDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        this.documentBuilderFactory = documentBuilderFactory;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    public void setJaxBContextProvider(JaxBContextProvider jaxBContextProvider) {
        this.jaxBContextProvider = jaxBContextProvider;
    }

    public static TransformerFactory defaultTransformerFactory() {
        return TransformerFactory.newInstance();
    }

    public static DocumentBuilderFactory defaultDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        LOG.documentBuilderFactoryConfiguration("namespaceAware", "true");
        documentBuilderFactory.setValidating(false);
        LOG.documentBuilderFactoryConfiguration("validating", "false");
        documentBuilderFactory.setIgnoringComments(true);
        LOG.documentBuilderFactoryConfiguration("ignoringComments", "true");
        documentBuilderFactory.setIgnoringElementContentWhitespace(false);
        LOG.documentBuilderFactoryConfiguration("ignoringElementContentWhitespace", "false");
        return documentBuilderFactory;
    }

    public static JaxBContextProvider defaultJaxBContextProvider() {
        return new DefaultJaxBContextProvider();
    }
}

