/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.spin.impl.test;

import org.camunda.spin.SpinRuntimeException;
import org.camunda.spin.SpinScriptException;
import org.camunda.spin.impl.logging.SpinLogger;

public class SpinTestLogger
extends SpinLogger {
    public void scriptEngineFoundForLanguage(String scriptLanguage) {
        this.logInfo("001", "Script engine found for script language '{}'", new Object[]{scriptLanguage});
    }

    public void scriptLoaded(String scriptPath) {
        this.logInfo("002", "Script loaded with filename '{}'", new Object[]{scriptPath});
    }

    public void scriptVariableFound(String name, String type, String value) {
        this.logInfo("003", "Script variable found with name '{}', type '{}' and value '{}'", new Object[]{name, type, value});
    }

    public void noScriptExtensionFoundForScriptLanguage(String languageName) {
        this.logWarn("004", "No script extension found for script language '{}'", new Object[]{languageName});
    }

    public void testDisabled(String reason) {
        this.logInfo("005", "Test disabled because '{}'", new Object[]{reason});
    }

    public void executeScriptWithScriptEngine(String scriptPath, String engineName) {
        this.logInfo("006", "Execute script '{}' with script engine '{}'", new Object[]{scriptPath, engineName});
    }

    public SpinScriptException noScriptEngineFoundForLanguage(String scriptLanguage) {
        return new SpinScriptException(this.exceptionMessage("002", "No script engine found for script language '{}'", new Object[]{scriptLanguage}));
    }

    public SpinScriptException scriptExecutionError(String scriptPath, Throwable cause) {
        return new SpinScriptException(this.exceptionMessage("004", "Error during execution of script '{}'", new Object[]{scriptPath}), cause);
    }

    public SpinScriptException cannotCastVariableError(String name, Throwable e) {
        return new SpinScriptException(this.exceptionMessage("005", "Cannot cast variable '{}', wrong type", new Object[]{name}), e);
    }

    public SpinScriptException unableToUnwrapRhinoJsVariable(String name, Throwable e) {
        return new SpinScriptException(this.exceptionMessage("006", "Unable to unwrap rhinojs variable with name '{}'", new Object[]{name}), e);
    }

    public SpinScriptException unableToFindUnwrapMethod(Throwable e) {
        return new SpinScriptException(this.exceptionMessage("007", "Unable to find unwrap method of NativeJavaObject", new Object[0]));
    }

    public SpinRuntimeException unableToUnwrapRhinoJsWrappedException(String message) {
        return new SpinScriptException(this.exceptionMessage("008", "Unable to unwrap rhinojs wrapped exception with message '{}'", new Object[]{message}));
    }
}

