/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.spin.impl.json.jackson.format;

import java.io.IOException;
import java.io.Writer;
import org.camunda.spin.impl.json.jackson.JacksonJsonLogger;
import org.camunda.spin.impl.json.jackson.format.JacksonJsonDataFormat;
import org.camunda.spin.spi.DataFormatWriter;
import spinjar.com.fasterxml.jackson.core.JsonFactory;
import spinjar.com.fasterxml.jackson.core.JsonGenerator;
import spinjar.com.fasterxml.jackson.databind.JsonNode;
import spinjar.com.fasterxml.jackson.databind.ObjectMapper;

public class JacksonJsonDataFormatWriter
implements DataFormatWriter {
    private static final JacksonJsonLogger LOG = JacksonJsonLogger.JSON_TREE_LOGGER;
    protected JacksonJsonDataFormat dataFormat;

    public JacksonJsonDataFormatWriter(JacksonJsonDataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    @Override
    public void writeToWriter(Writer writer, Object input) {
        ObjectMapper objectMapper = this.dataFormat.getObjectMapper();
        JsonFactory factory = objectMapper.getFactory();
        try {
            JsonGenerator generator = factory.createGenerator(writer);
            objectMapper.writeTree(generator, (JsonNode)input);
        }
        catch (IOException e) {
            throw LOG.unableToWriteJsonNode(e);
        }
    }
}

