/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.spin.impl;

import java.io.IOException;
import java.io.Reader;
import org.camunda.commons.utils.EnsureUtil;
import org.camunda.spin.DataFormats;
import org.camunda.spin.Spin;
import org.camunda.spin.SpinFactory;
import org.camunda.spin.impl.logging.SpinCoreLogger;
import org.camunda.spin.impl.util.RewindableReader;
import org.camunda.spin.impl.util.SpinIoUtil;
import org.camunda.spin.spi.DataFormat;
import org.camunda.spin.spi.DataFormatMapper;
import org.camunda.spin.spi.DataFormatReader;

public class SpinFactoryImpl
extends SpinFactory {
    private static final SpinCoreLogger LOG = SpinCoreLogger.CORE_LOGGER;
    private static final int READ_SIZE = 256;

    @Override
    public <T extends Spin<?>> T createSpin(Object parameter) {
        EnsureUtil.ensureNotNull((String)"parameter", (Object)parameter);
        if (parameter instanceof String) {
            return this.createSpinFromString((String)parameter);
        }
        if (parameter instanceof Reader) {
            return this.createSpinFromReader((Reader)parameter);
        }
        if (parameter instanceof Spin) {
            return (T)this.createSpinFromSpin((Spin)parameter);
        }
        throw LOG.unsupportedInputParameter(parameter.getClass());
    }

    @Override
    public <T extends Spin<?>> T createSpin(Object parameter, DataFormat<T> format) {
        EnsureUtil.ensureNotNull((String)"parameter", (Object)parameter);
        EnsureUtil.ensureNotNull((String)"format", format);
        if (parameter instanceof String) {
            return this.createSpinFromString((String)parameter, format);
        }
        if (parameter instanceof Reader) {
            return this.createSpinFromReader((Reader)parameter, format);
        }
        if (parameter instanceof Spin) {
            return (T)this.createSpinFromSpin((Spin)parameter, format);
        }
        return this.createSpinFromObject(parameter, format);
    }

    @Override
    public <T extends Spin<?>> T createSpin(Object parameter, String dataFormatName) {
        EnsureUtil.ensureNotNull((String)"dataFormatName", (Object)dataFormatName);
        DataFormat<? extends Spin<?>> dataFormat = DataFormats.getDataFormat(dataFormatName);
        return (T)this.createSpin(parameter, dataFormat);
    }

    public <T extends Spin<?>> T createSpinFromSpin(T parameter) {
        EnsureUtil.ensureNotNull((String)"parameter", parameter);
        return parameter;
    }

    public <T extends Spin<?>> T createSpinFromString(String parameter) {
        EnsureUtil.ensureNotNull((String)"parameter", (Object)parameter);
        Reader input = SpinIoUtil.stringAsReader(parameter);
        return this.createSpin(input);
    }

    public <T extends Spin<?>> T createSpinFromReader(Reader parameter) {
        EnsureUtil.ensureNotNull((String)"parameter", (Object)parameter);
        RewindableReader rewindableReader = new RewindableReader(parameter, 256);
        DataFormat<Spin<?>> matchingDataFormat = null;
        for (DataFormat<Spin<?>> format : DataFormats.getAvailableDataFormats()) {
            if (format.getReader().canRead(rewindableReader, rewindableReader.getRewindBufferSize())) {
                matchingDataFormat = format;
            }
            try {
                rewindableReader.rewind();
            }
            catch (IOException e) {
                throw LOG.unableToReadFromReader(e);
            }
        }
        if (matchingDataFormat == null) {
            throw LOG.unrecognizableDataFormatException();
        }
        return this.createSpin((Object)rewindableReader, matchingDataFormat);
    }

    public <T extends Spin<?>> T createSpinFromSpin(T parameter, DataFormat<T> format) {
        EnsureUtil.ensureNotNull((String)"parameter", parameter);
        return parameter;
    }

    public <T extends Spin<?>> T createSpinFromString(String parameter, DataFormat<T> format) {
        EnsureUtil.ensureNotNull((String)"parameter", (Object)parameter);
        Reader input = SpinIoUtil.stringAsReader(parameter);
        return this.createSpin((Object)input, format);
    }

    public <T extends Spin<?>> T createSpinFromReader(Reader parameter, DataFormat<T> format) {
        EnsureUtil.ensureNotNull((String)"parameter", (Object)parameter);
        DataFormatReader reader = format.getReader();
        Object dataFormatInput = reader.readInput(parameter);
        return format.createWrapperInstance(dataFormatInput);
    }

    public <T extends Spin<?>> T createSpinFromObject(Object parameter, DataFormat<T> format) {
        EnsureUtil.ensureNotNull((String)"parameter", (Object)parameter);
        DataFormatMapper mapper = format.getMapper();
        Object dataFormatInput = mapper.mapJavaToInternal(parameter);
        return format.createWrapperInstance(dataFormatInput);
    }
}

