/*
 * Decompiled with CFR 0.152.
 */
package spinjar.com.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import spinjar.com.fasterxml.jackson.core.JsonGenerationException;
import spinjar.com.fasterxml.jackson.core.JsonGenerator;
import spinjar.com.fasterxml.jackson.databind.JavaType;
import spinjar.com.fasterxml.jackson.databind.JsonMappingException;
import spinjar.com.fasterxml.jackson.databind.JsonNode;
import spinjar.com.fasterxml.jackson.databind.SerializerProvider;
import spinjar.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import spinjar.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import spinjar.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import spinjar.com.fasterxml.jackson.databind.ser.std.StdSerializer;

@JacksonStdImpl
public class ToStringSerializer
extends StdSerializer<Object> {
    public static final ToStringSerializer instance = new ToStringSerializer();

    public ToStringSerializer() {
        super(Object.class);
    }

    @Override
    public boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        String str = value.toString();
        return str == null || str.length() == 0;
    }

    @Override
    public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeString(value.toString());
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        typeSer.writeTypePrefixForScalar(value, jgen);
        this.serialize(value, jgen, provider);
        typeSer.writeTypeSuffixForScalar(value, jgen);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        if (visitor != null) {
            visitor.expectStringFormat(typeHint);
        }
    }
}

