/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.spin.impl.test;

import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptEngineManager;
import org.camunda.spin.impl.logging.SpinLogger;
import org.camunda.spin.impl.test.ScriptEngine;
import org.camunda.spin.impl.test.SpinTestLogger;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ScriptEngineRule
implements TestRule {
    private static final SpinTestLogger LOG = SpinLogger.TEST_LOGGER;
    private javax.script.ScriptEngine scriptEngine;
    private static final Map<String, javax.script.ScriptEngine> cachedEngines = new HashMap<String, javax.script.ScriptEngine>();

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ScriptEngineRule.this.scriptEngine = ScriptEngineRule.this.createScriptEngine(description);
                if (ScriptEngineRule.this.scriptEngine != null) {
                    LOG.scriptEngineFoundForLanguage(ScriptEngineRule.this.scriptEngine.getFactory().getLanguageName());
                }
                base.evaluate();
            }
        };
    }

    private javax.script.ScriptEngine createScriptEngine(Description description) {
        ScriptEngine annotation = description.getTestClass().getAnnotation(ScriptEngine.class);
        if (annotation == null) {
            return null;
        }
        String language = annotation.value();
        if (!cachedEngines.containsKey(language)) {
            javax.script.ScriptEngine engine = new ScriptEngineManager().getEngineByName(language);
            if (engine == null) {
                throw LOG.noScriptEngineFoundForLanguage(language);
            }
            cachedEngines.put(language, engine);
        }
        return cachedEngines.get(language);
    }

    public javax.script.ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }
}

