/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.AbstractVendorVersionInformationDto;
import org.camunda.community.rest.client.dto.TelemetryCountDto;
import org.camunda.community.rest.client.dto.TelemetryLicenseKeyDto;

public class TelemetryInternalsDto {
    public static final String SERIALIZED_NAME_DATABASE = "database";
    @SerializedName(value="database")
    private Map<String, AbstractVendorVersionInformationDto> database = null;
    public static final String SERIALIZED_NAME_APPLICATION_SERVER = "application-server";
    @SerializedName(value="application-server")
    private Map<String, AbstractVendorVersionInformationDto> applicationServer = null;
    public static final String SERIALIZED_NAME_LICENSE_KEY = "license-key";
    @SerializedName(value="license-key")
    private Map<String, TelemetryLicenseKeyDto> licenseKey = null;
    public static final String SERIALIZED_NAME_CAMUNDA_INTEGRATION = "camunda-integration";
    @SerializedName(value="camunda-integration")
    private List<String> camundaIntegration = null;
    public static final String SERIALIZED_NAME_COMMANDS = "commands";
    @SerializedName(value="commands")
    private Map<String, TelemetryCountDto> commands = null;
    public static final String SERIALIZED_NAME_METRICS = "metrics";
    @SerializedName(value="metrics")
    private Map<String, TelemetryCountDto> metrics = null;
    public static final String SERIALIZED_NAME_WEBAPPS = "webapps";
    @SerializedName(value="webapps")
    private List<String> webapps = null;
    public static final String SERIALIZED_NAME_JDK = "jdk";
    @SerializedName(value="jdk")
    private Map<String, AbstractVendorVersionInformationDto> jdk = null;

    public TelemetryInternalsDto database(Map<String, AbstractVendorVersionInformationDto> database) {
        this.database = database;
        return this;
    }

    public TelemetryInternalsDto putDatabaseItem(String key, AbstractVendorVersionInformationDto databaseItem) {
        if (this.database == null) {
            this.database = new HashMap<String, AbstractVendorVersionInformationDto>();
        }
        this.database.put(key, databaseItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Vendor and version of the connected database.")
    public Map<String, AbstractVendorVersionInformationDto> getDatabase() {
        return this.database;
    }

    public void setDatabase(Map<String, AbstractVendorVersionInformationDto> database) {
        this.database = database;
    }

    public TelemetryInternalsDto applicationServer(Map<String, AbstractVendorVersionInformationDto> applicationServer) {
        this.applicationServer = applicationServer;
        return this;
    }

    public TelemetryInternalsDto putApplicationServerItem(String key, AbstractVendorVersionInformationDto applicationServerItem) {
        if (this.applicationServer == null) {
            this.applicationServer = new HashMap<String, AbstractVendorVersionInformationDto>();
        }
        this.applicationServer.put(key, applicationServerItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Vendor and version of the application server.")
    public Map<String, AbstractVendorVersionInformationDto> getApplicationServer() {
        return this.applicationServer;
    }

    public void setApplicationServer(Map<String, AbstractVendorVersionInformationDto> applicationServer) {
        this.applicationServer = applicationServer;
    }

    public TelemetryInternalsDto licenseKey(Map<String, TelemetryLicenseKeyDto> licenseKey) {
        this.licenseKey = licenseKey;
        return this;
    }

    public TelemetryInternalsDto putLicenseKeyItem(String key, TelemetryLicenseKeyDto licenseKeyItem) {
        if (this.licenseKey == null) {
            this.licenseKey = new HashMap<String, TelemetryLicenseKeyDto>();
        }
        this.licenseKey.put(key, licenseKeyItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Information about the Camunda license key.")
    public Map<String, TelemetryLicenseKeyDto> getLicenseKey() {
        return this.licenseKey;
    }

    public void setLicenseKey(Map<String, TelemetryLicenseKeyDto> licenseKey) {
        this.licenseKey = licenseKey;
    }

    public TelemetryInternalsDto camundaIntegration(List<String> camundaIntegration) {
        this.camundaIntegration = camundaIntegration;
        return this;
    }

    public TelemetryInternalsDto addCamundaIntegrationItem(String camundaIntegrationItem) {
        if (this.camundaIntegration == null) {
            this.camundaIntegration = new ArrayList<String>();
        }
        this.camundaIntegration.add(camundaIntegrationItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of Camunda integrations used (e.g., Camunda Spring Boot Starter, Camunda Run, WildFly/JBoss subsystem, Camunda EJB).")
    public List<String> getCamundaIntegration() {
        return this.camundaIntegration;
    }

    public void setCamundaIntegration(List<String> camundaIntegration) {
        this.camundaIntegration = camundaIntegration;
    }

    public TelemetryInternalsDto commands(Map<String, TelemetryCountDto> commands) {
        this.commands = commands;
        return this;
    }

    public TelemetryInternalsDto putCommandsItem(String key, TelemetryCountDto commandsItem) {
        if (this.commands == null) {
            this.commands = new HashMap<String, TelemetryCountDto>();
        }
        this.commands.put(key, commandsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The count of executed commands after the last retrieved data.")
    public Map<String, TelemetryCountDto> getCommands() {
        return this.commands;
    }

    public void setCommands(Map<String, TelemetryCountDto> commands) {
        this.commands = commands;
    }

    public TelemetryInternalsDto metrics(Map<String, TelemetryCountDto> metrics) {
        this.metrics = metrics;
        return this;
    }

    public TelemetryInternalsDto putMetricsItem(String key, TelemetryCountDto metricsItem) {
        if (this.metrics == null) {
            this.metrics = new HashMap<String, TelemetryCountDto>();
        }
        this.metrics.put(key, metricsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The collected metrics are the number of root process instance executions started, the number of activity instances started or also known as flow node instances, and the number of executed decision instances and elements.")
    public Map<String, TelemetryCountDto> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Map<String, TelemetryCountDto> metrics) {
        this.metrics = metrics;
    }

    public TelemetryInternalsDto webapps(List<String> webapps) {
        this.webapps = webapps;
        return this;
    }

    public TelemetryInternalsDto addWebappsItem(String webappsItem) {
        if (this.webapps == null) {
            this.webapps = new ArrayList<String>();
        }
        this.webapps.add(webappsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The webapps enabled in this installation of Camunda.")
    public List<String> getWebapps() {
        return this.webapps;
    }

    public void setWebapps(List<String> webapps) {
        this.webapps = webapps;
    }

    public TelemetryInternalsDto jdk(Map<String, AbstractVendorVersionInformationDto> jdk) {
        this.jdk = jdk;
        return this;
    }

    public TelemetryInternalsDto putJdkItem(String key, AbstractVendorVersionInformationDto jdkItem) {
        if (this.jdk == null) {
            this.jdk = new HashMap<String, AbstractVendorVersionInformationDto>();
        }
        this.jdk.put(key, jdkItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Vendor and version of the installed JDK.")
    public Map<String, AbstractVendorVersionInformationDto> getJdk() {
        return this.jdk;
    }

    public void setJdk(Map<String, AbstractVendorVersionInformationDto> jdk) {
        this.jdk = jdk;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TelemetryInternalsDto telemetryInternalsDto = (TelemetryInternalsDto)o;
        return Objects.equals(this.database, telemetryInternalsDto.database) && Objects.equals(this.applicationServer, telemetryInternalsDto.applicationServer) && Objects.equals(this.licenseKey, telemetryInternalsDto.licenseKey) && Objects.equals(this.camundaIntegration, telemetryInternalsDto.camundaIntegration) && Objects.equals(this.commands, telemetryInternalsDto.commands) && Objects.equals(this.metrics, telemetryInternalsDto.metrics) && Objects.equals(this.webapps, telemetryInternalsDto.webapps) && Objects.equals(this.jdk, telemetryInternalsDto.jdk);
    }

    public int hashCode() {
        return Objects.hash(this.database, this.applicationServer, this.licenseKey, this.camundaIntegration, this.commands, this.metrics, this.webapps, this.jdk);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TelemetryInternalsDto {\n");
        sb.append("    database: ").append(this.toIndentedString(this.database)).append("\n");
        sb.append("    applicationServer: ").append(this.toIndentedString(this.applicationServer)).append("\n");
        sb.append("    licenseKey: ").append(this.toIndentedString(this.licenseKey)).append("\n");
        sb.append("    camundaIntegration: ").append(this.toIndentedString(this.camundaIntegration)).append("\n");
        sb.append("    commands: ").append(this.toIndentedString(this.commands)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    webapps: ").append(this.toIndentedString(this.webapps)).append("\n");
        sb.append("    jdk: ").append(this.toIndentedString(this.jdk)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

