/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.AtomLink;
import org.camunda.community.rest.client.dto.VariableValueDto;

public class ProcessInstanceWithVariablesDto {
    public static final String SERIALIZED_NAME_VARIABLES = "variables";
    @SerializedName(value="variables")
    private Map<String, VariableValueDto> variables = null;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_DEFINITION_ID = "definitionId";
    @SerializedName(value="definitionId")
    private String definitionId;
    public static final String SERIALIZED_NAME_BUSINESS_KEY = "businessKey";
    @SerializedName(value="businessKey")
    private String businessKey;
    public static final String SERIALIZED_NAME_CASE_INSTANCE_ID = "caseInstanceId";
    @SerializedName(value="caseInstanceId")
    private String caseInstanceId;
    public static final String SERIALIZED_NAME_ENDED = "ended";
    @SerializedName(value="ended")
    private Boolean ended;
    public static final String SERIALIZED_NAME_SUSPENDED = "suspended";
    @SerializedName(value="suspended")
    private Boolean suspended;
    public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
    @SerializedName(value="tenantId")
    private String tenantId;
    public static final String SERIALIZED_NAME_LINKS = "links";
    @SerializedName(value="links")
    private List<AtomLink> links = null;

    public ProcessInstanceWithVariablesDto variables(Map<String, VariableValueDto> variables) {
        this.variables = variables;
        return this;
    }

    public ProcessInstanceWithVariablesDto putVariablesItem(String key, VariableValueDto variablesItem) {
        if (this.variables == null) {
            this.variables = new HashMap<String, VariableValueDto>();
        }
        this.variables.put(key, variablesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process instance.")
    public Map<String, VariableValueDto> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, VariableValueDto> variables) {
        this.variables = variables;
    }

    public ProcessInstanceWithVariablesDto id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process instance.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ProcessInstanceWithVariablesDto definitionId(String definitionId) {
        this.definitionId = definitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process definition that this process instance belongs to.")
    public String getDefinitionId() {
        return this.definitionId;
    }

    public void setDefinitionId(String definitionId) {
        this.definitionId = definitionId;
    }

    public ProcessInstanceWithVariablesDto businessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The business key of the process instance.")
    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public ProcessInstanceWithVariablesDto caseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the case instance associated with the process instance.")
    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    public ProcessInstanceWithVariablesDto ended(Boolean ended) {
        this.ended = ended;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A flag indicating whether the process instance has ended or not. Deprecated: will always be false!")
    public Boolean getEnded() {
        return this.ended;
    }

    public void setEnded(Boolean ended) {
        this.ended = ended;
    }

    public ProcessInstanceWithVariablesDto suspended(Boolean suspended) {
        this.suspended = suspended;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A flag indicating whether the process instance is suspended or not.")
    public Boolean getSuspended() {
        return this.suspended;
    }

    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    public ProcessInstanceWithVariablesDto tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The tenant id of the process instance.")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public ProcessInstanceWithVariablesDto links(List<AtomLink> links) {
        this.links = links;
        return this;
    }

    public ProcessInstanceWithVariablesDto addLinksItem(AtomLink linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<AtomLink>();
        }
        this.links.add(linksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The links associated to this resource, with `method`, `href` and `rel`.")
    public List<AtomLink> getLinks() {
        return this.links;
    }

    public void setLinks(List<AtomLink> links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessInstanceWithVariablesDto processInstanceWithVariablesDto = (ProcessInstanceWithVariablesDto)o;
        return Objects.equals(this.variables, processInstanceWithVariablesDto.variables) && Objects.equals(this.id, processInstanceWithVariablesDto.id) && Objects.equals(this.definitionId, processInstanceWithVariablesDto.definitionId) && Objects.equals(this.businessKey, processInstanceWithVariablesDto.businessKey) && Objects.equals(this.caseInstanceId, processInstanceWithVariablesDto.caseInstanceId) && Objects.equals(this.ended, processInstanceWithVariablesDto.ended) && Objects.equals(this.suspended, processInstanceWithVariablesDto.suspended) && Objects.equals(this.tenantId, processInstanceWithVariablesDto.tenantId) && Objects.equals(this.links, processInstanceWithVariablesDto.links);
    }

    public int hashCode() {
        return Objects.hash(this.variables, this.id, this.definitionId, this.businessKey, this.caseInstanceId, this.ended, this.suspended, this.tenantId, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessInstanceWithVariablesDto {\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    definitionId: ").append(this.toIndentedString(this.definitionId)).append("\n");
        sb.append("    businessKey: ").append(this.toIndentedString(this.businessKey)).append("\n");
        sb.append("    caseInstanceId: ").append(this.toIndentedString(this.caseInstanceId)).append("\n");
        sb.append("    ended: ").append(this.toIndentedString(this.ended)).append("\n");
        sb.append("    suspended: ").append(this.toIndentedString(this.suspended)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

