/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class MigrationInstructionDto {
    public static final String SERIALIZED_NAME_SOURCE_ACTIVITY_IDS = "sourceActivityIds";
    @SerializedName(value="sourceActivityIds")
    private List<String> sourceActivityIds = null;
    public static final String SERIALIZED_NAME_TARGET_ACTIVITY_IDS = "targetActivityIds";
    @SerializedName(value="targetActivityIds")
    private List<String> targetActivityIds = null;
    public static final String SERIALIZED_NAME_UPDATE_EVENT_TRIGGER = "updateEventTrigger";
    @SerializedName(value="updateEventTrigger")
    private Boolean updateEventTrigger;

    public MigrationInstructionDto sourceActivityIds(List<String> sourceActivityIds) {
        this.sourceActivityIds = sourceActivityIds;
        return this;
    }

    public MigrationInstructionDto addSourceActivityIdsItem(String sourceActivityIdsItem) {
        if (this.sourceActivityIds == null) {
            this.sourceActivityIds = new ArrayList<String>();
        }
        this.sourceActivityIds.add(sourceActivityIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The activity ids from the source process definition being mapped.")
    public List<String> getSourceActivityIds() {
        return this.sourceActivityIds;
    }

    public void setSourceActivityIds(List<String> sourceActivityIds) {
        this.sourceActivityIds = sourceActivityIds;
    }

    public MigrationInstructionDto targetActivityIds(List<String> targetActivityIds) {
        this.targetActivityIds = targetActivityIds;
        return this;
    }

    public MigrationInstructionDto addTargetActivityIdsItem(String targetActivityIdsItem) {
        if (this.targetActivityIds == null) {
            this.targetActivityIds = new ArrayList<String>();
        }
        this.targetActivityIds.add(targetActivityIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The activity ids from the target process definition being mapped.")
    public List<String> getTargetActivityIds() {
        return this.targetActivityIds;
    }

    public void setTargetActivityIds(List<String> targetActivityIds) {
        this.targetActivityIds = targetActivityIds;
    }

    public MigrationInstructionDto updateEventTrigger(Boolean updateEventTrigger) {
        this.updateEventTrigger = updateEventTrigger;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Configuration flag whether event triggers defined are going to be updated during migration.")
    public Boolean getUpdateEventTrigger() {
        return this.updateEventTrigger;
    }

    public void setUpdateEventTrigger(Boolean updateEventTrigger) {
        this.updateEventTrigger = updateEventTrigger;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrationInstructionDto migrationInstructionDto = (MigrationInstructionDto)o;
        return Objects.equals(this.sourceActivityIds, migrationInstructionDto.sourceActivityIds) && Objects.equals(this.targetActivityIds, migrationInstructionDto.targetActivityIds) && Objects.equals(this.updateEventTrigger, migrationInstructionDto.updateEventTrigger);
    }

    public int hashCode() {
        return Objects.hash(this.sourceActivityIds, this.targetActivityIds, this.updateEventTrigger);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MigrationInstructionDto {\n");
        sb.append("    sourceActivityIds: ").append(this.toIndentedString(this.sourceActivityIds)).append("\n");
        sb.append("    targetActivityIds: ").append(this.toIndentedString(this.targetActivityIds)).append("\n");
        sb.append("    updateEventTrigger: ").append(this.toIndentedString(this.updateEventTrigger)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

